#ifndef DEBUG_H
#define DEBUG_H

// #define DEBUG_ON

#include <SDL/SDL_video.h>
#include <SDL/SDL.h>

#ifdef DEBUG_ON 
#   define DEBUG(x) x

// Here's two implementations of a BlitScreen wrapper
// to test the return value and print an error if relevant..
// The inline function looks a little prettier,
// returns a value, and can be called in any context SDL_BlitSuface can.
// This might be useful in the future.
// The downside is that the __FILE__ and __LINE__ macros
// correspond to this file rather than the file including it...
// The macro, by contrast does what we want with __FILE__ and __LINE__,
// but can't be called exactly the same as SDL_BlitSurface..
// (eg if(BlitSurface(a,b,c,d)){ foo() }; will not compile....)
#if 1
#   define BlitSurface(ss,sr,ds,dr)             \
           if (0 != SDL_BlitSurface(ss,sr,ds,dr))\
               fprintf(stderr,                   \
                       "%s %d, SDL_BlitSurface failed: %s\n",\
                       __FILE__,__LINE__, SDL_GetError());\
           else  // 
#else
    inline int BlitSurface(SDL_Surface *src, SDL_Rect *srcrect,
                             SDL_Surface *dst, SDL_Rect *dstrect)
    {
               if (0 != SDL_BlitSurface(src,srcrect,dst,dstrect))
               {
                   fprintf(stderr,                  
                           "%s %d, SDL_BlitSurface failed: %s\n",
                           __FILE__,__LINE__, SDL_GetError());
                   return -1;
               }
               else
                   return 0;
    }
#endif

#else 
#   define DEBUG(x)   
#   define BlitSurface(ss,sr,ds,dr) SDL_BlitSurface(ss,sr,ds,dr)
#endif

#endif 
