/*
 * JNeuronNew.java
 *
 * Created on March 30, 2009, 3:02 PM
 */
package org.neuroph.easyneurons.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

import org.neuroph.core.Neuron;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;


/**
 *
 * @author  Zoran Sevarac <sevarac@gmail.com>
 */
public class JNeuron extends javax.swing.JPanel {
	private static final long serialVersionUID = 1L;
	
	private Neuron neuron;

	/** Creates new form JNeuronNew */
	public JNeuron() {
		initComponents();
	}

	public JNeuron(Neuron neuron) {
		this();
		this.neuron = neuron;
		this.outputField.setText(Double.toString(neuron.getOutput()));
	}
	
	@Override
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2d = (Graphics2D)g;				
		g2d.setRenderingHint (RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
								
		double output = neuron.getOutput();
		int colorIntensity =200 - Math.abs( (int)(output*100)*2);
		if (colorIntensity > 200 ) colorIntensity = 200;
		if (colorIntensity < 0 ) colorIntensity = 0;
		
		if (output>0) {
			g2d.setColor( new Color(255, colorIntensity, colorIntensity));	
		} else if (output<0) {
			g2d.setColor( new Color(colorIntensity, colorIntensity, 255));
		} else {
			g2d.setColor( new Color(102, 102, 102));
		}
								
		g2d.fillOval(5, 5, 70, 70);
				// Graphics2D g2d = (Graphics2D)g;
				// if we want to draw stroke customize the code bellow
//				g.setColor( new Color(50, 50, 50));
//				Shape circle = new Ellipse2D.Float(5f, 5f,  // Upper-left corner
//								   70f, 70f); // Width and height
//				g2d.setStroke(new BasicStroke(3f));                // Set line width
//				g2d.draw(circle);                                     // Now draw it
												
        }
	
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
        // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
        private void initComponents() {
                java.awt.GridBagConstraints gridBagConstraints;

                outputField = new javax.swing.JTextField();
                propertiesButton = new javax.swing.JButton();

                setName("Form"); // NOI18N
                setOpaque(false);
                setPreferredSize(new java.awt.Dimension(80, 80));
                setLayout(new java.awt.GridBagLayout());

                org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(JNeuron.class);
                outputField.setBackground(resourceMap.getColor("outputField.background")); // NOI18N
                outputField.setColumns(6);
                outputField.setEditable(false);
                outputField.setText(resourceMap.getString("outputField.text")); // NOI18N
                outputField.setName("outputField"); // NOI18N
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                add(outputField, gridBagConstraints);

                propertiesButton.setText(resourceMap.getString("propertiesButton.text")); // NOI18N
                propertiesButton.setName("propertiesButton"); // NOI18N
                propertiesButton.setPreferredSize(new java.awt.Dimension(33, 15));
                propertiesButton.addMouseListener(new java.awt.event.MouseAdapter() {
                        public void mousePressed(java.awt.event.MouseEvent evt) {
                                propertiesButtonMousePressed(evt);
                        }
                });
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
                add(propertiesButton, gridBagConstraints);
        }// </editor-fold>//GEN-END:initComponents

private void propertiesButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_propertiesButtonMousePressed
        EasyNeuronsApplicationView.getInstance().openNeuronPropertiesFrame(neuron);
}//GEN-LAST:event_propertiesButtonMousePressed

        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JTextField outputField;
        private javax.swing.JButton propertiesButton;
        // End of variables declaration//GEN-END:variables
}
