/*
 * JLayer.java
 *
 * Created on April 4, 2009, 11:06 PM
 */

package org.neuroph.easyneurons.view;

import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.SystemColor;

import javax.swing.BorderFactory;

/**
 *
 * @author  Zoran Sevarac <sevarac@gmail.com>
 */
public class JLayer extends javax.swing.JPanel {

    private int layerIndex;

	public int getLayerIndex() {
		return layerIndex;
	}

	public void setLayerIndex(int layerIndex) {
		this.layerIndex = layerIndex;
	}
	
    /** Creates new form JLayer */
    public JLayer() {
        initComponents();
		FlowLayout layerLayout = new FlowLayout();
		layerLayout.setHgap(40);
		layerLayout.setAlignment(FlowLayout.CENTER);
		this.setLayout(layerLayout);
		this.setBorder(BorderFactory.createEtchedBorder());
		this.setBackground(SystemColor.info);			
    }
    
    public JLayer(int size) {
        initComponents();
	
		int cols = (int) Math.sqrt(size);
		GridLayout layerLayout = new GridLayout();
		
		layerLayout.setColumns(cols);
		layerLayout.setRows(cols);
		layerLayout.setHgap(30);
		layerLayout.setVgap(30);
		this.setLayout(layerLayout);
		this.setBorder(BorderFactory.createEtchedBorder());
		this.setBackground(SystemColor.info);
    }    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    
	@Override
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);
		//Graphics2D g2d = (Graphics2D)g;
		g.drawString("Layer "+(layerIndex+1), 5, 15);
		
    }
        // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
        private void initComponents() {

                setName("Form"); // NOI18N

                javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
                this.setLayout(layout);
                layout.setHorizontalGroup(
                        layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 400, Short.MAX_VALUE)
                );
                layout.setVerticalGroup(
                        layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 300, Short.MAX_VALUE)
                );
        }// </editor-fold>//GEN-END:initComponents


        // Variables declaration - do not modify//GEN-BEGIN:variables
        // End of variables declaration//GEN-END:variables

}
