
/*
 * NewJPanel2.java
 *
 * Created on 05.01.2010., 14.00.55
 */

package org.neuroph.easyneurons.samples.mlperceptron;

import org.jdesktop.application.Action;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.TransferFunctionType;

/**
 *
 * @author Marko
 */
public class ControllsPanel extends javax.swing.JPanel {

    int netCode = 1;
    int tansfCode = 1;
   // Vector<Integer> v;
    String layer;
    NeuralNetwork neuralNet;
    TransferFunctionType funct;

    MultiLayerPerceptronSample backS;
    
    public ControllsPanel(MultiLayerPerceptronSample bs) {
        initComponents();
        initComp();
        this.backS = bs;
    }

    public void initComp()
    {
        jcbNetwork.addItem(new String(""));
        jcbNetwork.addItem(new String("Multy Perceptron"));

        jcbTransferFunction.addItem(new String("Sigmoid"));
        jcbTransferFunction.addItem(new String("Tanh"));

        layer = "2 1";

        //neuralNet = new MultiLayerPerceptron(v);
        funct = TransferFunctionType.SIGMOID;

        neuralNet = NeuralNetworkFactory.createMLPerceptron(layer, funct);

        jcbMaxIterations.setText("Max Iterations:");
        
        jbTrain.setText("Train");
        jbStop.setText("Stop");
        jbClear.setText("Clear");

        jbTrain.setSize(90,23);
        jbStop.setSize(90,23);
        jbClear.setSize(90,23);


  }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jjNetwork = new javax.swing.JLabel();
        jcbNetwork = new javax.swing.JComboBox();
        jtfMultylayer = new javax.swing.JTextField();
        jlTransferFunction = new javax.swing.JLabel();
        jcbTransferFunction = new javax.swing.JComboBox();
        jlLearningRate = new javax.swing.JLabel();
        jlMaxError = new javax.swing.JLabel();
        jlMomentum = new javax.swing.JLabel();
        jtfLearningRate = new javax.swing.JTextField();
        jtfMaxError = new javax.swing.JTextField();
        jtfMomentum = new javax.swing.JTextField();
        jbTrain = new javax.swing.JButton();
        jbStop = new javax.swing.JButton();
        jbClear = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jtfMaxIteration = new javax.swing.JTextField();
        jcbMaxIterations = new javax.swing.JCheckBox();

        setBackground(new java.awt.Color(255, 255, 255));
        setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0), 2, true));

        jjNetwork.setText("Network:");
        jjNetwork.setEnabled(false);

        jcbNetwork.setEnabled(false);
        jcbNetwork.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jcbNetworkActionPerformed(evt);
            }
        });

        jlTransferFunction.setText("Transfer function");

        jcbTransferFunction.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jcbTransferFunctionActionPerformed(evt);
            }
        });

        jlLearningRate.setText("Learning Rate:");

        jlMaxError.setText("Max Error:");

        jlMomentum.setText("Momentum:");

        jtfLearningRate.setText("0.5");

        jtfMaxError.setText("0.01");

        jtfMomentum.setText("0.0");
        jtfMomentum.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jtfMomentumActionPerformed(evt);
            }
        });

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(ControllsPanel.class, this);
        jbTrain.setAction(actionMap.get("train")); // NOI18N
        jbTrain.setBackground(new java.awt.Color(0, 255, 0));

        jbStop.setAction(actionMap.get("stop")); // NOI18N
        jbStop.setBackground(new java.awt.Color(255, 0, 0));

        jbClear.setAction(actionMap.get("clear")); // NOI18N
        jbClear.setBackground(new java.awt.Color(0, 255, 255));

        jLabel1.setText("Hiden neurons (space separated)");

        jtfMaxIteration.setEditable(false);

        jcbMaxIterations.setAction(actionMap.get("enableSetIterations")); // NOI18N
        jcbMaxIterations.setBackground(new java.awt.Color(255, 255, 255));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jtfMultylayer, javax.swing.GroupLayout.DEFAULT_SIZE, 150, Short.MAX_VALUE)
                        .addGap(32, 32, 32))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jlTransferFunction, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(92, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jcbTransferFunction, 0, 150, Short.MAX_VALUE)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addGroup(layout.createSequentialGroup()
                                                .addComponent(jlLearningRate, javax.swing.GroupLayout.DEFAULT_SIZE, 77, Short.MAX_VALUE)
                                                .addGap(27, 27, 27))
                                            .addGroup(layout.createSequentialGroup()
                                                .addComponent(jlMaxError, javax.swing.GroupLayout.DEFAULT_SIZE, 100, Short.MAX_VALUE)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                                        .addGroup(layout.createSequentialGroup()
                                            .addComponent(jlMomentum)
                                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jcbMaxIterations)
                                        .addGap(5, 5, 5)))
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(jtfMaxIteration)
                                    .addComponent(jtfMomentum, javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(jtfMaxError, javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(jtfLearningRate, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 46, Short.MAX_VALUE)))
                            .addComponent(jbStop, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jbClear, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jbTrain, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(32, 32, 32))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jjNetwork, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jcbNetwork, javax.swing.GroupLayout.Alignment.LEADING, 0, 150, Short.MAX_VALUE))
                        .addGap(32, 32, 32))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addContainerGap())))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jjNetwork)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jcbNetwork, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(11, 11, 11)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jtfMultylayer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jlTransferFunction)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jcbTransferFunction, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jlLearningRate)
                    .addComponent(jtfLearningRate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jtfMaxError, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlMaxError))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jtfMomentum, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlMomentum))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jcbMaxIterations)
                    .addComponent(jtfMaxIteration, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(29, 29, 29)
                .addComponent(jbTrain, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jbStop)
                .addGap(18, 18, 18)
                .addComponent(jbClear, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(28, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jtfMomentumActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jtfMomentumActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jtfMomentumActionPerformed

    private void jcbNetworkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jcbNetworkActionPerformed
       setNetCode();
    }//GEN-LAST:event_jcbNetworkActionPerformed

    private void jcbTransferFunctionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jcbTransferFunctionActionPerformed
        setTranseCode();
    }//GEN-LAST:event_jcbTransferFunctionActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JButton jbClear;
    private javax.swing.JButton jbStop;
    private javax.swing.JButton jbTrain;
    private javax.swing.JCheckBox jcbMaxIterations;
    private javax.swing.JComboBox jcbNetwork;
    private javax.swing.JComboBox jcbTransferFunction;
    private javax.swing.JLabel jjNetwork;
    private javax.swing.JLabel jlLearningRate;
    private javax.swing.JLabel jlMaxError;
    private javax.swing.JLabel jlMomentum;
    private javax.swing.JLabel jlTransferFunction;
    private javax.swing.JTextField jtfLearningRate;
    private javax.swing.JTextField jtfMaxError;
    private javax.swing.JTextField jtfMaxIteration;
    private javax.swing.JTextField jtfMomentum;
    private javax.swing.JTextField jtfMultylayer;
    // End of variables declaration//GEN-END:variables

    @Action
    public void enableSetIterations()
    {
        jtfMaxIteration.setEditable(!jtfMaxIteration.isEditable());
    }

    public void setNetCode()
    {
       String net = (String) jcbNetwork.getSelectedItem();

       if(net.equals("Multy Perceptron"))   netCode = 1;
     }

    public void setTranseCode()
    {
       String net = (String) jcbTransferFunction.getSelectedItem();

       if(net.equals("Sigmoid"))   netCode = 1;
       if(net.equals("Tanh"))   netCode = 2;
     }


    public void setLayers()
    {
        if(!jtfMultylayer.getText().isEmpty()){
            try { layer = "2 "+jtfMultylayer.getText().trim()+" 1";}//String text = jtfMultylayer.getText();}  //treba dodati substring...
            catch(Exception e){layer = "2 1";}
        }
    }



   public void prepareNet()
   {
       setLayers();
        
        switch(tansfCode)
        {
            case 1: funct = TransferFunctionType.SIGMOID; break;
            case 2: funct = TransferFunctionType.TANH; break;
        }

        switch(netCode){
            case 1: neuralNet = NeuralNetworkFactory.createMLPerceptron(layer, funct); break;

         }

        
   }

   public double getLearningRate()
   {
       return Double.parseDouble(jtfLearningRate.getText());
   }

   public double getMaxError()
   {
       return Double.parseDouble(jtfMaxError.getText());
   }

   public double getMomentum()
   {
       return Double.parseDouble(jtfMomentum.getText());
   }

   public int getMaxIteration()
   {
       if(jtfMaxIteration.isEditable() && !jtfMaxIteration.getText().isEmpty())
       return Integer.parseInt(jtfMaxIteration.getText());
       else
       return new Integer(0);
   }


    public NeuralNetwork getNet()
    {
        prepareNet();

        return neuralNet;
    }

    @Action
    public void train()
    {
        backS.train(getNet());
    }

    @Action
    public void stop()
    {
        backS.stop();
    }

    @Action
    public void clear()
    {
        backS.clear();
        setJTFs("0.5","0.01", "0.0");
    }

    // DragNDrop - start
    // DnD dodaci

    public void setJtfMultylayer(String text) {
        this.jtfMultylayer.setText(text);
    }

    public void setJTFs(String maxError, String learningRate, String momentum)
    {
        jtfMaxError.setText(maxError);
        jtfLearningRate.setText(learningRate);
        jtfMomentum.setText(momentum);

    }
// DragNDrop - end
}



    



