/*
 * NFRStudentDemoFrame.java
 *
 * Created on March 30, 2009, 4:31 PM
 */

package org.neuroph.easyneurons.samples;

import java.util.Vector;

import javax.swing.JSlider;

import org.neuroph.easyneurons.NeuralNetworkTraining;

/**
 *
 * @author  Zoran Sevarac <sevarac@gmail.com>
 */
public class NFRSample extends javax.swing.JInternalFrame {
	private NeuralNetworkTraining controller;
	
    /** Creates new form NFRStudentDemoNew */
    public NFRSample(NeuralNetworkTraining controller) {
	this.controller = controller;
        initComponents();
	
	pointsField.setText((new Integer(pointsSlider.getValue())).toString());
	timeField.setText((new Integer(timeSlider.getValue())).toString());
	
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
        // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
        private void initComponents() {
                java.awt.GridBagConstraints gridBagConstraints;

                jPanel1 = new javax.swing.JPanel();
                pointsSlider = new javax.swing.JSlider();
                timeSlider = new javax.swing.JSlider();
                pointsField = new javax.swing.JTextField();
                timeField = new javax.swing.JTextField();
                jLabel1 = new javax.swing.JLabel();
                jLabel2 = new javax.swing.JLabel();
                classifyButton = new javax.swing.JButton();
                trainButton = new javax.swing.JButton();
                jPanel2 = new javax.swing.JPanel();
                badPanel = new javax.swing.JPanel();
                goodPanel = new javax.swing.JPanel();
                veryGoodPanel = new javax.swing.JPanel();
                excellentPanel = new javax.swing.JPanel();
                jLabel3 = new javax.swing.JLabel();
                jLabel4 = new javax.swing.JLabel();
                jLabel5 = new javax.swing.JLabel();
                jLabel6 = new javax.swing.JLabel();

                setClosable(true);
                setIconifiable(true);
                org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(NFRSample.class);
                setTitle(resourceMap.getString("Form.title")); // NOI18N
                setName("Form"); // NOI18N

                jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
                jPanel1.setName("jPanel1"); // NOI18N
                jPanel1.setLayout(new java.awt.GridBagLayout());

                pointsSlider.setMajorTickSpacing(10);
                pointsSlider.setMinorTickSpacing(1);
                pointsSlider.setPaintLabels(true);
                pointsSlider.setPaintTicks(true);
                pointsSlider.setName("pointsSlider"); // NOI18N
                pointsSlider.setPreferredSize(new java.awt.Dimension(330, 40));
                pointsSlider.addChangeListener(new javax.swing.event.ChangeListener() {
                        public void stateChanged(javax.swing.event.ChangeEvent evt) {
                                pointsSliderStateChanged(evt);
                        }
                });
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 5);
                jPanel1.add(pointsSlider, gridBagConstraints);

                timeSlider.setMajorTickSpacing(10);
                timeSlider.setMaximum(120);
                timeSlider.setMinimum(15);
                timeSlider.setMinorTickSpacing(1);
                timeSlider.setPaintLabels(true);
                timeSlider.setPaintTicks(true);
                timeSlider.setName("timeSlider"); // NOI18N
                timeSlider.setPreferredSize(new java.awt.Dimension(330, 40));
                timeSlider.addChangeListener(new javax.swing.event.ChangeListener() {
                        public void stateChanged(javax.swing.event.ChangeEvent evt) {
                                timeSliderStateChanged(evt);
                        }
                });
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 5);
                jPanel1.add(timeSlider, gridBagConstraints);

                pointsField.setBackground(resourceMap.getColor("timeField.background")); // NOI18N
                pointsField.setColumns(5);
                pointsField.setEditable(false);
                pointsField.setText(resourceMap.getString("pointsField.text")); // NOI18N
                pointsField.setName("pointsField"); // NOI18N
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
                jPanel1.add(pointsField, gridBagConstraints);

                timeField.setBackground(resourceMap.getColor("timeField.background")); // NOI18N
                timeField.setColumns(5);
                timeField.setEditable(false);
                timeField.setText(resourceMap.getString("timeField.text")); // NOI18N
                timeField.setName("timeField"); // NOI18N
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
                jPanel1.add(timeField, gridBagConstraints);

                jLabel1.setFont(resourceMap.getFont("jLabel2.font")); // NOI18N
                jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
                jLabel1.setName("jLabel1"); // NOI18N
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
                jPanel1.add(jLabel1, gridBagConstraints);

                jLabel2.setFont(resourceMap.getFont("jLabel2.font")); // NOI18N
                jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
                jLabel2.setName("jLabel2"); // NOI18N
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
                jPanel1.add(jLabel2, gridBagConstraints);

                classifyButton.setText(resourceMap.getString("classifyButton.text")); // NOI18N
                classifyButton.setName("classifyButton"); // NOI18N
                classifyButton.addMouseListener(new java.awt.event.MouseAdapter() {
                        public void mousePressed(java.awt.event.MouseEvent evt) {
                                classifyButtonMousePressed(evt);
                        }
                });
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
                jPanel1.add(classifyButton, gridBagConstraints);

                trainButton.setText(resourceMap.getString("trainButton.text")); // NOI18N
                trainButton.setName("trainButton"); // NOI18N
                trainButton.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                trainButtonActionPerformed(evt);
                        }
                });
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
                jPanel1.add(trainButton, gridBagConstraints);

                getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);

                jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());
                jPanel2.setName("jPanel2"); // NOI18N
                jPanel2.setLayout(new java.awt.GridBagLayout());

                badPanel.setBackground(resourceMap.getColor("badPanel.background")); // NOI18N
                badPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
                badPanel.setName("badPanel"); // NOI18N
                badPanel.setOpaque(false);

                javax.swing.GroupLayout badPanelLayout = new javax.swing.GroupLayout(badPanel);
                badPanel.setLayout(badPanelLayout);
                badPanelLayout.setHorizontalGroup(
                        badPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 100, Short.MAX_VALUE)
                );
                badPanelLayout.setVerticalGroup(
                        badPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 100, Short.MAX_VALUE)
                );

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
                jPanel2.add(badPanel, gridBagConstraints);

                goodPanel.setBackground(resourceMap.getColor("goodPanel.background")); // NOI18N
                goodPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
                goodPanel.setName("goodPanel"); // NOI18N
                goodPanel.setOpaque(false);

                javax.swing.GroupLayout goodPanelLayout = new javax.swing.GroupLayout(goodPanel);
                goodPanel.setLayout(goodPanelLayout);
                goodPanelLayout.setHorizontalGroup(
                        goodPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 100, Short.MAX_VALUE)
                );
                goodPanelLayout.setVerticalGroup(
                        goodPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 100, Short.MAX_VALUE)
                );

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
                jPanel2.add(goodPanel, gridBagConstraints);

                veryGoodPanel.setBackground(resourceMap.getColor("veryGoodPanel.background")); // NOI18N
                veryGoodPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
                veryGoodPanel.setName("veryGoodPanel"); // NOI18N
                veryGoodPanel.setOpaque(false);

                javax.swing.GroupLayout veryGoodPanelLayout = new javax.swing.GroupLayout(veryGoodPanel);
                veryGoodPanel.setLayout(veryGoodPanelLayout);
                veryGoodPanelLayout.setHorizontalGroup(
                        veryGoodPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 100, Short.MAX_VALUE)
                );
                veryGoodPanelLayout.setVerticalGroup(
                        veryGoodPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 100, Short.MAX_VALUE)
                );

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
                jPanel2.add(veryGoodPanel, gridBagConstraints);

                excellentPanel.setBackground(resourceMap.getColor("excellentPanel.background")); // NOI18N
                excellentPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
                excellentPanel.setName("excellentPanel"); // NOI18N
                excellentPanel.setOpaque(false);

                javax.swing.GroupLayout excellentPanelLayout = new javax.swing.GroupLayout(excellentPanel);
                excellentPanel.setLayout(excellentPanelLayout);
                excellentPanelLayout.setHorizontalGroup(
                        excellentPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 100, Short.MAX_VALUE)
                );
                excellentPanelLayout.setVerticalGroup(
                        excellentPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGap(0, 100, Short.MAX_VALUE)
                );

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 10);
                jPanel2.add(excellentPanel, gridBagConstraints);

                jLabel3.setFont(resourceMap.getFont("jLabel6.font")); // NOI18N
                jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
                jLabel3.setName("jLabel3"); // NOI18N
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                jPanel2.add(jLabel3, gridBagConstraints);

                jLabel4.setFont(resourceMap.getFont("jLabel6.font")); // NOI18N
                jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
                jLabel4.setName("jLabel4"); // NOI18N
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                jPanel2.add(jLabel4, gridBagConstraints);

                jLabel5.setFont(resourceMap.getFont("jLabel6.font")); // NOI18N
                jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
                jLabel5.setName("jLabel5"); // NOI18N
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                jPanel2.add(jLabel5, gridBagConstraints);

                jLabel6.setFont(resourceMap.getFont("jLabel6.font")); // NOI18N
                jLabel6.setText(resourceMap.getString("jLabel6.text")); // NOI18N
                jLabel6.setName("jLabel6"); // NOI18N
                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 1;
                jPanel2.add(jLabel6, gridBagConstraints);

                getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

                pack();
        }// </editor-fold>//GEN-END:initComponents

private void pointsSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_pointsSliderStateChanged
		JSlider source = (JSlider) evt.getSource();
		if (!source.getValueIsAdjusting()) {
			int value = source.getValue();
			pointsField.setText((new Integer(value)).toString());
		}
}//GEN-LAST:event_pointsSliderStateChanged

private void timeSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_timeSliderStateChanged
		JSlider source = (JSlider) evt.getSource();
		if (!source.getValueIsAdjusting()) {
			int value = source.getValue();
			timeField.setText((new Integer(value)).toString());
		}
}//GEN-LAST:event_timeSliderStateChanged

private void classifyButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_classifyButtonMousePressed
		badPanel.setOpaque(false);
		goodPanel.setOpaque(false);
		veryGoodPanel.setOpaque(false);
		excellentPanel.setOpaque(false);

		String inStr = pointsField.getText().trim() + " "
				+ timeField.getText().trim();
		controller.setInput(inStr);

		Vector<Double> output = controller.getNetwork().getOutput();
		if (((Double) output.elementAt(0)).doubleValue() == 1)
			badPanel.setOpaque(true);
		if (((Double) output.elementAt(1)).doubleValue() == 1)
			goodPanel.setOpaque(true);
		if (((Double) output.elementAt(2)).doubleValue() == 1)
			veryGoodPanel.setOpaque(true);
		if (((Double) output.elementAt(3)).doubleValue() == 1)
			excellentPanel.setOpaque(true);
		this.paintAll(this.getGraphics());
		this.repaint();	
}//GEN-LAST:event_classifyButtonMousePressed

private void trainButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_trainButtonActionPerformed
		controller.getNetwork().learnInNewThread(controller.getTrainingSet());
}//GEN-LAST:event_trainButtonActionPerformed


        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JPanel badPanel;
        private javax.swing.JButton classifyButton;
        private javax.swing.JPanel excellentPanel;
        private javax.swing.JPanel goodPanel;
        private javax.swing.JLabel jLabel1;
        private javax.swing.JLabel jLabel2;
        private javax.swing.JLabel jLabel3;
        private javax.swing.JLabel jLabel4;
        private javax.swing.JLabel jLabel5;
        private javax.swing.JLabel jLabel6;
        private javax.swing.JPanel jPanel1;
        private javax.swing.JPanel jPanel2;
        private javax.swing.JTextField pointsField;
        private javax.swing.JSlider pointsSlider;
        private javax.swing.JTextField timeField;
        private javax.swing.JSlider timeSlider;
        private javax.swing.JButton trainButton;
        private javax.swing.JPanel veryGoodPanel;
        // End of variables declaration//GEN-END:variables

}
