/*
 * BasicNeuron.java
 *
 * Created on April 5, 2009, 7:46 PM
 */

package org.neuroph.easyneurons.samples;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;

import org.jdesktop.application.Action;
import org.neuroph.core.Neuron;
/**
 *
 * @author  Zoran Sevarac <sevarac@gmail.com>
 */
public class BasicNeuronPanel extends javax.swing.JPanel {

	Neuron neuron;
	
    /** Creates new form BasicNeuron */
    public BasicNeuronPanel() {
        initComponents();
	neuron = new Neuron();
    }
    
    @Override
    protected void paintComponent(Graphics g) {
	    Graphics2D g2d =(Graphics2D)g;
	    g2d.setRenderingHint (RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
	    
	double output = neuron.getOutput();
	int colorIntensity = 200 - Math.abs( (int)(output*100)*2);
	if (colorIntensity > 200 ) colorIntensity = 200;
	if (colorIntensity < 0 ) colorIntensity = 0;
	    
	   if (output>0) {
			g2d.setColor( new Color(255, colorIntensity, colorIntensity));	
		} else if (output<0) {
			g2d.setColor( new Color(colorIntensity, colorIntensity, 255));
		} else {
			g2d.setColor( new Color(102, 102, 102));
		}
	    
	    g2d.fillOval(40, 40, 240, 240);
	    
	    g2d.setColor( new Color(0, 0, 0));
	    g2d.drawLine(160, 170, 80, 340);
	    g2d.drawLine(160, 170, 250, 340);
	    g2d.drawLine(160, 25, 160, 170);		   
    }	  
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
        // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
        private void initComponents() {

                outputField = new javax.swing.JTextField();
                jLabel9 = new javax.swing.JLabel();
                jPanel1 = new javax.swing.JPanel();
                jLabel7 = new javax.swing.JLabel();
                jPanel2 = new javax.swing.JPanel();
                jLabel1 = new javax.swing.JLabel();
                inputFunctionField = new javax.swing.JTextField();
                jLabel3 = new javax.swing.JLabel();
                weightField1 = new javax.swing.JTextField();
                weightField2 = new javax.swing.JTextField();
                jLabel4 = new javax.swing.JLabel();
                inputField1 = new javax.swing.JTextField();
                inputField2 = new javax.swing.JTextField();
                jLabel5 = new javax.swing.JLabel();
                jLabel6 = new javax.swing.JLabel();
                calculateButton = new javax.swing.JButton();

                setName("Form"); // NOI18N

                org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(BasicNeuronPanel.class);
                outputField.setBackground(resourceMap.getColor("outputField.background")); // NOI18N
                outputField.setColumns(6);
                outputField.setEditable(false);
                outputField.setText(resourceMap.getString("outputField.text")); // NOI18N
                outputField.setName("outputField"); // NOI18N

                jLabel9.setText(resourceMap.getString("jLabel9.text")); // NOI18N
                jLabel9.setName("jLabel9"); // NOI18N

                jPanel1.setBackground(resourceMap.getColor("jPanel1.background")); // NOI18N
                jPanel1.setName("jPanel1"); // NOI18N
                jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

                jLabel7.setFont(resourceMap.getFont("jLabel7.font")); // NOI18N
                jLabel7.setText(resourceMap.getString("jLabel7.text")); // NOI18N
                jLabel7.setName("jLabel7"); // NOI18N
                jPanel1.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 20, -1, -1));

                jPanel2.setBackground(resourceMap.getColor("jPanel2.background")); // NOI18N
                jPanel2.setName("jPanel2"); // NOI18N

                jLabel1.setFont(resourceMap.getFont("jLabel1.font")); // NOI18N
                jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
                jLabel1.setName("jLabel1"); // NOI18N
                jPanel2.add(jLabel1);

                inputFunctionField.setBackground(resourceMap.getColor("inputFunctionField.background")); // NOI18N
                inputFunctionField.setColumns(6);
                inputFunctionField.setEditable(false);
                inputFunctionField.setText(resourceMap.getString("inputFunctionField.text")); // NOI18N
                inputFunctionField.setName("inputFunctionField"); // NOI18N
                jPanel2.add(inputFunctionField);

                jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
                jLabel3.setName("jLabel3"); // NOI18N

                weightField1.setColumns(6);
                weightField1.setText(resourceMap.getString("weightField1.text")); // NOI18N
                weightField1.setName("weightField1"); // NOI18N

                weightField2.setColumns(6);
                weightField2.setText(resourceMap.getString("weightField2.text")); // NOI18N
                weightField2.setName("weightField2"); // NOI18N

                jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
                jLabel4.setName("jLabel4"); // NOI18N

                inputField1.setColumns(6);
                inputField1.setText(resourceMap.getString("inputField1.text")); // NOI18N
                inputField1.setName("inputField1"); // NOI18N

                inputField2.setColumns(6);
                inputField2.setText(resourceMap.getString("inputField2.text")); // NOI18N
                inputField2.setName("inputField2"); // NOI18N

                jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
                jLabel5.setName("jLabel5"); // NOI18N

                jLabel6.setText(resourceMap.getString("jLabel6.text")); // NOI18N
                jLabel6.setName("jLabel6"); // NOI18N

                javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(BasicNeuronPanel.class, this);
                calculateButton.setAction(actionMap.get("calculateNeuron")); // NOI18N
                calculateButton.setText(resourceMap.getString("calculateButton.text")); // NOI18N
                calculateButton.setName("calculateButton"); // NOI18N

                javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
                this.setLayout(layout);
                layout.setHorizontalGroup(
                        layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(layout.createSequentialGroup()
                                                .addGap(99, 99, 99)
                                                .addComponent(jLabel9)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(outputField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 156, Short.MAX_VALUE)
                                                .addComponent(calculateButton))
                                        .addGroup(layout.createSequentialGroup()
                                                .addContainerGap()
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                                        .addComponent(jLabel5)
                                                        .addComponent(jLabel3))
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                                        .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                                                .addComponent(inputField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE)
                                                                .addComponent(inputField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                                        .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 196, Short.MAX_VALUE)
                                                        .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 196, Short.MAX_VALUE)
                                                        .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                                                .addComponent(weightField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 88, Short.MAX_VALUE)
                                                                .addComponent(weightField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                        .addComponent(jLabel4)
                                                        .addComponent(jLabel6))
                                                .addGap(142, 142, 142)))
                                .addContainerGap())
                );
                layout.setVerticalGroup(
                        layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addContainerGap()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(outputField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(jLabel9)
                                        .addComponent(calculateButton))
                                .addGap(60, 60, 60)
                                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(18, 18, 18)
                                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 53, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(74, 74, 74)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(weightField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(jLabel3)
                                        .addComponent(weightField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(jLabel4))
                                .addGap(12, 12, 12)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(inputField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(jLabel5)
                                        .addComponent(inputField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(jLabel6)))
                );
        }// </editor-fold>//GEN-END:initComponents

	@Action
	public void calculateNeuron() {
		double i1 = Double.parseDouble(inputField1.getText().trim());
		double i2 = Double.parseDouble(inputField2.getText().trim());
		
		double w1 = Double.parseDouble(weightField1.getText().trim());
		double w2 = Double.parseDouble(weightField2.getText().trim());
		
		double totalInput = w1*i1 + w2*i2;
		neuron.setInput(totalInput);
		neuron.calculate();
		double output = neuron.getOutput();
						
		inputFunctionField.setText((new DecimalFormat("#0.00")).format(totalInput));
		outputField.setText((new DecimalFormat("#0.00")).format(output));	
		repaint();
	}

        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JButton calculateButton;
        private javax.swing.JTextField inputField1;
        private javax.swing.JTextField inputField2;
        private javax.swing.JTextField inputFunctionField;
        private javax.swing.JLabel jLabel1;
        private javax.swing.JLabel jLabel3;
        private javax.swing.JLabel jLabel4;
        private javax.swing.JLabel jLabel5;
        private javax.swing.JLabel jLabel6;
        private javax.swing.JLabel jLabel7;
        private javax.swing.JLabel jLabel9;
        private javax.swing.JPanel jPanel1;
        private javax.swing.JPanel jPanel2;
        private javax.swing.JTextField outputField;
        private javax.swing.JTextField weightField1;
        private javax.swing.JTextField weightField2;
        // End of variables declaration//GEN-END:variables

}
