
/*
 * tcrViewFrame.java
 *
 * Created on 31.03.2010., 17.31.16
 */
package org.neuroph.easyneurons.ocr.tcr;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.neuroph.contrib.imgrec.ColorMode;
import org.neuroph.contrib.imgrec.FractionRgbData;
import org.neuroph.contrib.imgrec.ImageRecognitionHelper;
import org.neuroph.contrib.ocr.OcrHelper;
import org.neuroph.contrib.ocr.OcrUtils;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.learning.TrainingSet;
import org.neuroph.easyneurons.ProjectManager;
import org.neuroph.util.TransferFunctionType;
import org.neuroph.util.VectorParser;

/**
 *
 * @author Ivana
 */
public class TextRecognitionFrame extends javax.swing.JInternalFrame {

    TextRecognizer textRecognizer;
    JDesktopPane desktop;
    JFileChooser fileChooser = new JFileChooser();
    Vector<Integer> hiddenLayersNeuronsCount;
    TransferFunctionType transferFunctionType;
    private Font fontText;
    private Integer i = 14;
    private HashMap<String, BufferedImage> charImageMap;
    String networkLabel, trainingSetLabel;
    TrainingSet activeTrainingSet;
    int imageWidth;
    int imageHeight;
    ColorMode colorMode;
    Dimension samplingResolution;
    ArrayList<String> imageLabels;
    NeuralNetwork activeNeuralNetwork;

    /** Creates new form tcrViewFrame */
    public TextRecognitionFrame() {
        initComponents();
        lettersTextArea.setEditable(false);
        fillFontComboBoxes();
        buttonGroup1.add(colorRadioButton);
        buttonGroup1.add(bwRadioButton);
        colorRadioButton.setActionCommand("FullColor");
        bwRadioButton.setActionCommand("BlackAndWhite");
        lettersTextArea.setText("A B C D E F G H I J K L M N O P Q R S T U V W X Y Z");

        File tmpDir = new File(TextRecognizer.TEMP_CHAR_DIR);
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        } else {
            deleteDirectory(tmpDir); // delete dir and all containing files
            tmpDir.mkdir();
        }

    }

    /**
     * Deletes directory and all containing files
     * @param path
     * @return
     */
    static public boolean deleteDirectory(File path) {
        if( path.exists() ) {
          File[] files = path.listFiles();
          for(int i=0; i<files.length; i++) {
             if(files[i].isDirectory()) {
               deleteDirectory(files[i]);
             }
             else {
               files[i].delete();
             }
          }
        }
        return( path.delete() );
      }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    public void fillFontComboBoxes() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = e.getAllFonts();
        for (Font font : fonts) {
            if (!font.getName().contains("Italic")) {
                if (!font.getName().contains("Bold")) {
                    if (!font.getName().contains("italic")) {
                        if (!font.getName().contains("MT")) {
                            if (!font.getName().contains("BT")) {
                                if (!font.getName().contains("ITC")) {
                                    if (!font.getName().contains("bold")) {

                                        fontComboBox.addItem(font.getName());
                                    }
                                }
                            }
                        }
                    }
                }
            }


        }
        fontSizeComboBox.addItem(12);
        fontSizeComboBox.addItem(14);
        fontSizeComboBox.addItem(16);
        fontSizeComboBox.addItem(18);
        fontSizeComboBox.addItem(20);
        fontSizeComboBox.addItem(22);
        fontSizeComboBox.addItem(24);
        fontSizeComboBox.addItem(26);
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        lettersTextArea = new javax.swing.JTextArea();
        jScrollPane2 = new javax.swing.JScrollPane();
        imageText = new javax.swing.JLabel();
        jCheckBox1 = new javax.swing.JCheckBox();
        fontComboBox = new javax.swing.JComboBox();
        fontSizeComboBox = new javax.swing.JComboBox();
        trainingSetPanel = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        trainingSetLabelField = new javax.swing.JTextField();
        samplingResolutionPanel = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        imageWidthField = new javax.swing.JTextField();
        imageHeightField = new javax.swing.JTextField();
        colorModePanel = new javax.swing.JPanel();
        colorRadioButton = new javax.swing.JRadioButton();
        bwRadioButton = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        buttonPanel = new javax.swing.JPanel();
        createTrainingSetButton = new javax.swing.JButton();
        nextButton = new javax.swing.JButton();
        resetButton = new javax.swing.JButton();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        networkSettingsPanel = new javax.swing.JPanel();
        layerNeuronCounts = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        transferFunctionCombo = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        networkLabelField = new javax.swing.JTextField();
        createNetworkButton = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        loadTextImageButton = new javax.swing.JButton();
        recognizeButton = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        recognizedTextArea = new javax.swing.JTextArea();
        jLabel10 = new javax.swing.JLabel();
        saveTextButton = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane4 = new javax.swing.JScrollPane();
        imageLabel = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane5 = new javax.swing.JScrollPane();
        jTextArea3 = new javax.swing.JTextArea();

        setClosable(true);
        setIconifiable(true);
        setTitle("Text Recognition Tool");

        jTabbedPane1.setName("jTabbedPane1"); // NOI18N

        jPanel1.setMaximumSize(new java.awt.Dimension(1000, 1000));
        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setPreferredSize(new java.awt.Dimension(600, 600));

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        lettersTextArea.setColumns(20);
        lettersTextArea.setRows(5);
        lettersTextArea.setName("lettersTextArea"); // NOI18N
        jScrollPane1.setViewportView(lettersTextArea);

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        imageText.setName("imageText"); // NOI18N
        jScrollPane2.setViewportView(imageText);

        jCheckBox1.setText("Add more Characters");
        jCheckBox1.setName("jCheckBox1"); // NOI18N
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        fontComboBox.setName("fontComboBox"); // NOI18N
        fontComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontComboBoxActionPerformed(evt);
            }
        });

        fontSizeComboBox.setName("fontSizeComboBox"); // NOI18N
        fontSizeComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontSizeComboBoxActionPerformed(evt);
            }
        });

        trainingSetPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Training Set Settings"));
        trainingSetPanel.setName("trainingSetPanel"); // NOI18N

        jLabel3.setText("Training Set Label");
        jLabel3.setName("jLabel3"); // NOI18N

        trainingSetLabelField.setName("trainingSetLabelField"); // NOI18N

        javax.swing.GroupLayout trainingSetPanelLayout = new javax.swing.GroupLayout(trainingSetPanel);
        trainingSetPanel.setLayout(trainingSetPanelLayout);
        trainingSetPanelLayout.setHorizontalGroup(
            trainingSetPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(trainingSetPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(trainingSetLabelField, javax.swing.GroupLayout.PREFERRED_SIZE, 154, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(37, Short.MAX_VALUE))
        );
        trainingSetPanelLayout.setVerticalGroup(
            trainingSetPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(trainingSetPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(trainingSetPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(trainingSetLabelField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(42, Short.MAX_VALUE))
        );

        samplingResolutionPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Image Sampling Resolution"));
        samplingResolutionPanel.setName("samplingResolutionPanel"); // NOI18N

        jLabel6.setText("Width");
        jLabel6.setName("jLabel6"); // NOI18N

        jLabel7.setText("Height");
        jLabel7.setName("jLabel7"); // NOI18N

        imageWidthField.setText("20");
        imageWidthField.setName("imageWidthField"); // NOI18N

        imageHeightField.setText("20");
        imageHeightField.setName("imageHeightField"); // NOI18N

        javax.swing.GroupLayout samplingResolutionPanelLayout = new javax.swing.GroupLayout(samplingResolutionPanel);
        samplingResolutionPanel.setLayout(samplingResolutionPanelLayout);
        samplingResolutionPanelLayout.setHorizontalGroup(
            samplingResolutionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(samplingResolutionPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(samplingResolutionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel7)
                    .addComponent(jLabel6))
                .addGap(25, 25, 25)
                .addGroup(samplingResolutionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(imageHeightField)
                    .addComponent(imageWidthField, javax.swing.GroupLayout.DEFAULT_SIZE, 52, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        samplingResolutionPanelLayout.setVerticalGroup(
            samplingResolutionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(samplingResolutionPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(samplingResolutionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(imageWidthField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(samplingResolutionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel7)
                    .addComponent(imageHeightField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        colorModePanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Color Mode"));
        colorModePanel.setName("colorModePanel"); // NOI18N

        colorRadioButton.setSelected(true);
        colorRadioButton.setText("Color");
        colorRadioButton.setName("colorRadioButton"); // NOI18N

        bwRadioButton.setText("Black and White");
        bwRadioButton.setName("bwRadioButton"); // NOI18N

        javax.swing.GroupLayout colorModePanelLayout = new javax.swing.GroupLayout(colorModePanel);
        colorModePanel.setLayout(colorModePanelLayout);
        colorModePanelLayout.setHorizontalGroup(
            colorModePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(colorModePanelLayout.createSequentialGroup()
                .addGroup(colorModePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(colorRadioButton)
                    .addComponent(bwRadioButton))
                .addContainerGap(7, Short.MAX_VALUE))
        );
        colorModePanelLayout.setVerticalGroup(
            colorModePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(colorModePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(colorRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE)
                .addComponent(bwRadioButton)
                .addContainerGap())
        );

        jLabel1.setText("Font Style");
        jLabel1.setName("jLabel1"); // NOI18N

        jLabel5.setText("Font Size");
        jLabel5.setName("jLabel5"); // NOI18N

        buttonPanel.setName("buttonPanel"); // NOI18N

        createTrainingSetButton.setText("Create Training Set");
        createTrainingSetButton.setName("createTrainingSetButton"); // NOI18N
        createTrainingSetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                createTrainingSetButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(createTrainingSetButton);

        nextButton.setText("Next >");
        nextButton.setName("nextButton"); // NOI18N
        nextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nextButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(nextButton);

        resetButton.setText("Reset");
        resetButton.setName("resetButton"); // NOI18N
        buttonPanel.add(resetButton);

        jLabel12.setText("Image of Characters to Learn");
        jLabel12.setName("jLabel12"); // NOI18N

        jLabel13.setText("Characters to Learn");
        jLabel13.setName("jLabel13"); // NOI18N

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jCheckBox1)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(fontComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, 241, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel1))
                                .addGap(18, 18, 18)
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(jLabel5, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(fontSizeComboBox, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                            .addComponent(jLabel13)
                            .addComponent(buttonPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(trainingSetPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(samplingResolutionPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(1423, 1423, 1423)
                                .addComponent(colorModePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jLabel12)
                            .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 350, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGap(13, 13, 13)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(fontComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(fontSizeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel13)
                    .addComponent(jLabel12))
                .addGap(6, 6, 6)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 151, Short.MAX_VALUE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 151, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBox1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGap(45, 45, 45)
                                .addComponent(colorModePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                                .addComponent(trainingSetPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGap(18, 18, 18)
                                .addComponent(buttonPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addContainerGap(22, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(samplingResolutionPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())))
        );

        jTabbedPane1.addTab("1.Training set", jPanel1);

        jPanel2.setName("jPanel2"); // NOI18N

        networkSettingsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Neural network settings"));
        networkSettingsPanel.setName("networkSettingsPanel"); // NOI18N
        networkSettingsPanel.setLayout(new java.awt.GridBagLayout());

        layerNeuronCounts.setName("layerNeuronCounts"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        networkSettingsPanel.add(layerNeuronCounts, gridBagConstraints);

        jLabel8.setText("Hidden Layers Neuron Counts");
        jLabel8.setName("jLabel8"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 2, 0);
        networkSettingsPanel.add(jLabel8, gridBagConstraints);

        jLabel9.setText("Transfer function");
        jLabel9.setName("jLabel9"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 2, 0);
        networkSettingsPanel.add(jLabel9, gridBagConstraints);

        transferFunctionCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Sigmoid", "Tanh", " " }));
        transferFunctionCombo.setName("transferFunctionCombo"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        networkSettingsPanel.add(transferFunctionCombo, gridBagConstraints);

        jLabel11.setText("Network label");
        jLabel11.setName("jLabel11"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 2, 0);
        networkSettingsPanel.add(jLabel11, gridBagConstraints);

        networkLabelField.setName("networkLabelField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        networkSettingsPanel.add(networkLabelField, gridBagConstraints);

        createNetworkButton.setText("Create Neural Network");
        createNetworkButton.setName("createNetworkButton"); // NOI18N
        createNetworkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                createNetworkButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(networkSettingsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 179, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(createNetworkButton, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(500, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addComponent(networkSettingsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(createNetworkButton)
                .addContainerGap(182, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("2.Neural Network", jPanel2);

        jPanel3.setName("jPanel3"); // NOI18N

        jLabel4.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel4.setText("Loaded Image");
        jLabel4.setName("jLabel4"); // NOI18N

        loadTextImageButton.setText("Load Text Image");
        loadTextImageButton.setName("loadTextImageButton"); // NOI18N
        loadTextImageButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadTextImageButtonActionPerformed(evt);
            }
        });

        recognizeButton.setText("Recognize >>");
        recognizeButton.setName("recognizeButton"); // NOI18N
        recognizeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                recognizeButtonActionPerformed(evt);
            }
        });

        jScrollPane3.setName("jScrollPane3"); // NOI18N

        recognizedTextArea.setColumns(20);
        recognizedTextArea.setFont(new java.awt.Font("Monospaced", 0, 12));
        recognizedTextArea.setRows(5);
        recognizedTextArea.setName("recognizedTextArea"); // NOI18N
        recognizedTextArea.setPreferredSize(new java.awt.Dimension(262, 313));
        jScrollPane3.setViewportView(recognizedTextArea);

        jLabel10.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel10.setText("Recognized text");
        jLabel10.setName("jLabel10"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(TextRecognitionFrame.class, this);
        saveTextButton.setAction(actionMap.get("saveTextButton")); // NOI18N
        saveTextButton.setName("saveTextButton"); // NOI18N
        saveTextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveTextButtonActionPerformed(evt);
            }
        });

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setName("jLabel2"); // NOI18N
        jLabel2.setPreferredSize(new java.awt.Dimension(34, 14));

        jScrollPane4.setName("jScrollPane4"); // NOI18N

        imageLabel.setName("imageLabel"); // NOI18N
        imageLabel.setPreferredSize(new java.awt.Dimension(334, 313));
        jScrollPane4.setViewportView(imageLabel);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(jPanel3Layout.createSequentialGroup()
                                .addComponent(jLabel4)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(loadTextImageButton))
                            .addComponent(jScrollPane4, javax.swing.GroupLayout.PREFERRED_SIZE, 259, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addComponent(recognizeButton, javax.swing.GroupLayout.DEFAULT_SIZE, 119, Short.MAX_VALUE)
                        .addGap(18, 18, 18)
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(jPanel3Layout.createSequentialGroup()
                                .addComponent(jLabel10)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(saveTextButton))
                            .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 255, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jLabel2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 669, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(jPanel3Layout.createSequentialGroup()
                                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel4)
                                    .addComponent(loadTextImageButton))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jScrollPane4, javax.swing.GroupLayout.PREFERRED_SIZE, 374, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(jPanel3Layout.createSequentialGroup()
                                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel10)
                                    .addComponent(saveTextButton, javax.swing.GroupLayout.DEFAULT_SIZE, 18, Short.MAX_VALUE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 379, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(39, 39, 39))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(202, 202, 202)
                        .addComponent(recognizeButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(20, 20, 20))
        );

        jTabbedPane1.addTab("3.Test", jPanel3);

        jPanel4.setName("jPanel4"); // NOI18N

        jScrollPane5.setName("jScrollPane5"); // NOI18N

        jTextArea3.setColumns(20);
        jTextArea3.setEditable(false);
        jTextArea3.setFont(new java.awt.Font("Monospaced", 0, 14));
        jTextArea3.setRows(5);
        jTextArea3.setText("Thank you for using our application! \n                     TCR v1.0 2009/2010\nThis is a student's project. The software is part of \nNeuroph Project, and it demonstrates how neural networks \ncan be applied for text recognition.\nSee http://neuroph.sourceforge.net for more info \n\nFON - University of Belgrade, Serbia\n    by GOOD OLD AI group http://goodoldai.org/\nMentor - Zoran Sevarac\n\tmailto: sevarac@gmail.com\n\tpage: http://goodoldai.org/zoran_sevarac\nStudents:\nIvana Jovicic\n\tmailto: jovicic.ivana@gmail.com\nVladimir Kolarevic\n\tmailto:\tvlada.kole@gmail.com\nMarko Ivanovic\n\tmailto: marko.ivanovic.13@gmail.com\n\nPowered by \nJava Neural Network Framework, http://neuroph.sourceforge.net/\nDeveloped in Java in NetBeans 6.7.1 IDE\nNetBeans, http://netbeans.org/\n");
        jTextArea3.setWrapStyleWord(true);
        jTextArea3.setName("jTextArea3"); // NOI18N
        jScrollPane5.setViewportView(jTextArea3);

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addGap(85, 85, 85)
                .addComponent(jScrollPane5, javax.swing.GroupLayout.DEFAULT_SIZE, 594, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane5, javax.swing.GroupLayout.DEFAULT_SIZE, 411, Short.MAX_VALUE)
                .addContainerGap())
        );

        jTabbedPane1.addTab("About", jPanel4);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 694, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 461, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(19, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    public void addCharacter(Character character) {
        recognizedTextArea.append(character.toString());
    }
    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        if (jCheckBox1.isSelected()) {
            lettersTextArea.setEditable(true);
        } else {
            lettersTextArea.setEditable(false);
        }
    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void fontComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontComboBoxActionPerformed
        String name = (String) fontComboBox.getSelectedItem();
        fontText = new Font(name, Font.PLAIN, i);

        lettersTextArea.setFont(fontText);


    }//GEN-LAST:event_fontComboBoxActionPerformed

    private void fontSizeComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontSizeComboBoxActionPerformed
        i = (Integer) fontSizeComboBox.getSelectedItem();
        String name = fontText.getName();
        fontText = new Font(name, Font.PLAIN, i);
        lettersTextArea.setFont(fontText);
    }//GEN-LAST:event_fontSizeComboBoxActionPerformed

    private void createTrainingSetButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createTrainingSetButtonActionPerformed

        imageLabels = new ArrayList<String>();
        List<String> charactersToLearn = new ArrayList<String>();

        // get letters from text area and create neccesery structures
        String charsFromTextAreaString = lettersTextArea.getText();
        String charsFromTextAreaArray[] = charsFromTextAreaString.split(" ");
        for (int i = 0; i < charsFromTextAreaArray.length; i++) {
           charactersToLearn.add(charsFromTextAreaArray[i]);
        }

        // get sampling resolution
        try {
            imageWidth = Integer.parseInt(imageWidthField.getText().trim());
            imageHeight = Integer.parseInt(imageHeightField.getText().trim());
        } catch (NumberFormatException e) {
            JOptionPane.showConfirmDialog(null,
                    "Invalid input! Sampling resolution width and height must be integer values.",
                    "Error", JOptionPane.DEFAULT_OPTION);
            return;
        }

        samplingResolution = new Dimension(imageWidth, imageHeight);

        // create characters image
        BufferedImage charactersImage = OcrUtils.blackAndLightGrayCleaning(OcrUtils.createImageFromText(charsFromTextAreaString, fontText));
        imageText.setIcon(new ImageIcon(charactersImage));

        File f = new File(TextRecognizer.TEMP_CHAR_FILE + ".bmp");
        try {
            ImageIO.write(charactersImage, "bmp", f);
        } catch (IOException ex) {
            Logger.getLogger(TextRecognitionFrame.class.getName()).log(Level.SEVERE, null, ex);
        }

        // create separate char images out of characters image
        textRecognizer = new TextRecognizer(charactersImage, samplingResolution, this);
        charImageMap = textRecognizer.createTrainingData(charactersToLearn, samplingResolution);

        // get training set label
        trainingSetLabel = trainingSetLabelField.getText().trim();
        if (trainingSetLabel.equals("")) {
            JOptionPane.showConfirmDialog(null,
                    "Invalid input! Training set label must be entered.",
                    "Error", JOptionPane.DEFAULT_OPTION);
            return;
        }
        
        for (String imgName : charImageMap.keySet()) {
            StringTokenizer st = new StringTokenizer(imgName, "._");
            String imgLabel = st.nextToken();
            if (!imageLabels.contains(imgLabel)) {
                imageLabels.add(imgLabel);
            }
        }

        Collections.sort(imageLabels);
        Map<String, FractionRgbData> data = OcrUtils.getFractionRgbDataForImages(charImageMap);

        // get color mode
        String selectedColorMode = buttonGroup1.getSelection().getActionCommand();
        if (selectedColorMode.equalsIgnoreCase("FullColor")) {
            colorMode = ColorMode.FULL_COLOR;
        } else {
            colorMode = ColorMode.BLACK_AND_WHITE;
        }

        // create training set - color or black and white
        if (colorMode == ColorMode.FULL_COLOR) {
            activeTrainingSet = ImageRecognitionHelper.createTrainingSet(imageLabels, data);
        } else {
            activeTrainingSet = ImageRecognitionHelper.createBlackAndWhiteTrainingSet(imageLabels, data);

        }
        activeTrainingSet.setLabel(trainingSetLabel);

        // add training set to project
        ProjectManager.getInstance().updateTrainingSets(activeTrainingSet);
    }//GEN-LAST:event_createTrainingSetButtonActionPerformed

    private void createNetworkButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createNetworkButtonActionPerformed
        createNewNetwork();
    }//GEN-LAST:event_createNetworkButtonActionPerformed

    private void loadTextImageButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadTextImageButtonActionPerformed
        int returnVal = fileChooser.showDialog(null, "Select image with text");
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            try {
                TextRecognizer.imageWithText = OcrUtils.loadAndCleanImage(fileChooser.getSelectedFile());
                imageLabel.setIcon(new ImageIcon(OcrUtils.loadAndCleanImage(fileChooser.getSelectedFile())));
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }//GEN-LAST:event_loadTextImageButtonActionPerformed

    private void recognizeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_recognizeButtonActionPerformed

        if (textRecognizer.imageWithText != null) {
            jLabel2.setText("Please wait! Recognizing text...");
            textRecognizer.recognizeText();
        } else {
            jLabel2.setText("You have to load image first!!!");
        }
}//GEN-LAST:event_recognizeButtonActionPerformed

    private void saveTextButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveTextButtonActionPerformed

        int returnVal = fileChooser.showDialog(null, "Enter file to save");

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File f = fileChooser.getSelectedFile();
            if (f != null) {

                String path = f.getAbsolutePath();
                
                String recognizedText = recognizedTextArea.getText();

                try {
                    writeTextToFile(recognizedText, path + ".txt");
                } catch (FileNotFoundException ex) {
                    Logger.getLogger(TextRecognitionFrame.class.getName()).log(Level.SEVERE, null, ex);
                } catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(TextRecognitionFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
}//GEN-LAST:event_saveTextButtonActionPerformed

    private void nextButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nextButtonActionPerformed
        jTabbedPane1.setSelectedIndex(1);
    }//GEN-LAST:event_nextButtonActionPerformed

    public void createNewNetwork() {
        networkLabel = networkLabelField.getText().trim();

        if (networkLabel.equals("")) {
            JOptionPane.showConfirmDialog(null,
                    "Invalid input! Network label must be entered.",
                    "Error", JOptionPane.DEFAULT_OPTION);
            return;
        }

        transferFunctionType = TransferFunctionType.valueOf(transferFunctionCombo.getSelectedItem().toString().toUpperCase());

        String hiddenLayersStr = layerNeuronCounts.getText().trim();
        if (hiddenLayersStr.equals("")) {
            JOptionPane.showConfirmDialog(null,
                    "Invalid input! Hidden Layers Neuron Counts must be entered.",
                    "Error", JOptionPane.DEFAULT_OPTION);
            return;
        }

        try {
            hiddenLayersNeuronsCount = VectorParser.parseInteger(hiddenLayersStr);
        } catch (Exception ex) {
            JOptionPane.showConfirmDialog(null,
                    "Invalid input! Hidden Layers Neuron Counts must be entered as space separated integers.",
                    "Error", JOptionPane.DEFAULT_OPTION);
            return;
        }

        // create neural network
        activeNeuralNetwork = OcrHelper.createNewNeuralNetwork(networkLabel, samplingResolution, colorMode, imageLabels, hiddenLayersNeuronsCount, transferFunctionType);

        textRecognizer.setNeuralNetwork(activeNeuralNetwork);
        
        ProjectManager.getInstance().addNewNetworkToProject(activeNeuralNetwork);
    }
     
    public void nextButton() {
        jTabbedPane1.setSelectedIndex(1);
    }

    private void writeTextToFile(String text, String path) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(path)), "UTF8"));
        for (int i = 0; i < text.length(); i++) {
            pw.write(text.charAt(i));
        }
        pw.flush();
        pw.close();

    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JRadioButton bwRadioButton;
    private javax.swing.JPanel colorModePanel;
    private javax.swing.JRadioButton colorRadioButton;
    private javax.swing.JButton createNetworkButton;
    private javax.swing.JButton createTrainingSetButton;
    private javax.swing.JComboBox fontComboBox;
    private javax.swing.JComboBox fontSizeComboBox;
    private javax.swing.JTextField imageHeightField;
    private javax.swing.JLabel imageLabel;
    private javax.swing.JLabel imageText;
    private javax.swing.JTextField imageWidthField;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextArea jTextArea3;
    private javax.swing.JTextField layerNeuronCounts;
    private javax.swing.JTextArea lettersTextArea;
    private javax.swing.JButton loadTextImageButton;
    private javax.swing.JTextField networkLabelField;
    private javax.swing.JPanel networkSettingsPanel;
    private javax.swing.JButton nextButton;
    private javax.swing.JButton recognizeButton;
    private javax.swing.JTextArea recognizedTextArea;
    private javax.swing.JButton resetButton;
    private javax.swing.JPanel samplingResolutionPanel;
    private javax.swing.JButton saveTextButton;
    private javax.swing.JTextField trainingSetLabelField;
    private javax.swing.JPanel trainingSetPanel;
    private javax.swing.JComboBox transferFunctionCombo;
    // End of variables declaration//GEN-END:variables

    public JButton getjButton2() {
        return recognizeButton;
    }

    public JLabel getjLabel2() {
        return jLabel2;
    }

/**
 * This is a thread class that executes the rendering of Image to
 * text in background (doesn't block the GUI thread)
 * @author Ivana Jovicic, Vladimir Kolarevic, Marko Ivanovic
 */
private class RecognitionlWorker extends SwingWorker {

    TextRecognizer textRecognizer;

    public RecognitionlWorker(TextRecognizer textRecognizer) {
        this.textRecognizer = textRecognizer;
    }

    @Override
    protected Void doInBackground() throws Exception {
        textRecognizer.recognizeText();
        return null;
    }
    }

}
