/***
 * Neuroph  http://neuroph.sourceforge.net
 * Copyright by Neuroph Project (C) 2008
 *
 * This file is part of Neuroph framework.
 *
 * Neuroph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Neuroph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Neuroph. If not, see <http://www.gnu.org/licenses/>.
 */

package org.neuroph.easyneurons.errorgraph;

import java.awt.Color;

import javax.swing.JColorChooser;

/**
 *
 * @author  Ivan Trnavac
 */
public class JDGraphProperties extends javax.swing.JDialog {
    private GraphComponent graphComponent;
    private GraphScope oldScope;
    private GraphProperties oldView;
    
    /** Creates new form JDGraphProperties */
    public JDGraphProperties(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();        
        init();
    }        
    
    public JDGraphProperties(GraphComponent graphComponent, java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.graphComponent = graphComponent;
        init();
    }
    
    public void init() {
        GraphScope s = graphComponent.getScope();
        jtfPixValueX.setText(Double.toString(s.getPixValueX()));
        jtfPixValueY.setText(Double.toString(s.getPixValueY()));
        jtfMaxX.setText(Double.toString(s.getMaxX()));
        jtfMaxY.setText(Double.toString(s.getMaxY()));
        jtfMinX.setText(Double.toString(s.getMinX()));
        jtfMinY.setText(Double.toString(s.getMinY()));       
        oldScope = s.clone();
        
        GraphProperties v = graphComponent.getGraphProperties();
        jbBackground.setBackground(v.getBackground());
        jbFrame.setBackground(v.getFrameColor());
        jbGrid.setBackground(v.getGridColor());
        jbAxis.setBackground(v.getAxisColor());
        jbNumber.setBackground(v.getNumColor());
        jbPoint.setBackground(v.getPointColor());
        jbLine.setBackground(v.getLineColor());         
        jtfWest.setText(Integer.toString(v.getWestGap()));
        jtfEast.setText(Integer.toString(v.getEastGap()));
        jtfNorth.setText(Integer.toString(v.getNorthGap()));
        jtfSouth.setText(Integer.toString(v.getSouthGap()));        
        jcbShowGrid.setSelected(v.isVisibleGrid());
        jcbShowLines.setSelected(v.isVisibleLine());
        jcbShowPoints.setSelected(v.isVisiblePoints());
        jtfNumPeriodX.setText(Double.toString(v.getNumPeriodX()));
        jtfNumPeriodY.setText(Double.toString(v.getNumPeriodY()));        
        jtfDecimalX.setText(Integer.toString(v.getDecimalX()));
        jtfDecimalY.setText(Integer.toString(v.getDecimalY()));                
        oldView = v.clone();
        
        jtfBufferSize.setText(Integer.toString(graphComponent.getBufferSize()));
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jtfPixValueX = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jtfPixValueY = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jtfMaxX = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jtfMinX = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jtfMaxY = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jtfMinY = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jbBackground = new javax.swing.JButton();
        jbFrame = new javax.swing.JButton();
        jbPoint = new javax.swing.JButton();
        jbGrid = new javax.swing.JButton();
        jbAxis = new javax.swing.JButton();
        jbLine = new javax.swing.JButton();
        jbNumber = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jcbShowPoints = new javax.swing.JCheckBox();
        jcbShowLines = new javax.swing.JCheckBox();
        jcbShowGrid = new javax.swing.JCheckBox();
        jPanel8 = new javax.swing.JPanel();
        jPanel9 = new javax.swing.JPanel();
        jLabel7 = new javax.swing.JLabel();
        jtfNumPeriodX = new javax.swing.JTextField();
        jtfNumPeriodY = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        jtfDecimalX = new javax.swing.JTextField();
        jtfDecimalY = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        jtfWest = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        jtfEast = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jtfNorth = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        jtfSouth = new javax.swing.JTextField();
        jPanel7 = new javax.swing.JPanel();
        jLabel13 = new javax.swing.JLabel();
        jtfBufferSize = new javax.swing.JTextField();
        jPanel6 = new javax.swing.JPanel();
        jbOK = new javax.swing.JButton();
        jbCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Graph Properties");
        setModal(true);

        jPanel1.setEnabled(false);

        jLabel1.setText("PixValueX");
        jLabel1.setEnabled(false);

        jtfPixValueX.setEnabled(false);

        jLabel2.setText("PixValueY");
        jLabel2.setEnabled(false);

        jtfPixValueY.setEnabled(false);

        jLabel3.setText("MaxX");

        jLabel4.setText("MinX");

        jLabel5.setText("MaxY");

        jLabel6.setText("MinY");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)
                            .addComponent(jLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)
                            .addComponent(jLabel5, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)
                            .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jtfMinY, javax.swing.GroupLayout.PREFERRED_SIZE, 134, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMaxY, javax.swing.GroupLayout.PREFERRED_SIZE, 134, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMinX, javax.swing.GroupLayout.PREFERRED_SIZE, 134, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMaxX, javax.swing.GroupLayout.PREFERRED_SIZE, 134, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfPixValueX, javax.swing.GroupLayout.DEFAULT_SIZE, 163, Short.MAX_VALUE)
                    .addComponent(jtfPixValueY))
                .addGap(45, 45, 45))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfPixValueX, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfPixValueY, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(9, 9, 9)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMaxX, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMinX, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMaxY, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(9, 9, 9)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfMinY, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(75, 75, 75))
        );

        jTabbedPane1.addTab("Scope", jPanel1);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Colors"));
        jPanel3.setLayout(new java.awt.GridLayout(7, 1, 5, 5));

        jbBackground.setText("Background");
        jbBackground.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbBackgroundActionPerformed(evt);
            }
        });
        jPanel3.add(jbBackground);

        jbFrame.setText("Frame");
        jbFrame.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbFrameActionPerformed(evt);
            }
        });
        jPanel3.add(jbFrame);

        jbPoint.setText("Point");
        jbPoint.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbPointActionPerformed(evt);
            }
        });
        jPanel3.add(jbPoint);

        jbGrid.setText("Grid");
        jbGrid.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbGridActionPerformed(evt);
            }
        });
        jPanel3.add(jbGrid);

        jbAxis.setText("Axis");
        jbAxis.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbAxisActionPerformed(evt);
            }
        });
        jPanel3.add(jbAxis);

        jbLine.setText("Line");
        jbLine.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbLineActionPerformed(evt);
            }
        });
        jPanel3.add(jbLine);

        jbNumber.setText("Number");
        jbNumber.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbNumberActionPerformed(evt);
            }
        });
        jPanel3.add(jbNumber);

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("Visibility"));
        jPanel5.setLayout(new javax.swing.BoxLayout(jPanel5, javax.swing.BoxLayout.Y_AXIS));

        jcbShowPoints.setText("show points");
        jPanel5.add(jcbShowPoints);

        jcbShowLines.setText("show lines");
        jPanel5.add(jcbShowLines);

        jcbShowGrid.setText("show grid");
        jPanel5.add(jcbShowGrid);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, 101, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(67, 67, 67))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(24, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Paint", jPanel2);

        jPanel9.setBorder(javax.swing.BorderFactory.createTitledBorder(""));

        jLabel7.setText("NumPeriodX");
        jLabel7.setEnabled(false);

        jtfNumPeriodX.setEnabled(false);

        jLabel8.setText("NumPeriodY");

        jLabel14.setText("Decimals  X");

        jLabel15.setText("Decimals Y");

        javax.swing.GroupLayout jPanel9Layout = new javax.swing.GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel15, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)
                    .addComponent(jLabel14, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)
                    .addComponent(jLabel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel7, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jtfDecimalY)
                    .addComponent(jtfDecimalX)
                    .addComponent(jtfNumPeriodX, javax.swing.GroupLayout.DEFAULT_SIZE, 134, Short.MAX_VALUE)
                    .addComponent(jtfNumPeriodY, javax.swing.GroupLayout.Alignment.TRAILING)))
        );
        jPanel9Layout.setVerticalGroup(
            jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel9Layout.createSequentialGroup()
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel7, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfNumPeriodX, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel8, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jtfNumPeriodY, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel14)
                    .addComponent(jtfDecimalX, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel9Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel15)
                    .addComponent(jtfDecimalY, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(20, 20, 20))
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Gaps"));
        jPanel4.setLayout(new java.awt.GridLayout(2, 4, 5, 12));

        jLabel10.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel10.setText("West");
        jPanel4.add(jLabel10);
        jPanel4.add(jtfWest);

        jLabel9.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel9.setText("East");
        jPanel4.add(jLabel9);
        jPanel4.add(jtfEast);

        jLabel11.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel11.setText("North");
        jPanel4.add(jLabel11);
        jPanel4.add(jtfNorth);

        jLabel12.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel12.setText("South");
        jPanel4.add(jLabel12);
        jPanel4.add(jtfSouth);

        javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(jPanel4, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel9, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(62, Short.MAX_VALUE))
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel9, javax.swing.GroupLayout.PREFERRED_SIZE, 131, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(17, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Numbers", jPanel8);

        jLabel13.setText("Points buffer size");

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel13)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jtfBufferSize, javax.swing.GroupLayout.PREFERRED_SIZE, 136, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(40, Short.MAX_VALUE))
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel13)
                    .addComponent(jtfBufferSize, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(211, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Other", jPanel7);

        jPanel6.setLayout(new java.awt.GridLayout(1, 0, 20, 0));

        jbOK.setText("OK");
        jbOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbOKActionPerformed(evt);
            }
        });
        jPanel6.add(jbOK);

        jbCancel.setText("Cancel");
        jbCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbCancelActionPerformed(evt);
            }
        });
        jPanel6.add(jbCancel);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jTabbedPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
                    .addComponent(jPanel6, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 270, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jbCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbCancelActionPerformed
        graphComponent.setScope(oldScope);
        graphComponent.setGraphProperties(oldView);
        dispose();
    }//GEN-LAST:event_jbCancelActionPerformed

    private void jbOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbOKActionPerformed
        GraphScope scope = new GraphScope();
        scope.setPixValueX(Double.parseDouble(jtfPixValueX.getText()));
        scope.setPixValueY(Double.parseDouble(jtfPixValueY.getText()));
        scope.setMaxX(Double.parseDouble(jtfMaxX.getText()));
        scope.setMaxY(Double.parseDouble(jtfMaxY.getText()));
        scope.setMinX(Double.parseDouble(jtfMinX.getText()));
        scope.setMinY(Double.parseDouble(jtfMinY.getText()));
        graphComponent.setScope(scope);
        
        GraphProperties v = graphComponent.getGraphProperties();
        if (scope.calculateWidth()/Double.parseDouble(jtfNumPeriodX.getText()) < 1000) {
            v.setNumPeriodX(Double.parseDouble(jtfNumPeriodX.getText()));
        }
        v.setNumPeriodY(Double.parseDouble(jtfNumPeriodY.getText()));
        v.setWestGap(Integer.parseInt(jtfWest.getText()));
        v.setEastGap(Integer.parseInt(jtfEast.getText()));
        v.setNorthGap(Integer.parseInt(jtfNorth.getText()));
        v.setSouthGap(Integer.parseInt(jtfSouth.getText()));
        v.setVisibleGrid(jcbShowGrid.isSelected());
        v.setVisiblePoints(jcbShowPoints.isSelected());
        v.setVisibleLine(jcbShowLines.isSelected());
        v.setDecimalX(Integer.parseInt(jtfDecimalX.getText()));
        v.setDecimalY(Integer.parseInt(jtfDecimalY.getText()));                
        graphComponent.setGraphProperties(v);
        
        graphComponent.setBufferSize(Integer.parseInt(jtfBufferSize.getText()));
        
        dispose();
    }//GEN-LAST:event_jbOKActionPerformed

    private void jbBackgroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbBackgroundActionPerformed
        Color col = JColorChooser.showDialog(this, "Background color", jbBackground.getBackground());
        if (col == null) return;
        jbBackground.setBackground(col);
        graphComponent.getGraphProperties().setBackground(col);
        graphComponent.repaint();
    }//GEN-LAST:event_jbBackgroundActionPerformed

    private void jbFrameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbFrameActionPerformed
        Color col = JColorChooser.showDialog(this, "Frame color", jbFrame.getBackground());
        if (col == null) return;
        jbFrame.setBackground(col);
        graphComponent.getGraphProperties().setFrameColor(col);
        graphComponent.repaint();
    }//GEN-LAST:event_jbFrameActionPerformed

    private void jbPointActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbPointActionPerformed
        Color col = JColorChooser.showDialog(this, "Point color", jbPoint.getBackground());
        if (col == null) return;
        jbPoint.setBackground(col);
        graphComponent.getGraphProperties().setPointColor(col);
        graphComponent.repaint();
    }//GEN-LAST:event_jbPointActionPerformed

    private void jbLineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbLineActionPerformed
        Color col = JColorChooser.showDialog(this, "Line color", jbLine.getBackground());
        if (col == null) return;
        jbLine.setBackground(col);
        graphComponent.getGraphProperties().setLineColor(col);
        graphComponent.repaint();
    }//GEN-LAST:event_jbLineActionPerformed

    private void jbGridActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbGridActionPerformed
        Color col = JColorChooser.showDialog(this, "Grid color", jbGrid.getBackground());
        if (col == null) return;
        jbGrid.setBackground(col);
        graphComponent.getGraphProperties().setGridColor(col);
        graphComponent.repaint();
    }//GEN-LAST:event_jbGridActionPerformed

    private void jbAxisActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbAxisActionPerformed
        Color col = JColorChooser.showDialog(this, "Axis color", jbAxis.getBackground());
        if (col == null) return;
        jbAxis.setBackground(col);
        graphComponent.getGraphProperties().setAxisColor(col);
        graphComponent.repaint();
    }//GEN-LAST:event_jbAxisActionPerformed

    private void jbNumberActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbNumberActionPerformed
        Color col = JColorChooser.showDialog(this, "Number color", jbNumber.getBackground());
        if (col == null) return;
        jbNumber.setBackground(col);
        graphComponent.getGraphProperties().setNumColor(col);
        graphComponent.repaint();
    }//GEN-LAST:event_jbNumberActionPerformed
    
    /**
     * @param args the command line arguments
     */
    /*public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                JDGraphProperties dialog = new JDGraphProperties(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }*/
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JButton jbAxis;
    private javax.swing.JButton jbBackground;
    private javax.swing.JButton jbCancel;
    private javax.swing.JButton jbFrame;
    private javax.swing.JButton jbGrid;
    private javax.swing.JButton jbLine;
    private javax.swing.JButton jbNumber;
    private javax.swing.JButton jbOK;
    private javax.swing.JButton jbPoint;
    private javax.swing.JCheckBox jcbShowGrid;
    private javax.swing.JCheckBox jcbShowLines;
    private javax.swing.JCheckBox jcbShowPoints;
    private javax.swing.JTextField jtfBufferSize;
    private javax.swing.JTextField jtfDecimalX;
    private javax.swing.JTextField jtfDecimalY;
    private javax.swing.JTextField jtfEast;
    private javax.swing.JTextField jtfMaxX;
    private javax.swing.JTextField jtfMaxY;
    private javax.swing.JTextField jtfMinX;
    private javax.swing.JTextField jtfMinY;
    private javax.swing.JTextField jtfNorth;
    private javax.swing.JTextField jtfNumPeriodX;
    private javax.swing.JTextField jtfNumPeriodY;
    private javax.swing.JTextField jtfPixValueX;
    private javax.swing.JTextField jtfPixValueY;
    private javax.swing.JTextField jtfSouth;
    private javax.swing.JTextField jtfWest;
    // End of variables declaration//GEN-END:variables
    
}
