/***
 * Neuroph  http://neuroph.sourceforge.net
 * Copyright by Neuroph Project (C) 2008
 *
 * This file is part of Neuroph framework.
 *
 * Neuroph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Neuroph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Neuroph. If not, see <http://www.gnu.org/licenses/>.
 */

package org.neuroph.easyneurons.errorgraph;

import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

import javax.swing.JFileChooser;

/**
 *
 * @author Ivan Trnavac
 */
public class ButtonsPanel extends javax.swing.JPanel {

    GraphComponent graphComponent;

    /** Creates new form ButtonsPanel */
    public ButtonsPanel() {
        initComponents();   
        jtbH.setSelected(true);
    }

    public void connectGraphComponent(GraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        graphComponent.setZoomMode(2);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel2 = new javax.swing.JPanel();
        jtbW = new javax.swing.JToggleButton();
        jtbH = new javax.swing.JToggleButton();
        jPanel3 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jbProperties = new javax.swing.JButton();
        jbClear = new javax.swing.JButton();
        jbRepaint = new javax.swing.JButton();

        setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 3, 5));

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Zoom mode"));
        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.LINE_AXIS));

        jtbW.setText("W");
        jtbW.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jtbWActionPerformed(evt);
            }
        });
        jPanel2.add(jtbW);

        jtbH.setText("H");
        jtbH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jtbHActionPerformed(evt);
            }
        });
        jPanel2.add(jtbH);

        add(jPanel2);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Data"));
        jPanel3.setLayout(new javax.swing.BoxLayout(jPanel3, javax.swing.BoxLayout.LINE_AXIS));

        jButton1.setText("Save");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jPanel3.add(jButton1);

        jButton2.setText("Load");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        jPanel3.add(jButton2);

        add(jPanel3);

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Controls"));
        jPanel4.setLayout(new javax.swing.BoxLayout(jPanel4, javax.swing.BoxLayout.LINE_AXIS));

        jbProperties.setText("Properties");
        jbProperties.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbPropertiesActionPerformed(evt);
            }
        });
        jPanel4.add(jbProperties);

        jbClear.setText("Clear");
        jbClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbClearActionPerformed(evt);
            }
        });
        jPanel4.add(jbClear);

        jbRepaint.setText("Repaint");
        jbRepaint.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbRepaintActionPerformed(evt);
            }
        });
        jPanel4.add(jbRepaint);

        add(jPanel4);
    }// </editor-fold>//GEN-END:initComponents
    private void jbPropertiesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbPropertiesActionPerformed
//        if (graphComponent.isWorking()) {
//            return;
//        }
        JDGraphProperties jdgp = new JDGraphProperties(graphComponent, null, true);
        jdgp.setLocationRelativeTo(graphComponent);
        jdgp.setVisible(true);
    }//GEN-LAST:event_jbPropertiesActionPerformed

    private void jbClearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbClearActionPerformed
//        if (graphComponent.isWorking()) {
//            return;
//        }
        graphComponent.clear();
    }//GEN-LAST:event_jbClearActionPerformed

    private void jtbWActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jtbWActionPerformed
//        if (graphComponent.isWorking()) {
//            return;
//        }
        if (jtbW.isSelected()) {
            jtbH.setSelected(false);
            //graphComponent.setZoomOn(true);
            graphComponent.setZoomMode(1);
        } else {
            //graphComponent.setZoomOn(false);
            graphComponent.setZoomMode(0);
        }      
    }//GEN-LAST:event_jtbWActionPerformed

    private void jtbHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jtbHActionPerformed
        if (jtbH.isSelected()) {
            jtbW.setSelected(false);
            //graphComponent.setZoomOn(true);
            graphComponent.setZoomMode(2);
        } else {
            //graphComponent.setZoomOn(false);
            graphComponent.setZoomMode(0);
        }
    }//GEN-LAST:event_jtbHActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
//        if (graphComponent.isWorking()) {
//            return;
//        }
        JFileChooser jfc = new JFileChooser();
        int returnVal = jfc.showSaveDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION) {            
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(jfc.getSelectedFile().getPath()));
                oos.writeObject(graphComponent.getPointsBuffer());
                oos.close();
            } catch (Exception e) {
                System.out.println("Error: " + e);
            }
        }

    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
//        if (graphComponent.isWorking()) {
//            return;
//        }
        JFileChooser jfc = new JFileChooser();
        int returnVal = jfc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION) {            
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(jfc.getSelectedFile().getPath()));
                Vector<Point2D> v = (Vector<Point2D>) ois.readObject();
                graphComponent.addPoints(v);
                ois.close();
            } catch (Exception e) {
                System.out.println("Error: " + e);
            }
        }
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jbRepaintActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbRepaintActionPerformed
        graphComponent.redrawDrawingBuffer();
        graphComponent.repaint();
    }//GEN-LAST:event_jbRepaintActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JButton jbClear;
    private javax.swing.JButton jbProperties;
    private javax.swing.JButton jbRepaint;
    private javax.swing.JToggleButton jtbH;
    private javax.swing.JToggleButton jtbW;
    // End of variables declaration//GEN-END:variables
}
