/*
 * UnsupervisedHebbianWizard.java
 *
 * Created on April 6, 2009, 9:02 PM
 */

package org.neuroph.easyneurons.dialog;

import org.jdesktop.application.Action;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;
import org.neuroph.util.TransferFunctionType;

/**
 *
 * @author  Zoran Sevarac <sevarac@gmail.com>
 */
public class UnsupervisedHebbianWizard extends javax.swing.JDialog {
	
	EasyNeuronsApplicationView mainFrame;

    /** Creates new form UnsupervisedHebbianWizard */
    public UnsupervisedHebbianWizard(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.mainFrame = EasyNeuronsApplicationView.getInstance();
        fillTransferFunctionCombo();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        inputPanel = new javax.swing.JPanel();
        inputsLabel = new javax.swing.JLabel();
        outputsLabel = new javax.swing.JLabel();
        transferLabel = new javax.swing.JLabel();
        inputsField = new javax.swing.JTextField();
        outputsField = new javax.swing.JTextField();
        transferComboBox = new javax.swing.JComboBox();
        buttonPanel = new javax.swing.JPanel();
        createButton = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(UnsupervisedHebbianWizard.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        inputPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        inputPanel.setName("inputPanel"); // NOI18N
        inputPanel.setLayout(new java.awt.GridBagLayout());

        inputsLabel.setText(resourceMap.getString("inputsLabel.text")); // NOI18N
        inputsLabel.setName("inputsLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(inputsLabel, gridBagConstraints);

        outputsLabel.setText(resourceMap.getString("outputsLabel.text")); // NOI18N
        outputsLabel.setName("outputsLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(outputsLabel, gridBagConstraints);

        transferLabel.setText(resourceMap.getString("transferLabel.text")); // NOI18N
        transferLabel.setName("transferLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(transferLabel, gridBagConstraints);

        inputsField.setColumns(6);
        inputsField.setText(resourceMap.getString("inputsField.text")); // NOI18N
        inputsField.setName("inputsField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(inputsField, gridBagConstraints);

        outputsField.setColumns(6);
        outputsField.setText(resourceMap.getString("outputsField.text")); // NOI18N
        outputsField.setName("outputsField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(outputsField, gridBagConstraints);

        transferComboBox.setName("transferComboBox"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(transferComboBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        getContentPane().add(inputPanel, gridBagConstraints);

        buttonPanel.setName("buttonPanel"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(UnsupervisedHebbianWizard.class, this);
        createButton.setAction(actionMap.get("create")); // NOI18N
        createButton.setText(resourceMap.getString("createButton.text")); // NOI18N
        createButton.setName("createButton"); // NOI18N
        buttonPanel.add(createButton);

        closeButton.setAction(actionMap.get("close")); // NOI18N
        closeButton.setText(resourceMap.getString("closeButton.text")); // NOI18N
        closeButton.setName("closeButton"); // NOI18N
        buttonPanel.add(closeButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        getContentPane().add(buttonPanel, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                UnsupervisedHebbianWizard dialog = new UnsupervisedHebbianWizard(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    
	private void fillTransferFunctionCombo() {
		transferComboBox.removeAllItems();
		transferComboBox.addItem(new ComboItem("Ramp", TransferFunctionType.RAMP));
    	transferComboBox.addItem(new ComboItem("Tanh", TransferFunctionType.TANH));
        transferComboBox.addItem(new ComboItem("Linear", TransferFunctionType.LINEAR));
	}

	@Action
	public void close() {
		setVisible(false);
	}

	@Action
	public void create() {
		int inputNeuronsNum = Integer.parseInt(this.inputsField.getText().trim());
		int outputNeuronsNum = Integer.parseInt(this.outputsField.getText().trim());
		TransferFunctionType tfType = TransferFunctionType.valueOf( ((ComboItem)transferComboBox.getSelectedItem()).getValue().toString());

		mainFrame.newUnsupervisedHebbianNetwork(inputNeuronsNum, outputNeuronsNum, tfType);
		this.setVisible(false);
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton closeButton;
    private javax.swing.JButton createButton;
    private javax.swing.JPanel inputPanel;
    private javax.swing.JTextField inputsField;
    private javax.swing.JLabel inputsLabel;
    private javax.swing.JTextField outputsField;
    private javax.swing.JLabel outputsLabel;
    private javax.swing.JComboBox transferComboBox;
    private javax.swing.JLabel transferLabel;
    // End of variables declaration//GEN-END:variables

}
