/*
 * TrainingSetWizard.java
 *
 * Created on October 17, 2008, 9:36 PM
 */

package org.neuroph.easyneurons.dialog;

import org.jdesktop.application.Action;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;

/**
 * 
 * @author Zoran Sevarac <sevarac@gmail.com>
 */
public class TrainingSetWizard extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	EasyNeuronsApplicationView mainFrame;

	/** Creates new form TrainingSetWizard */
	public TrainingSetWizard(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
                this.mainFrame = EasyNeuronsApplicationView.getInstance();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
	// desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {
		java.awt.GridBagConstraints gridBagConstraints;

		inputFieldsPanel = new javax.swing.JPanel();
		jLabel1 = new javax.swing.JLabel();
		labelTextField = new javax.swing.JTextField();
		jLabel2 = new javax.swing.JLabel();
		jLabel3 = new javax.swing.JLabel();
		inputsTextField = new javax.swing.JTextField();
		outputsTextField = new javax.swing.JTextField();
		jLabel4 = new javax.swing.JLabel();
		typeComboBox = new javax.swing.JComboBox();
		buttonPanel = new javax.swing.JPanel();
		nextButton = new javax.swing.JButton();
		cancelButton = new javax.swing.JButton();
		helpButton = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application
				.getInstance(
						org.neuroph.easyneurons.EasyNeuronsApplication.class)
				.getContext().getResourceMap(TrainingSetWizard.class);
		setTitle(resourceMap.getString("Form.title")); // NOI18N
		setModal(true);
		setName("Form"); // NOI18N
		setResizable(false);

		inputFieldsPanel.setName("inputFieldsPanel"); // NOI18N
		inputFieldsPanel.setLayout(new java.awt.GridBagLayout());

		jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
		jLabel1.setName("jLabel1"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 5, 5);
		inputFieldsPanel.add(jLabel1, gridBagConstraints);

		labelTextField.setText(resourceMap.getString("labelTextField.text")); // NOI18N
		labelTextField.setName("labelTextField"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 10);
		inputFieldsPanel.add(labelTextField, gridBagConstraints);

		jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
		jLabel2.setName("jLabel2"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
		inputFieldsPanel.add(jLabel2, gridBagConstraints);

		jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
		jLabel3.setName("jLabel3"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
		inputFieldsPanel.add(jLabel3, gridBagConstraints);

		inputsTextField.setColumns(5);
		inputsTextField.setText(resourceMap.getString("inputsTextField.text")); // NOI18N
		inputsTextField.setName("inputsTextField"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
		inputFieldsPanel.add(inputsTextField, gridBagConstraints);

		outputsTextField.setColumns(5);
		outputsTextField
				.setText(resourceMap.getString("outputsTextField.text")); // NOI18N
		outputsTextField.setName("outputsTextField"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 10);
		inputFieldsPanel.add(outputsTextField, gridBagConstraints);

		jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
		jLabel4.setName("jLabel4"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 5);
		inputFieldsPanel.add(jLabel4, gridBagConstraints);

		typeComboBox.setModel(new javax.swing.DefaultComboBoxModel(
				new String[] { "Supervised", "Unsupervised" }));
		typeComboBox.setName("typeComboBox"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
		inputFieldsPanel.add(typeComboBox, gridBagConstraints);

		getContentPane().add(inputFieldsPanel, java.awt.BorderLayout.CENTER);

		buttonPanel.setName("buttonPanel"); // NOI18N

		javax.swing.ActionMap actionMap = org.jdesktop.application.Application
				.getInstance(
						org.neuroph.easyneurons.EasyNeuronsApplication.class)
				.getContext().getActionMap(TrainingSetWizard.class, this);
		nextButton.setAction(actionMap.get("next")); // NOI18N
		nextButton.setText(resourceMap.getString("nextButton.text")); // NOI18N
		nextButton.setName("nextButton"); // NOI18N
		buttonPanel.add(nextButton);

		cancelButton.setAction(actionMap.get("cancel")); // NOI18N
		cancelButton.setText(resourceMap.getString("cancelButton.text")); // NOI18N
		cancelButton.setName("cancelButton"); // NOI18N
		buttonPanel.add(cancelButton);

		helpButton.setText(resourceMap.getString("helpButton.text")); // NOI18N
		helpButton.setEnabled(false);
		helpButton.setName("helpButton"); // NOI18N
		buttonPanel.add(helpButton);

		getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				TrainingSetWizard dialog = new TrainingSetWizard(
						new javax.swing.JFrame(), true);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}

	@Action
	public void cancel() {
		this.dispose();
	}

	@Action
	public void next() {
		String label = labelTextField.getText().trim();
		String type = typeComboBox.getSelectedItem().toString();
		int inputs = Integer.parseInt(inputsTextField.getText().trim());
		int outputs = 0;
		if (type.equals("Supervised")) {
			outputs = Integer.parseInt(outputsTextField.getText().trim());
		}

		this.mainFrame.showTrainingSetEditFrame(inputs, outputs, type, label);

		this.dispose();
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JPanel buttonPanel;
	private javax.swing.JButton cancelButton;
	private javax.swing.JButton helpButton;
	private javax.swing.JPanel inputFieldsPanel;
	private javax.swing.JTextField inputsTextField;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JLabel jLabel3;
	private javax.swing.JLabel jLabel4;
	private javax.swing.JTextField labelTextField;
	private javax.swing.JButton nextButton;
	private javax.swing.JTextField outputsTextField;
	private javax.swing.JComboBox typeComboBox;
	// End of variables declaration//GEN-END:variables

}
