/*
 * SetNetworkInputDialog.java
 *
 * Created on December 22, 2008, 12:36 AM
 */

package org.neuroph.easyneurons.dialog;

import java.awt.event.KeyEvent;

import javax.swing.JOptionPane;

import org.jdesktop.application.Action;
import org.neuroph.easyneurons.NeuralNetworkTraining;

/**
 * 
 * @author Zoran Sevarac <sevarac@gmail.com>
 */
public class SetNetworkInputDialog extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	NeuralNetworkTraining controller;

	/** Creates new form SetNetworkInputDialog */
	public SetNetworkInputDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
	}

	/** Creates new form SetNetworkInputDialog */
	public SetNetworkInputDialog(java.awt.Frame parent, boolean modal,
			NeuralNetworkTraining controller) {
		super(parent, modal);
		this.controller = controller;
		initComponents();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
	// desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {
		java.awt.GridBagConstraints gridBagConstraints;

		inputPanel = new javax.swing.JPanel();
		jLabel1 = new javax.swing.JLabel();
		inputField = new javax.swing.JTextField();
		buttonPanel = new javax.swing.JPanel();
		okButton = new javax.swing.JButton();
		cancelButton = new javax.swing.JButton();
		helpButton = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application
				.getInstance(
						org.neuroph.easyneurons.EasyNeuronsApplication.class)
				.getContext().getResourceMap(SetNetworkInputDialog.class);
		setTitle(resourceMap.getString("Form.title")); // NOI18N
		setName("Form"); // NOI18N
		setResizable(false);
		getContentPane().setLayout(new java.awt.GridBagLayout());

		inputPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
		inputPanel.setName("inputPanel"); // NOI18N
		inputPanel.setLayout(new java.awt.GridBagLayout());

		jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
		jLabel1.setName("jLabel1"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 2, 10);
		inputPanel.add(jLabel1, gridBagConstraints);

		inputField.setColumns(40);
		inputField.setText(resourceMap.getString("inputField.text")); // NOI18N
		inputField.setName("inputField"); // NOI18N
		inputField.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyPressed(java.awt.event.KeyEvent evt) {
				inputFieldKeyPressed(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(0, 10, 8, 10);
		inputPanel.add(inputField, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
		getContentPane().add(inputPanel, gridBagConstraints);

		buttonPanel.setName("buttonPanel"); // NOI18N

		javax.swing.ActionMap actionMap = org.jdesktop.application.Application
				.getInstance(
						org.neuroph.easyneurons.EasyNeuronsApplication.class)
				.getContext().getActionMap(SetNetworkInputDialog.class, this);
		okButton.setAction(actionMap.get("Ok")); // NOI18N
		okButton.setText(resourceMap.getString("okButton.text")); // NOI18N
		okButton.setName("okButton"); // NOI18N
		buttonPanel.add(okButton);

		cancelButton.setAction(actionMap.get("cancel")); // NOI18N
		cancelButton.setText(resourceMap.getString("cancelButton.text")); // NOI18N
		cancelButton.setName("cancelButton"); // NOI18N
		buttonPanel.add(cancelButton);

		helpButton.setText(resourceMap.getString("helpButton.text")); // NOI18N
		helpButton.setEnabled(false);
		helpButton.setName("helpButton"); // NOI18N
		buttonPanel.add(helpButton);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
		getContentPane().add(buttonPanel, gridBagConstraints);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void inputFieldKeyPressed(java.awt.event.KeyEvent evt) {// GEN-FIRST:event_inputFieldKeyPressed
	// TODO add your handling code here:
		int key = evt.getKeyCode();
		if (key == KeyEvent.VK_ENTER) {
			Ok();
		} else if (key == KeyEvent.VK_ESCAPE) {
			cancel();
		}
	}// GEN-LAST:event_inputFieldKeyPressed

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				SetNetworkInputDialog dialog = new SetNetworkInputDialog(
						new javax.swing.JFrame(), true);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}

	@Action
	public void cancel() {
		this.dispose();
	}

	@Action
	public void Ok() {
		try {
			String netInputStr = inputField.getText().trim();
			this.controller.setInput(netInputStr);
			this.dispose();
		} catch (NumberFormatException e) {
			JOptionPane.showConfirmDialog(
							null,
							"Invalid input format! All inputs must be numeric values.\nPlease enter network input as numbers separated with whitespace.",
							"Error", JOptionPane.DEFAULT_OPTION);
		} catch (Exception e) {
			JOptionPane.showConfirmDialog(null, e.getMessage(), "Error",
					JOptionPane.DEFAULT_OPTION);
            e.printStackTrace();
		}
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JPanel buttonPanel;
	private javax.swing.JButton cancelButton;
	private javax.swing.JButton helpButton;
	private javax.swing.JTextField inputField;
	private javax.swing.JPanel inputPanel;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JButton okButton;
	// End of variables declaration//GEN-END:variables

}
