/*
 * RenameNodeDialog.java
 *
 * Created on January 3, 2009, 2:31 AM
 */

package org.neuroph.easyneurons.dialog;

import java.awt.event.KeyEvent;

import org.jdesktop.application.Action;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.learning.TrainingSet;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;
import org.neuroph.util.plugins.LabelsPlugin;

/**
 * 
 * @author Zoran Sevarac <sevarac@gmail.com>
 */
public class RenameNodeDialog extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	EasyNeuronsApplicationView mainFrame;
	Object selectedNode;

	/** Creates new form RenameNodeDialog */
	public RenameNodeDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
	}

	public RenameNodeDialog(java.awt.Frame parent, boolean modal, Object selectedNode) {
		super(parent, modal);
		initComponents();
		this.mainFrame = EasyNeuronsApplicationView.getInstance();
		this.selectedNode = selectedNode;
		this.nameTextField.setText(selectedNode.toString());
		this.nameTextField.setSelectionStart(0);
		this.nameTextField.setSelectionEnd(nameTextField.getText().length());

	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
	// desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {
		java.awt.GridBagConstraints gridBagConstraints;

		jPanel1 = new javax.swing.JPanel();
		nameTextField = new javax.swing.JTextField();
		okButton = new javax.swing.JButton();
		cancelButton = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application
				.getInstance(
						org.neuroph.easyneurons.EasyNeuronsApplication.class)
				.getContext().getResourceMap(RenameNodeDialog.class);
		setTitle(resourceMap.getString("Form.title")); // NOI18N
		setMinimumSize(new java.awt.Dimension(308, 43));
		setModal(true);
		setName("Form"); // NOI18N
		setResizable(false);
		getContentPane().setLayout(new java.awt.FlowLayout());

		jPanel1.setName("jPanel1"); // NOI18N
		jPanel1.setLayout(new java.awt.GridBagLayout());

		nameTextField.setColumns(20);
		nameTextField.setText(resourceMap.getString("nameTextField.text")); // NOI18N
		nameTextField.setFocusCycleRoot(true);
		nameTextField.setName("nameTextField"); // NOI18N
		nameTextField.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyReleased(java.awt.event.KeyEvent evt) {
				nameTextFieldKeyReleased(evt);
			}
		});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.weightx = 100.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
		jPanel1.add(nameTextField, gridBagConstraints);

		javax.swing.ActionMap actionMap = org.jdesktop.application.Application
				.getInstance(
						org.neuroph.easyneurons.EasyNeuronsApplication.class)
				.getContext().getActionMap(RenameNodeDialog.class, this);
		okButton.setAction(actionMap.get("ok")); // NOI18N
		okButton.setName("okButton"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
		jPanel1.add(okButton, gridBagConstraints);

		cancelButton.setAction(actionMap.get("cancel")); // NOI18N
		cancelButton.setName("cancelButton"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
		jPanel1.add(cancelButton, gridBagConstraints);

		getContentPane().add(jPanel1);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void nameTextFieldKeyReleased(java.awt.event.KeyEvent evt) {// GEN-FIRST:event_nameTextFieldKeyReleased
		int key = evt.getKeyCode();
		if (key == KeyEvent.VK_ENTER) {
			this.ok();
		} else if (key == KeyEvent.VK_ESCAPE) {
			this.cancel();
		}
	}// GEN-LAST:event_nameTextFieldKeyReleased

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				RenameNodeDialog dialog = new RenameNodeDialog(
						new javax.swing.JFrame(), true);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}

	@Action
	public void cancel() {
		this.dispose();
	}

	@Action
	public void ok() {

		String newLabel = nameTextField.getText().trim();

		if (selectedNode instanceof NeuralNetwork) {
			NeuralNetwork nnet = (NeuralNetwork) selectedNode;
			((LabelsPlugin)nnet.getPlugin("LabelsPlugin")).setLabel(nnet, newLabel);
			mainFrame.updateProjectTree();

		} else if (selectedNode instanceof TrainingSet) {
			TrainingSet trainingSet = (TrainingSet) selectedNode;
			trainingSet.setLabel(newLabel);
			mainFrame.updateProjectTree();
		}

		mainFrame.updateFrameTitles();

		this.dispose();
	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton cancelButton;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JTextField nameTextField;
	private javax.swing.JButton okButton;
	// End of variables declaration//GEN-END:variables

}
