/*
 * OutstarWizard.java
 *
 * Created on April 11, 2009, 10:05 AM
 */
package org.neuroph.easyneurons.dialog;

import org.jdesktop.application.Action;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;

/**
 *
 * @author  Zoran Sevarac <sevarac@gmail.com>
 */
public class OutstarWizard extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	EasyNeuronsApplicationView mainFrame;

	/** Creates new form OutstarWizard */
	public OutstarWizard(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
                this.mainFrame = EasyNeuronsApplicationView.getInstance();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        outputsNumLabel = new javax.swing.JLabel();
        outputsNumField = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        createButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(OutstarWizard.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setName("Form"); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setLayout(new java.awt.GridBagLayout());

        outputsNumLabel.setText(resourceMap.getString("outputsNumLabel.text")); // NOI18N
        outputsNumLabel.setName("outputsNumLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(outputsNumLabel, gridBagConstraints);

        outputsNumField.setColumns(8);
        outputsNumField.setText(resourceMap.getString("outputsNumField.text")); // NOI18N
        outputsNumField.setName("outputsNumField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(outputsNumField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        getContentPane().add(jPanel1, gridBagConstraints);

        jPanel2.setName("jPanel2"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(OutstarWizard.class, this);
        createButton.setAction(actionMap.get("create")); // NOI18N
        createButton.setName("createButton"); // NOI18N
        jPanel2.add(createButton);

        cancelButton.setAction(actionMap.get("cancel")); // NOI18N
        cancelButton.setName("cancelButton"); // NOI18N
        jPanel2.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(jPanel2, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                OutstarWizard dialog = new OutstarWizard(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

	@Action
	public void cancel() {
		setVisible(false);
		this.dispose();		
	}

	@Action
	public void create() {
		int outputsNum = Integer
				.parseInt(this.outputsNumField.getText().trim());

		mainFrame.newOutstarNetwork(outputsNum);
		this.dispose();			
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton createButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextField outputsNumField;
    private javax.swing.JLabel outputsNumLabel;
    // End of variables declaration//GEN-END:variables

}
