/*
 * MultiLayerPerceptronWizard.java
 *
 * Created on October 3, 2008, 12:19 AM
 */

package org.neuroph.easyneurons.dialog;

import org.jdesktop.application.Action;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.nnet.learning.DynamicBackPropagation;
import org.neuroph.nnet.learning.MomentumBackpropagation;
import org.neuroph.util.TransferFunctionType;

/**
 * 
 * @author Zoran Sevarac <sevarac@gmail.com>
 */
public class MultiLayerPerceptronWizard extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	EasyNeuronsApplicationView mainFrame;

	/** Creates new form MLPerceptronWizard */
	public MultiLayerPerceptronWizard(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
		fillTransferFunctionCombo();
                fillLearningRuleCombo();
                this.mainFrame = EasyNeuronsApplicationView.getInstance();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        inputPanel = new javax.swing.JPanel();
        neuronsNumLabel = new javax.swing.JLabel();
        hiddenNeuronsField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        transferComboBox = new javax.swing.JComboBox();
        useBiasCheckBox = new javax.swing.JCheckBox();
        connectIOCheckBox = new javax.swing.JCheckBox();
        learningRuleCombo = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        inputNeuronsField = new javax.swing.JTextField();
        outputNeuronsField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        buttonPanel = new javax.swing.JPanel();
        createButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jTable1.setName("jTable1"); // NOI18N
        jScrollPane1.setViewportView(jTable1);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(MultiLayerPerceptronWizard.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setName("Form"); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        inputPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        inputPanel.setName("inputPanel"); // NOI18N
        inputPanel.setLayout(new java.awt.GridBagLayout());

        neuronsNumLabel.setText(resourceMap.getString("neuronsNumLabel.text")); // NOI18N
        neuronsNumLabel.setName("neuronsNumLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        inputPanel.add(neuronsNumLabel, gridBagConstraints);

        hiddenNeuronsField.setColumns(20);
        hiddenNeuronsField.setText(resourceMap.getString("hiddenNeuronsField.text")); // NOI18N
        hiddenNeuronsField.setName("hiddenNeuronsField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        inputPanel.add(hiddenNeuronsField, gridBagConstraints);

        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        inputPanel.add(jLabel1, gridBagConstraints);

        transferComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Sigmoid", "Tanh" }));
        transferComboBox.setName("transferComboBox"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(15, 5, 5, 5);
        inputPanel.add(transferComboBox, gridBagConstraints);

        useBiasCheckBox.setSelected(true);
        useBiasCheckBox.setText(resourceMap.getString("useBiasCheckBox.text")); // NOI18N
        useBiasCheckBox.setName("useBiasCheckBox"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(useBiasCheckBox, gridBagConstraints);

        connectIOCheckBox.setText(resourceMap.getString("connectIOCheckBox.text")); // NOI18N
        connectIOCheckBox.setName("connectIOCheckBox"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(connectIOCheckBox, gridBagConstraints);

        learningRuleCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Backpropagation ", "Backpropagation with Momentum", "Dynamic Backpropagation" }));
        learningRuleCombo.setName("learningRuleCombo"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(learningRuleCombo, gridBagConstraints);

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(jLabel2, gridBagConstraints);

        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(jLabel3, gridBagConstraints);

        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        inputPanel.add(jLabel4, gridBagConstraints);

        inputNeuronsField.setColumns(3);
        inputNeuronsField.setText(resourceMap.getString("inputNeuronsField.text")); // NOI18N
        inputNeuronsField.setName("inputNeuronsField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        inputPanel.add(inputNeuronsField, gridBagConstraints);

        outputNeuronsField.setColumns(3);
        outputNeuronsField.setText(resourceMap.getString("outputNeuronsField.text")); // NOI18N
        outputNeuronsField.setName("outputNeuronsField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        inputPanel.add(outputNeuronsField, gridBagConstraints);

        jLabel5.setFont(resourceMap.getFont("jLabel5.font")); // NOI18N
        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setName("jLabel5"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        inputPanel.add(jLabel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 400.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(inputPanel, gridBagConstraints);

        buttonPanel.setName("buttonPanel"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(MultiLayerPerceptronWizard.class, this);
        createButton.setAction(actionMap.get("create")); // NOI18N
        createButton.setText(resourceMap.getString("createButton.text")); // NOI18N
        createButton.setName("createButton"); // NOI18N
        buttonPanel.add(createButton);

        cancelButton.setAction(actionMap.get("cancel")); // NOI18N
        cancelButton.setText(resourceMap.getString("cancelButton.text")); // NOI18N
        cancelButton.setName("cancelButton"); // NOI18N
        buttonPanel.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        getContentPane().add(buttonPanel, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				MultiLayerPerceptronWizard dialog = new MultiLayerPerceptronWizard(
						new javax.swing.JFrame(), true);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}

	private void fillTransferFunctionCombo() {
		transferComboBox.removeAllItems();
		transferComboBox.addItem(new ComboItem("Sigmoid", TransferFunctionType.SIGMOID.toString()));
		transferComboBox.addItem(new ComboItem("Tanh", TransferFunctionType.TANH.toString()));
	}

	private void fillLearningRuleCombo() {
		learningRuleCombo.removeAllItems();
		learningRuleCombo.addItem(new ComboItem("Backpropagation", BackPropagation.class));
		learningRuleCombo.addItem(new ComboItem("Backpropagation with Momentum", MomentumBackpropagation.class));
		learningRuleCombo.addItem(new ComboItem("Dynamic Backpropagation", DynamicBackPropagation.class));
	}

	@Action
	public void cancel() {
		this.dispose();
	}

	@Action
	public void create() {
               	String inputNeuronsNum = this.inputNeuronsField.getText().trim();
		String hiddenNeuronsNum = this.hiddenNeuronsField.getText().trim();
               	String outputNeuronsNum = this.outputNeuronsField.getText().trim();

                String neuronsStr = inputNeuronsNum + " " + hiddenNeuronsNum + " " + outputNeuronsNum;

		TransferFunctionType transferFuncType = TransferFunctionType.valueOf( ((ComboItem)transferComboBox.getSelectedItem()).getValue().toString());
                Class learningRule = (Class)((ComboItem)learningRuleCombo.getSelectedItem()).getValue();
                boolean useBias = useBiasCheckBox.isSelected();
                boolean connectIO = connectIOCheckBox.isSelected();

		mainFrame.newMLPerceptronNetwork(neuronsStr, transferFuncType, learningRule, useBias, connectIO);
		this.setVisible(false);
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox connectIOCheckBox;
    private javax.swing.JButton createButton;
    private javax.swing.JTextField hiddenNeuronsField;
    private javax.swing.JTextField inputNeuronsField;
    private javax.swing.JPanel inputPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JComboBox learningRuleCombo;
    private javax.swing.JLabel neuronsNumLabel;
    private javax.swing.JTextField outputNeuronsField;
    private javax.swing.JComboBox transferComboBox;
    private javax.swing.JCheckBox useBiasCheckBox;
    // End of variables declaration//GEN-END:variables

}