/*
 * KohonenWizard.java
 *
 * Created on October 3, 2008, 12:19 AM
 */

package org.neuroph.easyneurons.dialog;

import org.jdesktop.application.Action;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;

/**
 * 
 * @author Zoran Sevarac <sevarac@gmail.com>
 */
public class KohonenWizard extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	EasyNeuronsApplicationView mainFrame;

	/** Creates new form KohonenWizard */
	public KohonenWizard(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
                this.mainFrame = EasyNeuronsApplicationView.getInstance();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        inputPanel = new javax.swing.JPanel();
        inputNeuronsLabel = new javax.swing.JLabel();
        mapNeuronsLabel = new javax.swing.JLabel();
        inputNeuronsField = new javax.swing.JTextField();
        mapNeuronsField = new javax.swing.JTextField();
        buttonPanel = new javax.swing.JPanel();
        createButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(KohonenWizard.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setModal(true);
        setName("Form"); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        inputPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        inputPanel.setName("inputPanel"); // NOI18N
        inputPanel.setLayout(new java.awt.GridBagLayout());

        inputNeuronsLabel.setText(resourceMap.getString("inputNeuronsLabel.text")); // NOI18N
        inputNeuronsLabel.setName("inputNeuronsLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 5, 5);
        inputPanel.add(inputNeuronsLabel, gridBagConstraints);

        mapNeuronsLabel.setText(resourceMap.getString("mapNeuronsLabel.text")); // NOI18N
        mapNeuronsLabel.setName("mapNeuronsLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 5);
        inputPanel.add(mapNeuronsLabel, gridBagConstraints);

        inputNeuronsField.setColumns(8);
        inputNeuronsField.setText(resourceMap.getString("inputNeuronsField.text")); // NOI18N
        inputNeuronsField.setName("inputNeuronsField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 11);
        inputPanel.add(inputNeuronsField, gridBagConstraints);

        mapNeuronsField.setColumns(8);
        mapNeuronsField.setText(resourceMap.getString("mapNeuronsField.text")); // NOI18N
        mapNeuronsField.setName("mapNeuronsField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 10);
        inputPanel.add(mapNeuronsField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(inputPanel, gridBagConstraints);

        buttonPanel.setName("buttonPanel"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(KohonenWizard.class, this);
        createButton.setAction(actionMap.get("create")); // NOI18N
        createButton.setText(resourceMap.getString("createButton.text")); // NOI18N
        createButton.setName("createButton"); // NOI18N
        buttonPanel.add(createButton);

        cancelButton.setAction(actionMap.get("cancelKohonenWizard")); // NOI18N
        cancelButton.setText(resourceMap.getString("cancelButton.text")); // NOI18N
        cancelButton.setName("cancelButton"); // NOI18N
        buttonPanel.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        getContentPane().add(buttonPanel, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				KohonenWizard dialog = new KohonenWizard(
						new javax.swing.JFrame(), true);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}

	@Action
	public void cancelKohonenWizard() {
		setVisible(false);
	}

	@Action
	public void create() {
		int inputNeurons = Integer.parseInt(this.inputNeuronsField.getText()
				.trim());
		int mapNeurons = Integer
				.parseInt(this.mapNeuronsField.getText().trim());

		mainFrame.newKohonenNetwork(inputNeurons, mapNeurons);
		this.setVisible(false);
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton createButton;
    private javax.swing.JTextField inputNeuronsField;
    private javax.swing.JLabel inputNeuronsLabel;
    private javax.swing.JPanel inputPanel;
    private javax.swing.JTextField mapNeuronsField;
    private javax.swing.JLabel mapNeuronsLabel;
    // End of variables declaration//GEN-END:variables

}
