/*
 * LmsTrainingDialog.java
 *
 * Created on December 24, 2008, 1:14 AM
 */

package org.neuroph.easyneurons.dialog;

import org.jdesktop.application.Action;
import org.neuroph.easyneurons.NeuralNetworkTraining;
import org.neuroph.nnet.learning.LMS;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;

/**
 * 
 * @author Zoran Sevarac <sevarac@gmail.com>
 */
public class HebbianTrainingDialog extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	NeuralNetworkTraining controller;
        EasyNeuronsApplicationView mainFrame;

	/** Creates new form LmsTrainingDialog */
	public HebbianTrainingDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
	}

	public HebbianTrainingDialog(java.awt.Frame parent, boolean modal, EasyNeuronsApplicationView mainFrame,
			NeuralNetworkTraining controller) {
		super(parent, modal);
		this.controller = controller;
                this.mainFrame=mainFrame;
		initComponents();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
	// desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {
		java.awt.GridBagConstraints gridBagConstraints;

		inputPanel = new javax.swing.JPanel();
		jLabel1 = new javax.swing.JLabel();
		jLabel2 = new javax.swing.JLabel();
		jLabel3 = new javax.swing.JLabel();
		limitIterationsCheckkBox = new javax.swing.JCheckBox();
		learningRateField = new javax.swing.JTextField();
		maxErrorField = new javax.swing.JTextField();
		maxIterationsField = new javax.swing.JTextField();
		buttonPanel = new javax.swing.JPanel();
		trainButton = new javax.swing.JButton();
		closeButton = new javax.swing.JButton();
		helpButton = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application
				.getInstance(
						org.neuroph.easyneurons.EasyNeuronsApplication.class)
				.getContext().getResourceMap(HebbianTrainingDialog.class);
		setTitle(resourceMap.getString("Form.title")); // NOI18N
		setModal(true);
		setName("Form"); // NOI18N
		getContentPane().setLayout(new java.awt.GridBagLayout());

		inputPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
		inputPanel.setName("inputPanel"); // NOI18N
		inputPanel.setLayout(new java.awt.GridBagLayout());

		jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
		jLabel1.setName("jLabel1"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 5, 0);
		inputPanel.add(jLabel1, gridBagConstraints);

		jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
		jLabel2.setName("jLabel2"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
		inputPanel.add(jLabel2, gridBagConstraints);

		jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
		jLabel3.setName("jLabel3"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
		inputPanel.add(jLabel3, gridBagConstraints);

		limitIterationsCheckkBox.setText(resourceMap
				.getString("limitIterationsCheckkBox.text")); // NOI18N
		limitIterationsCheckkBox.setName("limitIterationsCheckkBox"); // NOI18N
		limitIterationsCheckkBox
				.addItemListener(new java.awt.event.ItemListener() {
					public void itemStateChanged(java.awt.event.ItemEvent evt) {
						limitIterationsCheckkBoxItemStateChanged(evt);
					}
				});
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 5);
		inputPanel.add(limitIterationsCheckkBox, gridBagConstraints);

		learningRateField.setColumns(8);
		learningRateField.setText(resourceMap
				.getString("learningRateField.text")); // NOI18N
		learningRateField.setName("learningRateField"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 80.0;
		gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 10);
		inputPanel.add(learningRateField, gridBagConstraints);

		maxErrorField.setColumns(8);
		maxErrorField.setText(resourceMap.getString("maxErrorField.text")); // NOI18N
		maxErrorField.setName("maxErrorField"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
		inputPanel.add(maxErrorField, gridBagConstraints);

		maxIterationsField.setColumns(8);
		maxIterationsField.setEnabled(false);
		maxIterationsField.setName("maxIterationsField"); // NOI18N
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
		inputPanel.add(maxIterationsField, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
		getContentPane().add(inputPanel, gridBagConstraints);

		buttonPanel.setName("buttonPanel"); // NOI18N

		javax.swing.ActionMap actionMap = org.jdesktop.application.Application
				.getInstance(
						org.neuroph.easyneurons.EasyNeuronsApplication.class)
				.getContext().getActionMap(HebbianTrainingDialog.class, this);
		trainButton.setAction(actionMap.get("train")); // NOI18N
		trainButton.setText(resourceMap.getString("trainButton.text")); // NOI18N
		trainButton.setName("trainButton"); // NOI18N
		buttonPanel.add(trainButton);

		closeButton.setAction(actionMap.get("close")); // NOI18N
		closeButton.setText(resourceMap.getString("closeButton.text")); // NOI18N
		closeButton.setName("closeButton"); // NOI18N
		buttonPanel.add(closeButton);

		helpButton.setText(resourceMap.getString("helpButton.text")); // NOI18N
		helpButton.setEnabled(false);
		helpButton.setName("helpButton"); // NOI18N
		buttonPanel.add(helpButton);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
		getContentPane().add(buttonPanel, gridBagConstraints);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void limitIterationsCheckkBoxItemStateChanged(
			java.awt.event.ItemEvent evt) {// GEN-FIRST:event_limitIterationsCheckkBoxItemStateChanged
		if (this.maxIterationsField.isEnabled())
			this.maxIterationsField.setEnabled(false);
		else
			this.maxIterationsField.setEnabled(true);
	}// GEN-LAST:event_limitIterationsCheckkBoxItemStateChanged

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				HebbianTrainingDialog dialog = new HebbianTrainingDialog(
						new javax.swing.JFrame(), true);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}

	@Action
	public void close() {
		this.dispose();
	}

	@Action
	public void train() {
		String learningRateStr = learningRateField.getText().toString();
		String maxErrorStr = maxErrorField.getText().toString();
		String maxIterationsStr = maxIterationsField.getText().toString();

		Double learningRate = new Double(learningRateStr);
		Double maxError = new Double(maxErrorStr);
		Integer maxIterations = new Integer(0);

		if (limitIterationsCheckkBox.isSelected())
			maxIterations = new Integer(maxIterationsStr);

		controller.setLmsParams(learningRate, maxError, maxIterations);

		LMS learningRule = (LMS) this.controller.getNetwork().getLearningRule();
//		SupervisedTrainingMonitor lmsTrainingMonitor = new SupervisedTrainingMonitor(null,
//				true, this.controller);
//		lmsTrainingMonitor.setLocationRelativeTo(this);
//		lms.addObserver(lmsTrainingMonitor);

                SupervisedTrainingMonitorFrame monitorFrame = mainFrame.openMonitorFrame(this.controller);
                learningRule.addObserver(monitorFrame);

		controller.train();

		this.dispose();
//		lmsTrainingMonitor.setVisible(true);

	}

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JPanel buttonPanel;
	private javax.swing.JButton closeButton;
	private javax.swing.JButton helpButton;
	private javax.swing.JPanel inputPanel;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JLabel jLabel3;
	private javax.swing.JTextField learningRateField;
	private javax.swing.JCheckBox limitIterationsCheckkBox;
	private javax.swing.JTextField maxErrorField;
	private javax.swing.JTextField maxIterationsField;
	private javax.swing.JButton trainButton;
	// End of variables declaration//GEN-END:variables

}
