/*
 * PerceptronWizard.java
 *
 * Created on October 3, 2008, 12:18 AM
 */

package org.neuroph.easyneurons.dialog;

import org.jdesktop.application.Action;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;

/**
 * 
 * @author Zoran Sevarac <sevarac@gmail.com>
 */
public class CompetitiveNetworkWizard extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	EasyNeuronsApplicationView mainFrame;

	/** Creates new form PerceptronWizard */
	public CompetitiveNetworkWizard(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
                this.mainFrame = EasyNeuronsApplicationView.getInstance();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        inputPanel = new javax.swing.JPanel();
        inputsNumLabel = new javax.swing.JLabel();
        outputsNumLabel = new javax.swing.JLabel();
        inputsNumField = new javax.swing.JTextField();
        outputsNumField = new javax.swing.JTextField();
        buttonPanel = new javax.swing.JPanel();
        createButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(CompetitiveNetworkWizard.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setModal(true);
        setName("Form"); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        inputPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        inputPanel.setName("inputPanel"); // NOI18N
        inputPanel.setLayout(new java.awt.GridBagLayout());

        inputsNumLabel.setText(resourceMap.getString("inputsNumLabel.text")); // NOI18N
        inputsNumLabel.setName("inputsNumLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 15, 5, 5);
        inputPanel.add(inputsNumLabel, gridBagConstraints);

        outputsNumLabel.setText(resourceMap.getString("outputsNumLabel.text")); // NOI18N
        outputsNumLabel.setName("outputsNumLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        inputPanel.add(outputsNumLabel, gridBagConstraints);

        inputsNumField.setColumns(8);
        inputsNumField.setName("inputsNumField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 15);
        inputPanel.add(inputsNumField, gridBagConstraints);

        outputsNumField.setColumns(8);
        outputsNumField.setName("outputsNumField"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 15);
        inputPanel.add(outputsNumField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(inputPanel, gridBagConstraints);

        buttonPanel.setName("buttonPanel"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(CompetitiveNetworkWizard.class, this);
        createButton.setAction(actionMap.get("create")); // NOI18N
        createButton.setName("createButton"); // NOI18N
        buttonPanel.add(createButton);

        cancelButton.setAction(actionMap.get("cancel")); // NOI18N
        cancelButton.setName("cancelButton"); // NOI18N
        buttonPanel.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        getContentPane().add(buttonPanel, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				CompetitiveNetworkWizard dialog = new CompetitiveNetworkWizard(
						new javax.swing.JFrame(), true);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}

	@Action
	public void create() {
		int inputNeuronsNum = Integer.parseInt(this.inputsNumField.getText()
				.trim());
		int outputNeuronsNum = Integer.parseInt(this.outputsNumField.getText()
				.trim());

		mainFrame.newCompetitiveNetwork(inputNeuronsNum, outputNeuronsNum);
		this.dispose();
	}

	@Action
	public void cancel() {
		setVisible(false);
		this.dispose();
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton createButton;
    private javax.swing.JPanel inputPanel;
    private javax.swing.JTextField inputsNumField;
    private javax.swing.JLabel inputsNumLabel;
    private javax.swing.JTextField outputsNumField;
    private javax.swing.JLabel outputsNumLabel;
    // End of variables declaration//GEN-END:variables

}
