/*
 * AdalineWizard.java
 *
 * Created on October 3, 2008, 12:18 AM
 */

package org.neuroph.easyneurons.dialog;

import java.awt.event.KeyEvent;

import javax.swing.JOptionPane;

import org.jdesktop.application.Action;
import org.neuroph.easyneurons.EasyNeuronsApplicationView;

/**
 * 
 * @author Zoran Sevarac <sevarac@gmail.com>
 */
public class AdalineWizard extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	EasyNeuronsApplicationView mainFrame;

	public AdalineWizard(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
                this.mainFrame = EasyNeuronsApplicationView.getInstance();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        inputPanel = new javax.swing.JPanel();
        inputsNumLabel = new javax.swing.JLabel();
        inputsNumField = new javax.swing.JTextField();
        buttonPanel = new javax.swing.JPanel();
        createButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(AdalineWizard.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setName("Form"); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        inputPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        inputPanel.setName("inputPanel"); // NOI18N
        inputPanel.setLayout(new java.awt.GridBagLayout());

        inputsNumLabel.setText(resourceMap.getString("inputsNumLabel.text")); // NOI18N
        inputsNumLabel.setName("inputsNumLabel"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 5);
        inputPanel.add(inputsNumLabel, gridBagConstraints);

        inputsNumField.setColumns(8);
        inputsNumField.setText(resourceMap.getString("inputsNumField.text")); // NOI18N
        inputsNumField.setName("inputsNumField"); // NOI18N
        inputsNumField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                inputsNumFieldKeyPressed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 10, 10);
        inputPanel.add(inputsNumField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(inputPanel, gridBagConstraints);

        buttonPanel.setName("buttonPanel"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(AdalineWizard.class, this);
        createButton.setAction(actionMap.get("create")); // NOI18N
        createButton.setText(resourceMap.getString("createButton.text")); // NOI18N
        createButton.setName("createButton"); // NOI18N
        buttonPanel.add(createButton);

        cancelButton.setAction(actionMap.get("cancel")); // NOI18N
        cancelButton.setText(resourceMap.getString("cancelButton.text")); // NOI18N
        cancelButton.setName("cancelButton"); // NOI18N
        buttonPanel.add(cancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        getContentPane().add(buttonPanel, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

	private void inputsNumFieldKeyPressed(java.awt.event.KeyEvent evt) {// GEN-FIRST:event_inputsNumFieldKeyPressed
	// TODO add your handling code here:
		int key = evt.getKeyCode();
		if (key == KeyEvent.VK_ENTER) {
			this.create();
		} else if (key == KeyEvent.VK_ESCAPE) {
			this.cancel();
		}
	}// GEN-LAST:event_inputsNumFieldKeyPressed

	/**
	 * @param args
	 *            the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				AdalineWizard dialog = new AdalineWizard(
						new javax.swing.JFrame(), true);
				dialog.addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent e) {
						System.exit(0);
					}
				});
				dialog.setVisible(true);
			}
		});
	}

	@Action
	public void cancel() {
		this.dispose();
	}

	@Action
	public void create() {
		try {
			int neuronNum = Integer.parseInt(this.inputsNumField.getText()
					.trim());
			mainFrame.newAdalineNetwork(neuronNum);
			this.dispose();
		} catch (NumberFormatException e) {
			JOptionPane
					.showConfirmDialog(
							null,
							"Invalid number format!\nPlease enter number of inputs for adaline as non-zero whole numbers.",
							"Error", JOptionPane.DEFAULT_OPTION);
		}
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton createButton;
    private javax.swing.JPanel inputPanel;
    private javax.swing.JTextField inputsNumField;
    private javax.swing.JLabel inputsNumLabel;
    // End of variables declaration//GEN-END:variables

}
