/*
 * EasyNeuronsApplicationView.java
 * odraditi serijalizaciju i snimanje (treba dodati lokaciju kao promenjivu u neural net i training set)
 */

package org.neuroph.easyneurons;

import org.neuroph.easyneurons.samples.mlperceptron.TransferableObject;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import org.neuroph.easyneurons.samples.perceptron.PerceptronSampleTrainingSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Observable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

import org.jdesktop.application.Action;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.learning.SupervisedTrainingElement;
import org.neuroph.core.learning.TrainingElement;
import org.neuroph.core.learning.TrainingSet;
import org.neuroph.core.transfer.Trapezoid;
import org.neuroph.easyneurons.dialog.AdalineWizard;
import org.neuroph.easyneurons.dialog.BamWizard;
import org.neuroph.easyneurons.dialog.CompetitiveNetworkWizard;
import org.neuroph.easyneurons.dialog.HopfieldWizard;
import org.neuroph.easyneurons.dialog.InstarWizard;
import org.neuroph.easyneurons.dialog.KohonenWizard;
import org.neuroph.easyneurons.dialog.MultiLayerPerceptronWizard;
import org.neuroph.easyneurons.dialog.MaxnetWizard;
import org.neuroph.easyneurons.dialog.NeuronPropertiesFrame;
import org.neuroph.easyneurons.dialog.OutstarWizard;
import org.neuroph.easyneurons.dialog.PerceptronWizard;
import org.neuroph.easyneurons.dialog.RbfWizard;
import org.neuroph.easyneurons.dialog.RenameNodeDialog;
import org.neuroph.easyneurons.dialog.SupervisedHebbianWizard;
import org.neuroph.easyneurons.dialog.TrainingSetWizard;
import org.neuroph.easyneurons.dialog.UnsupervisedHebbianWizard;
import org.neuroph.easyneurons.errorgraph.GraphFrame;
import org.neuroph.easyneurons.file.FileFilterAdapter;
import org.neuroph.easyneurons.file.FileIO;
import org.neuroph.easyneurons.file.FileObserver;
import org.neuroph.easyneurons.file.FileUtils;
import org.neuroph.easyneurons.file.WindowObserver;
import org.neuroph.easyneurons.samples.BasicNeuronSample;
import org.neuroph.easyneurons.samples.KohonenSample;
import org.neuroph.easyneurons.samples.NFRSample;
import org.neuroph.nnet.Adaline;
import org.neuroph.nnet.BAM;
import org.neuroph.nnet.CompetitiveNetwork;
import org.neuroph.nnet.Hopfield;
import org.neuroph.nnet.Instar;
import org.neuroph.nnet.Kohonen;
import org.neuroph.nnet.MaxNet;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.nnet.NeuroFuzzyPerceptron;
import org.neuroph.nnet.Outstar;
import org.neuroph.nnet.Perceptron;
import org.neuroph.nnet.RbfNetwork;
import org.neuroph.nnet.SupervisedHebbianNetwork;
import org.neuroph.nnet.UnsupervisedHebbianNetwork;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.TransferFunctionType;
import org.neuroph.util.plugins.LabelsPlugin;
import org.neuroph.easyneurons.dialog.SupervisedTrainingMonitorFrame;
import org.neuroph.easyneurons.ocr.hwr.HandwritingRecognitionToolFrame;
import org.neuroph.easyneurons.ocr.tcr.TextRecognitionFrame;
import org.neuroph.nnet.learning.BackPropagation;
import org.neuroph.nnet.learning.BinaryDeltaRule;

/**
 * The application's main frame.
 */
public class EasyNeuronsApplicationView extends FrameView implements
		Serializable {
	private static final long serialVersionUID = 1L;
        int counter = 0;
        public static EasyNeuronsApplicationView myInstance;
	
	private EasyNeuronsProject easyNeuronsProject;
	private NeuralNetworkViewFrame netActiveWindow = null; // ovo je dodato
	private TrainingSet traActiveWindow = null; // ovo je dodato
	private FileObserver fileObserver = new FileObserver(); // ovo je dodato
	private JFileChooser fileChooser = new JFileChooser();
	private JFrame mainFrame = EasyNeuronsApplication.getApplication()
			.getMainFrame();
        private ProjectManager projectManager;
    
	public EasyNeuronsApplicationView(SingleFrameApplication app) {
		super(app);

		initComponents();

		// status bar initialization - message timeout, idle icon and busy
		// animation, etc
		ResourceMap resourceMap = getResourceMap();
		int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
		messageTimer = new Timer(messageTimeout, new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				statusMessageLabel.setText("");
			}
		});
		messageTimer.setRepeats(false);
		int busyAnimationRate = resourceMap
				.getInteger("StatusBar.busyAnimationRate");
		for (int i = 0; i < busyIcons.length; i++) {
			busyIcons[i] = resourceMap
					.getIcon("StatusBar.busyIcons[" + i + "]");
		}
		busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
				statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
			}
		});
		idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
		statusAnimationLabel.setIcon(idleIcon);
		progressBar.setVisible(false);

		// connecting action tasks to status bar via TaskMonitor
		TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
		taskMonitor
				.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
					public void propertyChange(
							java.beans.PropertyChangeEvent evt) {
						String propertyName = evt.getPropertyName();
						if ("started".equals(propertyName)) {
							if (!busyIconTimer.isRunning()) {
								statusAnimationLabel.setIcon(busyIcons[0]);
								busyIconIndex = 0;
								busyIconTimer.start();
							}
							progressBar.setVisible(true);
							progressBar.setIndeterminate(true);
						} else if ("done".equals(propertyName)) {
							busyIconTimer.stop();
							statusAnimationLabel.setIcon(idleIcon);
							progressBar.setVisible(false);
							progressBar.setValue(0);
						} else if ("message".equals(propertyName)) {
							String text = (String) (evt.getNewValue());
							statusMessageLabel.setText((text == null) ? ""
									: text);
							messageTimer.restart();
						} else if ("progress".equals(propertyName)) {
							int value = (Integer) (evt.getNewValue());
							progressBar.setVisible(true);
							progressBar.setIndeterminate(false);
							progressBar.setValue(value);
						}
					}
				});

		// fix for shutdown on window close
		JFrame mainFrame2 = this.getFrame();
		mainFrame2.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		this.easyNeuronsProject = new EasyNeuronsProject();

		MouseListener ml = new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				int selRow = projectTree.getRowForLocation(e.getX(), e.getY());
				TreePath selPath = projectTree.getPathForLocation(e.getX(), e
						.getY());
				if (selRow != -1) {
					if (e.getClickCount() == 2) {
						treeNodeDoubleClick(selRow, selPath);
					}
				}
			}

		};

		projectTree.addMouseListener(ml);

		DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
                // renderer.setOpenIcon();
                // renderer.setClosedIcon();
		renderer.setLeafIcon(null);
		projectTree.setCellRenderer(renderer);

		this.updateProjectTree();

		desktopPanel.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
                this.myInstance = this;
                projectManager = new ProjectManager(easyNeuronsProject);

// DragNDrop - start
                //DnD Listeneri - dodavanje
                 projectTree.setDragEnabled(false);
                //JTree myTree = getProjectTree();
                 this.dragSource = DragSource.getDefaultDragSource();

                 this.dgListener = new DGListener();
                 this.dsListener = new DSListener();
                 this.tsListener = new TSListener();

                // component, action, listener
                this.dragSource.createDefaultDragGestureRecognizer(
                     projectTree,
                     this.dragAction,
                      this.dgListener);


                projectTree.addTreeSelectionListener(tsListener);
// DragNDrop - end

	}

	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed"
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        jToolBar1 = new javax.swing.JToolBar();
        openButton = new javax.swing.JButton();
        saveButton = new javax.swing.JButton();
        newTrainingSetButton = new javax.swing.JButton();
        jSplitPane1 = new javax.swing.JSplitPane();
        projectTreeScrollPane = new javax.swing.JScrollPane();
        projectTree = new javax.swing.JTree();
        jSplitPane2 = new javax.swing.JSplitPane();
        desktopPanel = new javax.swing.JDesktopPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        messageBox = new javax.swing.JTextArea();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        openMenuItem = new javax.swing.JMenuItem();
        saveMenuItem = new javax.swing.JMenuItem();
        saveAsMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        editMenu = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMenuItem3 = new javax.swing.JMenuItem();
        jMenuItem4 = new javax.swing.JMenuItem();
        jMenuItem6 = new javax.swing.JMenuItem();
        viewMenu = new javax.swing.JMenu();
        viewBlockMenuItem = new javax.swing.JMenuItem();
        viewGraphMenuItem = new javax.swing.JMenuItem();
        viewRefreshMenuItem = new javax.swing.JMenuItem();
        networksMenu = new javax.swing.JMenu();
        adalineMenuItem = new javax.swing.JMenuItem();
        perceptronMenuItem = new javax.swing.JMenuItem();
        mlpMenuItem = new javax.swing.JMenuItem();
        hopfieldMenuItem = new javax.swing.JMenuItem();
        bamMenuItem = new javax.swing.JMenuItem();
        kohonenMenuItem = new javax.swing.JMenuItem();
        supervisedHebbianMenuItem = new javax.swing.JMenuItem();
        unsupervisedHebbianMenuItem = new javax.swing.JMenuItem();
        maxnetMenuItem = new javax.swing.JMenuItem();
        competitiveMenuItem = new javax.swing.JMenuItem();
        rbfMenuItem = new javax.swing.JMenuItem();
        instarMenuItem = new javax.swing.JMenuItem();
        outstarMenuItem = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        trainingMenu = new javax.swing.JMenu();
        trainingSetWizardMenuItem = new javax.swing.JMenuItem();
        trainMenuItem = new javax.swing.JMenuItem();
        toolsMenu = new javax.swing.JMenu();
        imageRecognitionMenuItem = new javax.swing.JMenuItem();
        handwritingRecognitionMenuItem = new javax.swing.JMenuItem();
        textRecognitionMenuItem = new javax.swing.JMenuItem();
        samplesMenu = new javax.swing.JMenu();
        sampleBasicNeuron = new javax.swing.JMenuItem();
        sampleKohonenMenuItem = new javax.swing.JMenuItem();
        sampleNFRMenuItem = new javax.swing.JMenuItem();
        sampleRecommenderMenuItem = new javax.swing.JMenuItem();
        samplePerceptronMenuItem = new javax.swing.JMenuItem();
        sampleMLPerceptronMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        jMenuItem7 = new javax.swing.JMenuItem();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();
        treePopupMenu = new javax.swing.JPopupMenu();
        renameMenuItem = new javax.swing.JMenuItem();
        removeMenuItem = new javax.swing.JMenuItem();

        mainPanel.setName("mainPanel"); // NOI18N
        mainPanel.setPreferredSize(new java.awt.Dimension(900, 600));
        mainPanel.setLayout(new java.awt.BorderLayout(2, 2));

        jToolBar1.setRollover(true);
        jToolBar1.setName("jToolBar1"); // NOI18N
        jToolBar1.setPreferredSize(new java.awt.Dimension(154, 33));

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getActionMap(EasyNeuronsApplicationView.class, this);
        openButton.setAction(actionMap.get("showOpenDialog")); // NOI18N
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.neuroph.easyneurons.EasyNeuronsApplication.class).getContext().getResourceMap(EasyNeuronsApplicationView.class);
        openButton.setIcon(resourceMap.getIcon("openButton.icon")); // NOI18N
        openButton.setText(resourceMap.getString("openButton.text")); // NOI18N
        openButton.setToolTipText(resourceMap.getString("openButton.toolTipText")); // NOI18N
        openButton.setFocusable(false);
        openButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        openButton.setName("openButton"); // NOI18N
        openButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(openButton);

        saveButton.setAction(actionMap.get("showSaveDialog")); // NOI18N
        saveButton.setIcon(resourceMap.getIcon("saveButton.icon")); // NOI18N
        saveButton.setText(resourceMap.getString("saveButton.text")); // NOI18N
        saveButton.setToolTipText(resourceMap.getString("saveButton.toolTipText")); // NOI18N
        saveButton.setFocusable(false);
        saveButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        saveButton.setName("saveButton"); // NOI18N
        saveButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(saveButton);

        newTrainingSetButton.setAction(actionMap.get("showTrainingSetWizard")); // NOI18N
        newTrainingSetButton.setIcon(resourceMap.getIcon("newTrainingSetButton.icon")); // NOI18N
        newTrainingSetButton.setText(resourceMap.getString("newTrainingSetButton.text")); // NOI18N
        newTrainingSetButton.setToolTipText(resourceMap.getString("newTrainingSetButton.toolTipText")); // NOI18N
        newTrainingSetButton.setFocusable(false);
        newTrainingSetButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        newTrainingSetButton.setName("newTrainingSetButton"); // NOI18N
        newTrainingSetButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolBar1.add(newTrainingSetButton);

        mainPanel.add(jToolBar1, java.awt.BorderLayout.PAGE_START);

        jSplitPane1.setMaximumSize(null);
        jSplitPane1.setName("jSplitPane1"); // NOI18N

        projectTreeScrollPane.setAlignmentX(1.0F);
        projectTreeScrollPane.setAlignmentY(1.0F);
        projectTreeScrollPane.setName("projectTreeScrollPane"); // NOI18N

        projectTree.setAutoscrolls(true);
        projectTree.setComponentPopupMenu(treePopupMenu);
        projectTree.setDragEnabled(true);
        projectTree.setMaximumSize(new java.awt.Dimension(100, 64));
        projectTree.setName("projectTree"); // NOI18N
        projectTree.setPreferredSize(new java.awt.Dimension(150, 100));
        projectTree.setRowHeight(22);
        projectTreeScrollPane.setViewportView(projectTree);

        jSplitPane1.setLeftComponent(projectTreeScrollPane);

        jSplitPane2.setDividerLocation(590);
        jSplitPane2.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane2.setAutoscrolls(true);
        jSplitPane2.setContinuousLayout(true);
        jSplitPane2.setMaximumSize(null);
        jSplitPane2.setName("jSplitPane2"); // NOI18N

        desktopPanel.setName("desktopPanel"); // NOI18N
        jSplitPane2.setLeftComponent(desktopPanel);

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        messageBox.setColumns(20);
        messageBox.setEditable(false);
        messageBox.setFont(resourceMap.getFont("messageBox.font")); // NOI18N
        messageBox.setRows(8);
        messageBox.setName("messageBox"); // NOI18N
        jScrollPane1.setViewportView(messageBox);

        jSplitPane2.setRightComponent(jScrollPane1);

        jSplitPane1.setRightComponent(jSplitPane2);

        mainPanel.add(jSplitPane1, java.awt.BorderLayout.CENTER);

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        openMenuItem.setAction(actionMap.get("showOpenDialog")); // NOI18N
        openMenuItem.setToolTipText(resourceMap.getString("openMenuItem.toolTipText")); // NOI18N
        openMenuItem.setName("openMenuItem"); // NOI18N
        fileMenu.add(openMenuItem);

        saveMenuItem.setAction(actionMap.get("showSaveDialog")); // NOI18N
        saveMenuItem.setText(resourceMap.getString("saveMenuItem.text")); // NOI18N
        saveMenuItem.setToolTipText(resourceMap.getString("saveMenuItem.toolTipText")); // NOI18N
        saveMenuItem.setName("saveMenuItem"); // NOI18N
        fileMenu.add(saveMenuItem);

        saveAsMenuItem.setAction(actionMap.get("showSaveAsDialog")); // NOI18N
        saveAsMenuItem.setText(resourceMap.getString("saveAsMenuItem.text")); // NOI18N
        saveAsMenuItem.setToolTipText(resourceMap.getString("saveAsMenuItem.toolTipText")); // NOI18N
        saveAsMenuItem.setName("saveAsMenuItem"); // NOI18N
        fileMenu.add(saveAsMenuItem);

        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        editMenu.setText(resourceMap.getString("editMenu.text")); // NOI18N
        editMenu.setName("editMenu"); // NOI18N

        jMenuItem1.setText(resourceMap.getString("jMenuItem1.text")); // NOI18N
        jMenuItem1.setEnabled(false);
        jMenuItem1.setName("jMenuItem1"); // NOI18N
        editMenu.add(jMenuItem1);

        jMenuItem2.setText(resourceMap.getString("jMenuItem2.text")); // NOI18N
        jMenuItem2.setEnabled(false);
        jMenuItem2.setName("jMenuItem2"); // NOI18N
        editMenu.add(jMenuItem2);

        jMenuItem3.setText(resourceMap.getString("jMenuItem3.text")); // NOI18N
        jMenuItem3.setEnabled(false);
        jMenuItem3.setName("jMenuItem3"); // NOI18N
        editMenu.add(jMenuItem3);

        jMenuItem4.setText(resourceMap.getString("jMenuItem4.text")); // NOI18N
        jMenuItem4.setEnabled(false);
        jMenuItem4.setName("jMenuItem4"); // NOI18N
        editMenu.add(jMenuItem4);

        jMenuItem6.setText(resourceMap.getString("jMenuItem6.text")); // NOI18N
        jMenuItem6.setEnabled(false);
        jMenuItem6.setName("jMenuItem6"); // NOI18N
        editMenu.add(jMenuItem6);

        menuBar.add(editMenu);

        viewMenu.setText(resourceMap.getString("viewMenu.text")); // NOI18N
        viewMenu.setName("viewMenu"); // NOI18N

        viewBlockMenuItem.setAction(actionMap.get("switchToBlockView")); // NOI18N
        viewBlockMenuItem.setText(resourceMap.getString("viewBlockMenuItem.text")); // NOI18N
        viewBlockMenuItem.setName("viewBlockMenuItem"); // NOI18N
        viewMenu.add(viewBlockMenuItem);

        viewGraphMenuItem.setAction(actionMap.get("switchToGraphView")); // NOI18N
        viewGraphMenuItem.setText(resourceMap.getString("viewGraphMenuItem.text")); // NOI18N
        viewGraphMenuItem.setName("viewGraphMenuItem"); // NOI18N
        viewMenu.add(viewGraphMenuItem);

        viewRefreshMenuItem.setAction(actionMap.get("refreshView")); // NOI18N
        viewRefreshMenuItem.setText(resourceMap.getString("viewRefreshMenuItem.text")); // NOI18N
        viewRefreshMenuItem.setName("viewRefreshMenuItem"); // NOI18N
        viewMenu.add(viewRefreshMenuItem);

        menuBar.add(viewMenu);

        networksMenu.setText(resourceMap.getString("networksMenu.text")); // NOI18N
        networksMenu.setName("networksMenu"); // NOI18N

        adalineMenuItem.setAction(actionMap.get("showAdalineWizard")); // NOI18N
        adalineMenuItem.setText(resourceMap.getString("adalineMenuItem.text")); // NOI18N
        adalineMenuItem.setToolTipText(resourceMap.getString("adalineMenuItem.toolTipText")); // NOI18N
        adalineMenuItem.setName("adalineMenuItem"); // NOI18N
        networksMenu.add(adalineMenuItem);

        perceptronMenuItem.setAction(actionMap.get("showPerceptronWizard")); // NOI18N
        perceptronMenuItem.setText(resourceMap.getString("perceptronMenuItem.text")); // NOI18N
        perceptronMenuItem.setToolTipText(resourceMap.getString("perceptronMenuItem.toolTipText")); // NOI18N
        perceptronMenuItem.setName("perceptronMenuItem"); // NOI18N
        networksMenu.add(perceptronMenuItem);

        mlpMenuItem.setAction(actionMap.get("showMLPerceptronWizard")); // NOI18N
        mlpMenuItem.setText(resourceMap.getString("mlpMenuItem.text")); // NOI18N
        mlpMenuItem.setToolTipText(resourceMap.getString("mlpMenuItem.toolTipText")); // NOI18N
        mlpMenuItem.setName("mlpMenuItem"); // NOI18N
        networksMenu.add(mlpMenuItem);

        hopfieldMenuItem.setAction(actionMap.get("showHopfieldWizard")); // NOI18N
        hopfieldMenuItem.setText(resourceMap.getString("hopfieldMenuItem.text")); // NOI18N
        hopfieldMenuItem.setToolTipText(resourceMap.getString("hopfieldMenuItem.toolTipText")); // NOI18N
        hopfieldMenuItem.setName("hopfieldMenuItem"); // NOI18N
        networksMenu.add(hopfieldMenuItem);

        bamMenuItem.setAction(actionMap.get("showBAMWizard")); // NOI18N
        bamMenuItem.setText(resourceMap.getString("bamMenuItem.text")); // NOI18N
        bamMenuItem.setName("bamMenuItem"); // NOI18N
        networksMenu.add(bamMenuItem);

        kohonenMenuItem.setAction(actionMap.get("showKohonenWizard")); // NOI18N
        kohonenMenuItem.setToolTipText(resourceMap.getString("kohonenMenuItem.toolTipText")); // NOI18N
        kohonenMenuItem.setName("kohonenMenuItem"); // NOI18N
        networksMenu.add(kohonenMenuItem);

        supervisedHebbianMenuItem.setAction(actionMap.get("showHebbianWizard")); // NOI18N
        supervisedHebbianMenuItem.setText(resourceMap.getString("supervisedHebbianMenuItem.text")); // NOI18N
        supervisedHebbianMenuItem.setToolTipText(resourceMap.getString("supervisedHebbianMenuItem.toolTipText")); // NOI18N
        supervisedHebbianMenuItem.setName("supervisedHebbianMenuItem"); // NOI18N
        networksMenu.add(supervisedHebbianMenuItem);

        unsupervisedHebbianMenuItem.setAction(actionMap.get("showUnsupervisedHebbianWizard")); // NOI18N
        unsupervisedHebbianMenuItem.setText(resourceMap.getString("unsupervisedHebbianMenuItem.text")); // NOI18N
        unsupervisedHebbianMenuItem.setName("unsupervisedHebbianMenuItem"); // NOI18N
        networksMenu.add(unsupervisedHebbianMenuItem);

        maxnetMenuItem.setAction(actionMap.get("showMaxnetWizard")); // NOI18N
        maxnetMenuItem.setText(resourceMap.getString("maxnetMenuItem.text")); // NOI18N
        maxnetMenuItem.setName("maxnetMenuItem"); // NOI18N
        networksMenu.add(maxnetMenuItem);

        competitiveMenuItem.setAction(actionMap.get("showCompetitiveNetworkWizard")); // NOI18N
        competitiveMenuItem.setText(resourceMap.getString("competitiveMenuItem.text")); // NOI18N
        competitiveMenuItem.setName("competitiveMenuItem"); // NOI18N
        networksMenu.add(competitiveMenuItem);

        rbfMenuItem.setAction(actionMap.get("showRbfWizard")); // NOI18N
        rbfMenuItem.setName("rbfMenuItem"); // NOI18N
        networksMenu.add(rbfMenuItem);

        instarMenuItem.setAction(actionMap.get("showInstarWizard")); // NOI18N
        instarMenuItem.setText(resourceMap.getString("instarMenuItem.text")); // NOI18N
        instarMenuItem.setName("instarMenuItem"); // NOI18N
        networksMenu.add(instarMenuItem);

        outstarMenuItem.setAction(actionMap.get("showOutstarWizard")); // NOI18N
        outstarMenuItem.setText(resourceMap.getString("outstarMenuItem.text")); // NOI18N
        outstarMenuItem.setName("outstarMenuItem"); // NOI18N
        networksMenu.add(outstarMenuItem);

        jSeparator1.setName("jSeparator1"); // NOI18N
        networksMenu.add(jSeparator1);

        menuBar.add(networksMenu);

        trainingMenu.setText(resourceMap.getString("trainingMenu.text")); // NOI18N
        trainingMenu.setName("trainingMenu"); // NOI18N

        trainingSetWizardMenuItem.setAction(actionMap.get("showTrainingSetWizard")); // NOI18N
        trainingSetWizardMenuItem.setText(resourceMap.getString("trainingSetWizardMenuItem.text")); // NOI18N
        trainingSetWizardMenuItem.setToolTipText(resourceMap.getString("trainingSetWizardMenuItem.toolTipText")); // NOI18N
        trainingSetWizardMenuItem.setName("trainingSetWizardMenuItem"); // NOI18N
        trainingMenu.add(trainingSetWizardMenuItem);

        trainMenuItem.setAction(actionMap.get("trainNetwork")); // NOI18N
        trainMenuItem.setText(resourceMap.getString("trainMenuItem.text")); // NOI18N
        trainMenuItem.setToolTipText(resourceMap.getString("trainMenuItem.toolTipText")); // NOI18N
        trainMenuItem.setName("trainMenuItem"); // NOI18N
        trainingMenu.add(trainMenuItem);

        menuBar.add(trainingMenu);

        toolsMenu.setText(resourceMap.getString("toolsMenu.text")); // NOI18N
        toolsMenu.setName("toolsMenu"); // NOI18N

        imageRecognitionMenuItem.setAction(actionMap.get("imageRecognitionSample")); // NOI18N
        imageRecognitionMenuItem.setText(resourceMap.getString("imageRecognitionMenuItem.text")); // NOI18N
        imageRecognitionMenuItem.setName("imageRecognitionMenuItem"); // NOI18N
        toolsMenu.add(imageRecognitionMenuItem);

        handwritingRecognitionMenuItem.setAction(actionMap.get("handwritingRecogn")); // NOI18N
        handwritingRecognitionMenuItem.setText(resourceMap.getString("handwritingRecognitionMenuItem.text")); // NOI18N
        handwritingRecognitionMenuItem.setName("handwritingRecognitionMenuItem"); // NOI18N
        toolsMenu.add(handwritingRecognitionMenuItem);

        textRecognitionMenuItem.setAction(actionMap.get("characterRecognitionTool")); // NOI18N
        textRecognitionMenuItem.setText(resourceMap.getString("textRecognitionMenuItem.text")); // NOI18N
        textRecognitionMenuItem.setName("textRecognitionMenuItem"); // NOI18N
        toolsMenu.add(textRecognitionMenuItem);

        menuBar.add(toolsMenu);

        samplesMenu.setText(resourceMap.getString("samplesMenu.text")); // NOI18N
        samplesMenu.setName("samplesMenu"); // NOI18N

        sampleBasicNeuron.setAction(actionMap.get("showBasicNeuronSample")); // NOI18N
        sampleBasicNeuron.setText(resourceMap.getString("sampleBasicNeuron.text")); // NOI18N
        sampleBasicNeuron.setName("sampleBasicNeuron"); // NOI18N
        samplesMenu.add(sampleBasicNeuron);

        sampleKohonenMenuItem.setAction(actionMap.get("kohonenSample")); // NOI18N
        sampleKohonenMenuItem.setText(resourceMap.getString("sampleKohonenMenuItem.text")); // NOI18N
        sampleKohonenMenuItem.setToolTipText(resourceMap.getString("sampleKohonenMenuItem.toolTipText")); // NOI18N
        sampleKohonenMenuItem.setName("sampleKohonenMenuItem"); // NOI18N
        samplesMenu.add(sampleKohonenMenuItem);

        sampleNFRMenuItem.setAction(actionMap.get("nfrSample")); // NOI18N
        sampleNFRMenuItem.setText(resourceMap.getString("sampleNFRMenuItem.text")); // NOI18N
        sampleNFRMenuItem.setToolTipText(resourceMap.getString("sampleNFRMenuItem.toolTipText")); // NOI18N
        sampleNFRMenuItem.setName("sampleNFRMenuItem"); // NOI18N
        samplesMenu.add(sampleNFRMenuItem);

        sampleRecommenderMenuItem.setAction(actionMap.get("recommenderSample")); // NOI18N
        sampleRecommenderMenuItem.setName("sampleRecommenderMenuItem"); // NOI18N
        samplesMenu.add(sampleRecommenderMenuItem);

        samplePerceptronMenuItem.setAction(actionMap.get("showPerceptronSample")); // NOI18N
        samplePerceptronMenuItem.setText(resourceMap.getString("samplePerceptronMenuItem.text")); // NOI18N
        samplePerceptronMenuItem.setName("samplePerceptronMenuItem"); // NOI18N
        samplesMenu.add(samplePerceptronMenuItem);

        sampleMLPerceptronMenuItem.setAction(actionMap.get("showMultiLayerPerceptronSample")); // NOI18N
        sampleMLPerceptronMenuItem.setText(resourceMap.getString("sampleMLPerceptronMenuItem.text")); // NOI18N
        sampleMLPerceptronMenuItem.setName("sampleMLPerceptronMenuItem"); // NOI18N
        samplesMenu.add(sampleMLPerceptronMenuItem);

        menuBar.add(samplesMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        jMenuItem7.setText(resourceMap.getString("jMenuItem7.text")); // NOI18N
        jMenuItem7.setName("jMenuItem7"); // NOI18N
        jMenuItem7.addActionListener((showHelpContents()));
        helpMenu.add(jMenuItem7);

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setToolTipText(resourceMap.getString("aboutMenuItem.toolTipText")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        statusPanel.setName("statusPanel"); // NOI18N

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        progressBar.setName("progressBar"); // NOI18N

        javax.swing.GroupLayout statusPanelLayout = new javax.swing.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(statusPanelSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 622, Short.MAX_VALUE)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(statusMessageLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 452, Short.MAX_VALUE)
                .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(statusAnimationLabel)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(statusPanelLayout.createSequentialGroup()
                .addComponent(statusPanelSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 2, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(statusPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(statusMessageLabel)
                    .addComponent(statusAnimationLabel)
                    .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(3, 3, 3))
        );

        treePopupMenu.setName("treePopupMenu"); // NOI18N

        renameMenuItem.setAction(actionMap.get("renameTreeNode")); // NOI18N
        renameMenuItem.setName("renameMenuItem"); // NOI18N
        treePopupMenu.add(renameMenuItem);

        removeMenuItem.setAction(actionMap.get("removeTreeNode")); // NOI18N
        removeMenuItem.setText(resourceMap.getString("removeMenuItem.text")); // NOI18N
        removeMenuItem.setName("removeMenuItem"); // NOI18N
        treePopupMenu.add(removeMenuItem);

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);
        setToolBar(jToolBar1);
    }// </editor-fold>//GEN-END:initComponents

//	public void addNewNetworkToProject(NeuralNetwork nnet) {
//		int count = easyNeuronsProject.getNeuralNetworks().size() + 1;
//        LabelsPlugin labels = (LabelsPlugin)nnet.getPlugin("LabelsPlugin");
//        if ((labels.getLabel(nnet) == null) || (labels.getLabel(nnet).equals("")))
//            labels.setLabel(nnet, "NewNetwork" + count);
//
//		this.addNetworkToProject(nnet);
//	}
//
//	private void addNetworkToProject(NeuralNetwork nnet) {
//		easyNeuronsProject.addNeuralNetwork(nnet);
//		updateProjectTree();
//		this.openNetworkViewFrame(nnet);
//	}
//
	public void updateProjectTree() {
		projectTree.setModel(easyNeuronsProject.getTreeModel());

		// fully expand tree
		int row = 0;
		while (row < projectTree.getRowCount()) {
			projectTree.expandRow(row);
			row++;
		}
	}

	public void updateFrameTitles() {
		JInternalFrame frames[] = desktopPanel.getAllFrames();
		for (int i = 0; i < frames.length; i++) {
			((NeuralNetworkViewFrame) frames[i]).updateTitle();
		}
	}

	private void treeNodeDoubleClick(int selRow, TreePath selPath) {

		Object[] nodes = selPath.getPath();
		Object selectedNode = ((DefaultMutableTreeNode) nodes[nodes.length - 1])
				.getUserObject();

		if (selectedNode instanceof NeuralNetwork) {
			NeuralNetwork nnet = (NeuralNetwork) selectedNode;
			this.openNetworkViewFrame(nnet);

		} else if (selectedNode instanceof TrainingSet) {
			TrainingSet trainingSet = (TrainingSet) selectedNode;
			this.openTrainingSetEditFrame(trainingSet);
		}

	}

	public void openNetworkViewFrame(NeuralNetwork nnet) {
		NeuralNetworkViewFrame networkViewFrame = new NeuralNetworkViewFrame(
				nnet, easyNeuronsProject.getTrainingSets());
						                   
		networkViewFrame.addInternalFrameListener(new WindowObserver(networkViewFrame) {
			@Override
			public void internalFrameActivated(InternalFrameEvent e) {
				netActiveWindow = nn;
				traActiveWindow = null;
			}
		});
	
		networkViewFrame.setVisible(true);

		desktopPanel.add(networkViewFrame);
		try {
			networkViewFrame.setSelected(true);
			networkViewFrame.setMaximum(true);
		} catch (java.beans.PropertyVetoException e) {
		}
	}



	private void openTrainingSetEditFrame(TrainingSet trainingSet) {
		TrainingSetEditFrame trainingSetEditFrame = new TrainingSetEditFrame(trainingSet);
		trainingSetEditFrame.setVisible(true);

		trainingSetEditFrame.addInternalFrameListener(new WindowObserver(
				trainingSet) {
			@Override
			public void internalFrameActivated(InternalFrameEvent e) {
				traActiveWindow = ts;
				netActiveWindow = null;
			}
		});

		desktopPanel.add(trainingSetEditFrame);
		try {
			trainingSetEditFrame.setSelected(true);
		} catch (java.beans.PropertyVetoException e) {
		}
	}

        public static EasyNeuronsApplicationView getInstance() {
            return myInstance;
        }

	public void openNeuronPropertiesFrame(Neuron neuron) {
		NeuronPropertiesFrame neuronPropertiesFrame = new NeuronPropertiesFrame(neuron);

		neuronPropertiesFrame.setVisible(true);

		desktopPanel.add(neuronPropertiesFrame);
		try {
			neuronPropertiesFrame.setSelected(true);
		} catch (java.beans.PropertyVetoException e) {
		}
	}

	private void showWizard(JDialog wizardDialog) {
		wizardDialog.setLocationRelativeTo(mainFrame);
		EasyNeuronsApplication.getApplication().show(wizardDialog);
	}

	@Action
	public void showOpenDialog() {
		fileChooser.resetChoosableFileFilters();
		fileChooser.addChoosableFileFilter(new FileFilterAdapter.NeuralNetworkBinaryFileFilter());
		fileChooser.addChoosableFileFilter(new FileFilterAdapter.NeuralNetworkXmlFileFilter());
		fileChooser.addChoosableFileFilter(new FileFilterAdapter.TrainingSetBinaryFileFilter());
		fileChooser.addChoosableFileFilter(new FileFilterAdapter.TrainingSetXmlFileFilter());
		int option = fileChooser.showOpenDialog(mainFrame);

		if (option == JFileChooser.CANCEL_OPTION) {
		}
		if (option == JFileChooser.APPROVE_OPTION) {
			File selectedFile = fileChooser.getSelectedFile();
			String fileExtension = FileUtils.getExtension(selectedFile);

			if (fileExtension != null) {
				if (FileUtils.isNeuralNetwork(fileExtension)) {
					String location = selectedFile.getPath();
					String fileName = selectedFile.getName();
					FileIO io = new FileIO();
					NeuralNetwork nnet = io.loadNeuralNetwork(location);

					ProjectManager.getInstance().addNetworkToProject(nnet);
                    
					fileObserver.put(location, fileName);
				}

				if (FileUtils.isTrainingSet(fileExtension)) {
					String location = selectedFile.getPath();
					String fileName = selectedFile.getName();
					fileObserver.put(location, fileName);
					FileIO io = new FileIO();
					TrainingSet trainingSet = io.loadTrainingSet(location);

					ProjectManager.getInstance().updateTrainingSets(trainingSet);
					this.openTrainingSetEditFrame(trainingSet);

					fileObserver.put(location, fileName);
				}
			} else {
			}
		} else {
		}
	}

	@Action
	public void showSaveDialog() {

		if (netActiveWindow != null) { // prvo proveravamo da li je aktivan
										// neural net prozor

			if (fileObserver.containsKey(netActiveWindow.getFilePath())) // ako jeste da li ga
																		 // ima u mapi
			{
				FileIO io = new FileIO();
				io.saveNeuralNetwork(netActiveWindow.getNeuralNetwork(), netActiveWindow.getNeuralNetwork().toString(), netActiveWindow.getFilePath());
			} else { // otvaranje prozora za Neural net posto ga nema u mapi
				fileChooser.resetChoosableFileFilters();
				fileChooser.addChoosableFileFilter(new FileFilterAdapter.NeuralNetworkBinaryFileFilter());
				fileChooser.addChoosableFileFilter(new FileFilterAdapter.NeuralNetworkXmlFileFilter());
				int option = fileChooser.showSaveDialog(mainFrame);
				if (option == JFileChooser.APPROVE_OPTION) {
					int count = fileChooser.getCurrentDirectory().toString().length();
					String name = fileChooser.getSelectedFile().toString().substring(count + 1);
					String location = fileChooser.getSelectedFile().toString()+fileChooser.getFileFilter().getDescription();
					FileIO io = new FileIO();
					io.saveNeuralNetwork(netActiveWindow.getNeuralNetwork(), name, location);
					fileObserver.put(location, name);
                                        showMessage("Neural network saved");
				}
				updateProjectTree();
				updateFrameTitles();
			}
		}

		if (traActiveWindow != null) { // proveravamo da li je training prozor
										// otvoren
			if (fileObserver.containsKey(traActiveWindow.getFilePath())) // ako
																			// jeste
																			// da
																			// li
																			// je
																			// u
																			// mapi
																			// promeni
			{
				FileIO io = new FileIO();
				io.saveTrainingSet(traActiveWindow, traActiveWindow.getLabel(),
						traActiveWindow.getFilePath());
			} else { // otvaranje prozora za Training posto ga nema u mapi
				fileChooser.resetChoosableFileFilters();
				fileChooser.addChoosableFileFilter(new FileFilterAdapter.TrainingSetBinaryFileFilter());
				fileChooser.addChoosableFileFilter(new FileFilterAdapter.TrainingSetXmlFileFilter());
				int option = fileChooser.showSaveDialog(mainFrame);

				if (option == JFileChooser.APPROVE_OPTION) {
					int count = fileChooser.getCurrentDirectory().toString().length();
					String name = fileChooser.getSelectedFile().toString().substring(count + 1);
					String location = fileChooser.getSelectedFile().toString();
					FileIO io = new FileIO();
					io.saveTrainingSet(traActiveWindow, name, location);
					fileObserver.put(location, name);
                                        showMessage("Training set saved");
				}
				updateProjectTree();
				updateFrameTitles();
			}
		}
	}

	@Action
	public void showSaveAsDialog() {
		if (netActiveWindow != null) {
			fileChooser.resetChoosableFileFilters();
			fileChooser.addChoosableFileFilter(new FileFilterAdapter.NeuralNetworkBinaryFileFilter());
			fileChooser.addChoosableFileFilter(new FileFilterAdapter.NeuralNetworkXmlFileFilter());
			int option = fileChooser.showSaveDialog(mainFrame);
			if (option == JFileChooser.APPROVE_OPTION) {
				int count = fileChooser.getCurrentDirectory().toString().length();
				String name = fileChooser.getSelectedFile().toString().substring(count + 1);
				String location = fileChooser.getSelectedFile().toString()+fileChooser.getFileFilter().getDescription();
				FileIO io = new FileIO();
				io.saveNeuralNetwork(netActiveWindow.getNeuralNetwork(), name, location);
				fileObserver.put(location, name);
                                showMessage("Neural network saved");
			}
			updateProjectTree();
			updateFrameTitles();
		}
		if (traActiveWindow != null) {
			fileChooser.resetChoosableFileFilters();
			fileChooser.addChoosableFileFilter(new FileFilterAdapter.TrainingSetBinaryFileFilter());
			fileChooser.addChoosableFileFilter(new FileFilterAdapter.TrainingSetXmlFileFilter());
			int option = fileChooser.showSaveDialog(mainFrame);
			if (option == JFileChooser.APPROVE_OPTION) {
				int count = fileChooser.getCurrentDirectory().toString().length();
				String name = fileChooser.getSelectedFile().toString().substring(count + 1);
				String location = fileChooser.getSelectedFile().toString();
				FileIO io = new FileIO();
				io.saveTrainingSet(traActiveWindow, name, location);
				fileObserver.put(location, name);
                                showMessage("Training set saved");
			}
			updateProjectTree();
			updateFrameTitles();
		}
	}

	@Action
	public void showAdalineWizard() {
		AdalineWizard wizard = new AdalineWizard(mainFrame, true);
		showWizard(wizard);
	}

	@Action
	public void showPerceptronWizard() {
		PerceptronWizard wizard = new PerceptronWizard(mainFrame, true);
		showWizard(wizard);
	}

	@Action
	public void showMLPerceptronWizard() {
		MultiLayerPerceptronWizard wizard = new MultiLayerPerceptronWizard(mainFrame, true);
		showWizard(wizard);
	}

	@Action
	public void showHopfieldWizard() {
		HopfieldWizard wizard = new HopfieldWizard(mainFrame, true);
		showWizard(wizard);
	}
	
	@Action
	public void showBAMWizard() {
		BamWizard wizard = new BamWizard(mainFrame, true);
		showWizard(wizard);		
	}	

	@Action
	public void showKohonenWizard() {
		KohonenWizard wizard = new KohonenWizard(mainFrame, true);
		showWizard(wizard);
	}

	@Action
	public void showHebbianWizard() {
		SupervisedHebbianWizard wizard = new SupervisedHebbianWizard(mainFrame, true);
		showWizard(wizard);
	}
	
	@Action
	public void showUnsupervisedHebbianWizard() {
		UnsupervisedHebbianWizard wizard = new UnsupervisedHebbianWizard(mainFrame, true);
		showWizard(wizard);		
	}	

	@Action
	public void showCompetitiveNetworkWizard() {
		CompetitiveNetworkWizard wizard = new CompetitiveNetworkWizard(mainFrame, true);
		showWizard(wizard);
	}

	@Action
	public void showMaxnetWizard() {
		MaxnetWizard wizard = new MaxnetWizard(mainFrame, true);
		showWizard(wizard);
	}
	
	@Action
	public void showInstarWizard() {
		InstarWizard wizard = new InstarWizard(mainFrame, true);
		showWizard(wizard);		
	}	
	
	@Action
	public void showOutstarWizard() {
		OutstarWizard wizard = new OutstarWizard(mainFrame, true);
		showWizard(wizard);		
	}	

	@Action
	public void showRbfWizard() {
		RbfWizard wizard = new RbfWizard(mainFrame, true);
		showWizard(wizard);
	}

	@Action
	public void showTrainingSetWizard() {
		TrainingSetWizard wizard = new TrainingSetWizard(mainFrame, true);
		showWizard(wizard);
	}

	public void newAdalineNetwork(int inputNeurons) {
		Adaline nnet = NeuralNetworkFactory.createAdaline(inputNeurons);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
	}

	public void newPerceptronNetwork(int inputNeurons, int outputNeurons,
			TransferFunctionType transferFunction, Class learningRule) {
		Perceptron nnet = NeuralNetworkFactory.createPerceptron(inputNeurons,
				outputNeurons, transferFunction, learningRule);
  		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new Perceptron Network");
	}
	
	public void newInstarNetwork(int inputNeuronsNum) {
		Instar nnet = NeuralNetworkFactory.createInstar(inputNeuronsNum);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new Instar Network");
	}	
	
	public void newOutstarNetwork(int outputNeuronsNum) {
		Outstar nnet = NeuralNetworkFactory.createOutstar(outputNeuronsNum);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new Outstar Network");
	}		

	public void newMaxnetNetwork(int neuronsNum) {
		MaxNet nnet = NeuralNetworkFactory.createMaxNet(neuronsNum);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new Maxnet Network");
	}

	public void newCompetitiveNetwork(int inputNeuronsNum, int outputNeuronsNum) {
		CompetitiveNetwork nnet = NeuralNetworkFactory
				.createCompetitiveNetwork(inputNeuronsNum, outputNeuronsNum);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new Competitive Network");
	}

	public void newMLPerceptronNetwork(String neuronsNum,
			TransferFunctionType transferFunctionType) {
		MultiLayerPerceptron nnet = NeuralNetworkFactory.createMLPerceptron(
				neuronsNum, transferFunctionType);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new Multi Layer Perceptron Network");
	}

 	public void newMLPerceptronNetwork(String neuronsNum,
			TransferFunctionType transferFunctionType, Class learningRule, boolean useBias, boolean connectI2O) {
		MultiLayerPerceptron nnet = NeuralNetworkFactory.createMLPerceptron(
				neuronsNum, transferFunctionType, learningRule, useBias, connectI2O);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                 showMessage("Created new Multi Layer Perceptron Network");
	}

	public void newHopfieldNetwork(int inputNeurons) {
		Hopfield nnet = NeuralNetworkFactory.createHopfield(inputNeurons);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                 showMessage("Created new Hopfield Network");
	}

	public void newBamNetwork(int inputNeurons, int outputNeurons) {
		BAM nnet = NeuralNetworkFactory.createBam(inputNeurons, outputNeurons);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new BAM Network");
	}
	
	public void newKohonenNetwork(int inputNeurons, int mapNeurons) {
		Kohonen nnet = NeuralNetworkFactory.createKohonen(inputNeurons,
				mapNeurons);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new Kohonen Network");
	}

	public void newHebbianNetwork(int inputNeurons, int outputNeurons,
			TransferFunctionType transferFunction) {
		SupervisedHebbianNetwork nnet = NeuralNetworkFactory.createSupervisedHebbian(inputNeurons,
				outputNeurons, transferFunction);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new Supervised Hebbian Network");
	}
	
	public void newUnsupervisedHebbianNetwork(int inputNeurons, int outputNeurons,
			TransferFunctionType transferFunction) {
		UnsupervisedHebbianNetwork nnet = NeuralNetworkFactory.createUnsupervisedHebbian(inputNeurons,
				outputNeurons, transferFunction);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new Unsupervised Hopfield Network");
	}	
	
	

	public void newRbfNetwork(int inputNeuronsNum, int rbfNeuronsNum,
			int outputNeuronsNum) {
		RbfNetwork nnet = NeuralNetworkFactory.createRbfNetwork(
				inputNeuronsNum, rbfNeuronsNum, outputNeuronsNum);
		ProjectManager.getInstance().addNewNetworkToProject(nnet);
                showMessage("Created new RBF Network");
	}

	public void showTrainingSetEditFrame(int inputs, int outputs, String type, String label) {

		TrainingSet trainingSet = new TrainingSet(label);
		TrainingSetEditFrame trainingSetEditFrame = new TrainingSetEditFrame(trainingSet, type, inputs, outputs);
		trainingSetEditFrame.setVisible(true);

		desktopPanel.add(trainingSetEditFrame);
		try {
			trainingSetEditFrame.setSelected(true);
		} catch (java.beans.PropertyVetoException e) {
		}
	}

        public SupervisedTrainingMonitorFrame openMonitorFrame(NeuralNetworkTraining trainingController) {
            SupervisedTrainingMonitorFrame monitorFrame = new SupervisedTrainingMonitorFrame(trainingController);

            monitorFrame.setVisible(true);
                desktopPanel.add(monitorFrame);
            try {
               monitorFrame.setSelected(true);
            } catch (java.beans.PropertyVetoException e) {
            }

            return monitorFrame;
            
        }

        public GraphFrame openErrorGraphFrame() {
            // pre otvaranja graph frama proveri da li vec postoji jedan otvoren, je ce u njemu da crta
            JInternalFrame iframes[]  = desktopPanel.getAllFrames();
            for(int i=0; i<iframes.length; i++) {
                if (iframes[i] instanceof GraphFrame) {

                   try {
                    iframes[i].setSelected(true);
                    } catch (java.beans.PropertyVetoException e) {
                    }

                    return (GraphFrame)iframes[i];
                }
            }

            GraphFrame graphFrame = new GraphFrame();

            graphFrame.setVisible(true);
            desktopPanel.add(graphFrame);
            try {
              graphFrame.setSelected(true);
            } catch (java.beans.PropertyVetoException e) {
            }

            return graphFrame;
        }



	@Action
	public void trainNetwork() {
		JInternalFrame selectedFrame = desktopPanel.getSelectedFrame();
		if (selectedFrame != null) {
			if (selectedFrame instanceof NeuralNetworkViewFrame) {
				((NeuralNetworkViewFrame) selectedFrame).train();
			}
		}
	}

	@Action
	public void removeTreeNode() {
		Object[] nodes = projectTree.getSelectionPath().getPath();
		Object selectedNode = ((DefaultMutableTreeNode) nodes[nodes.length - 1])
				.getUserObject();

		if (selectedNode instanceof NeuralNetwork) {
			NeuralNetwork nnet = (NeuralNetwork) selectedNode;
			easyNeuronsProject.removeNeuralNetwork(nnet);
			this.updateProjectTree();

		} else if (selectedNode instanceof TrainingSet) {
			TrainingSet trainingSet = (TrainingSet) selectedNode;
			easyNeuronsProject.removeTrainingSet(trainingSet);
			this.updateProjectTree();
		}
	}

	@Action
	public void kohonenSample() {
		int sampleSize = 100;
		NeuralNetwork neuralNet = new Kohonen(new Integer(2), new Integer(sampleSize));
	
		((LabelsPlugin)neuralNet.getPlugin("LabelsPlugin")).setLabel(neuralNet, "Kohonen sample");
		easyNeuronsProject.addNeuralNetwork(neuralNet);

		TrainingSet trainingSet = new TrainingSet();
		trainingSet.setLabel("Sample training set");

		for (int i = 0; i < sampleSize; i++) {
			Vector<Double> trainVect = new Vector<Double>();
			trainVect.add(Math.random());
			trainVect.add(Math.random());
			TrainingElement te = new TrainingElement(trainVect);
			trainingSet.addElement(te);
		}

		easyNeuronsProject.addTrainingSet(trainingSet);

		updateProjectTree();

		NeuralNetworkTraining controller = new NeuralNetworkTraining(neuralNet, trainingSet);

		KohonenSample kohonenVisualizer = new KohonenSample(
				controller);
		neuralNet.getLearningRule().addObserver(kohonenVisualizer);
		neuralNet.addObserver(kohonenVisualizer);

		kohonenVisualizer.setVisible(true);
		desktopPanel.add(kohonenVisualizer);
		try {
			kohonenVisualizer.setSelected(true);
		} catch (java.beans.PropertyVetoException e) {
		}

                showMessage("Created Kohonen Sample");
	}

	@Action
	public void nfrSample() {
		double[][] pointsSets = { { 0, 0, 20, 22 }, // bad
				{ 20, 22, 40, 42 }, // good
				{ 40, 42, 80, 82 }, // very good
				{ 80, 82, 100, 100 } }; // excellent

		double[][] timeSets = { { 15, 15, 20, 25 }, // fast
				{ 20, 25, 35, 40 }, // moderate
				{ 35, 40, 1000, 1000 } }; // slow

		NeuralNetwork nnet = new NeuroFuzzyPerceptron(pointsSets, timeSets);
		TrainingSet tSet = new TrainingSet();

		Layer setLayer = nnet.getLayerAt(1);

		int outClass = 0;

		for (int i = 0; i <= 3; i++) { // iterate points sets
			Neuron icell = setLayer.getNeuronAt(i);
			Trapezoid tfi = (Trapezoid) icell.getTransferFunction();
			double r1i = tfi.getRightLow();
			double l2i = tfi.getLeftHigh();
			double r2i = tfi.getRightHigh();
			double right_intersection_i = r2i + (r1i - r2i) / 2;

			for (int j = 6; j >= 4; j--) { // iterate speed sets
				Neuron jcell = setLayer.getNeuronAt(j);
				Trapezoid tfj = (Trapezoid) jcell.getTransferFunction();

				double r1j = tfj.getRightLow();
				double l2j = tfj.getLeftHigh();
				double r2j = tfj.getRightHigh();
				double right_intersection_j = r2j + (r1j - r2j) / 2;

				String outputPattern;
				if (outClass <= 3) {
					outputPattern = "1 0 0 0";
				} else if ((outClass >= 4) && (outClass <= 6)) {
					outputPattern = "0 1 0 0";
				} else if ((outClass >= 7) && (outClass <= 9)) {
					outputPattern = "0 0 1 0";
				} else {
					outputPattern = "0 0 0 1";
				}

				String inputPattern = Double.toString(l2i) + " "
						+ Double.toString(l2j);
				SupervisedTrainingElement tEl = new SupervisedTrainingElement(
						inputPattern, outputPattern);
				tSet.addElement(tEl);

				inputPattern = Double.toString(l2i) + " "
						+ Double.toString(r2j);
				tEl = new SupervisedTrainingElement(inputPattern, outputPattern);
				tSet.addElement(tEl);

				inputPattern = Double.toString(l2i) + " "
						+ Double.toString(right_intersection_j);
				tEl = new SupervisedTrainingElement(inputPattern, outputPattern);
				tSet.addElement(tEl);

				inputPattern = Double.toString(r2i) + " "
						+ Double.toString(l2j);
				tEl = new SupervisedTrainingElement(inputPattern, outputPattern);
				tSet.addElement(tEl);

				inputPattern = Double.toString(r2i) + " "
						+ Double.toString(r2j);
				tEl = new SupervisedTrainingElement(inputPattern, outputPattern);
				tSet.addElement(tEl);

				inputPattern = Double.toString(r2i) + " "
						+ Double.toString(right_intersection_j);
				tEl = new SupervisedTrainingElement(inputPattern, outputPattern);
				tSet.addElement(tEl);

				inputPattern = Double.toString(right_intersection_i) + " "
						+ Double.toString(l2j);
				tEl = new SupervisedTrainingElement(inputPattern, outputPattern);
				tSet.addElement(tEl);

				inputPattern = Double.toString(right_intersection_i) + " "
						+ Double.toString(r2j);
				tEl = new SupervisedTrainingElement(inputPattern, outputPattern);
				tSet.addElement(tEl);

				inputPattern = Double.toString(right_intersection_i) + " "
						+ Double.toString(right_intersection_j);
				tEl = new SupervisedTrainingElement(inputPattern, outputPattern);
				tSet.addElement(tEl);

				outClass++;
			} // for j

		} // for i

		// this.setProject(new SmartNetProject(nnet, tSet));
		((LabelsPlugin)nnet.getPlugin("LabelsPlugin")).setLabel(nnet, "NFR sample");
		tSet.setLabel("NFR tset");
		easyNeuronsProject.addNeuralNetwork(nnet);
		easyNeuronsProject.addTrainingSet(tSet);

		updateProjectTree();

		NeuralNetworkTraining controller = new NeuralNetworkTraining(nnet, tSet);

		
		NFRSample frame = new NFRSample(controller);

		frame.setVisible(true);
		desktopPanel.add(frame);
		try {
			frame.setSelected(true);
		} catch (java.beans.PropertyVetoException e) {
		}		
		

	}

	@Action
	public void showAboutBox() {
		if (aboutBox == null) {
			aboutBox = new AboutBox(mainFrame);
			aboutBox.setLocationRelativeTo(mainFrame);
		}
		EasyNeuronsApplication.getApplication().show(aboutBox);
	}

	@Action
	public void renameTreeNode() {
		Object[] nodes = projectTree.getSelectionPath().getPath();
		Object selectedNode = ((DefaultMutableTreeNode) nodes[nodes.length - 1])
				.getUserObject();

		RenameNodeDialog dialog = new RenameNodeDialog(mainFrame, true, selectedNode);
		dialog.setLocationRelativeTo(mainFrame);
		EasyNeuronsApplication.getApplication().show(dialog);

	}

	public void treeNodesChanged(TreeModelEvent e) {
		Object[] nodes = projectTree.getSelectionPath().getPath();
		Object selectedNode = ((DefaultMutableTreeNode) nodes[nodes.length - 1])
				.getUserObject();

		/*
		 * TreePath selectedPath = projectTree.getSelectionPath() ; if (
		 * selectedPath == null ) return ;
		 * 
		 * Object selectedNode = selectedPath.getLastPathComponent() ;
		 */
		String newLabel = selectedNode.toString();

		if (selectedNode instanceof NeuralNetwork) {
			NeuralNetwork nnet = (NeuralNetwork) selectedNode;
			
			((LabelsPlugin)nnet.getPlugin("LabelsPlugin") ).setLabel(nnet, newLabel);
			// this.updateProjectTree();

		} else if (selectedNode instanceof TrainingSet) {
			TrainingSet trainingSet = (TrainingSet) selectedNode;
			trainingSet.setLabel(newLabel);
			// this.updateProjectTree();
		}

	}

	public JTree getProjectTree() {
		return this.projectTree;
	}

	@Action
	public void switchToGraphView() {
		JInternalFrame iframe = desktopPanel.getSelectedFrame();

		if (iframe instanceof NeuralNetworkViewFrame) {
			((NeuralNetworkViewFrame) iframe)
					.switchToView(NeuralNetworkViewFrame.GRAPH_VIEW);
		}
	}

	@Action
	public void switchToBlockView() {
		JInternalFrame iframe = desktopPanel.getSelectedFrame();

		if (iframe instanceof NeuralNetworkViewFrame) {
			((NeuralNetworkViewFrame) iframe)
					.switchToView(NeuralNetworkViewFrame.BLOCK_VIEW);
		}
	}
	
	@Action
	public void refreshView() {
		JInternalFrame iframe = desktopPanel.getSelectedFrame();

		if (iframe instanceof NeuralNetworkViewFrame) {
			((NeuralNetworkViewFrame) iframe).refresh();
		}		
	}

        public void showMessage(String message) {
            messageBox.append(message + "\r\n");
        }

	@Action
	public void showBasicNeuronSample() {
		BasicNeuronSample sample = new BasicNeuronSample();

		sample.setVisible(true);
		desktopPanel.add(sample);
		try {
			sample.setSelected(true);
		} catch (java.beans.PropertyVetoException e) {
		}

                showMessage("Started Basic Neuron Sample");
	}

    public ActionListener showHelpContents() {
		String path = "org/neuroph/easyneurons/help/EasyNeurons.hs";
		ClassLoader loader = this.getClass().getClassLoader();

		HelpSet hs = null;

		try {
			URL hsURL = HelpSet.findHelpSet(loader, path);
			hs = new HelpSet(loader, hsURL);
		} catch (Exception ee) {
			ee.printStackTrace();
		}

		HelpBroker hb = hs.createHelpBroker();

		return new CSH.DisplayHelpFromSource(hb);

    }

	@Action
	public void recommenderSample() {
		NeuralNetwork nnet = new org.neuroph.contrib.RecommenderNetwork();
        ((org.neuroph.contrib.RecommenderNetwork)nnet).createDemoNetwork();
		TrainingSet tSet = new TrainingSet();
	
		((LabelsPlugin)nnet.getPlugin("LabelsPlugin")).setLabel(nnet, "Recommender sample");
		tSet.setLabel("E-commerce tset");
		easyNeuronsProject.addNeuralNetwork(nnet);
		easyNeuronsProject.addTrainingSet(tSet);

		updateProjectTree();

		NeuralNetworkTraining controller = new NeuralNetworkTraining(nnet, tSet);
	}

    @Action
    public void imageRecognitionSample() {
		org.neuroph.easyneurons.imgrec.ImageRecognitionFrame sample = new org.neuroph.easyneurons.imgrec.ImageRecognitionFrame();
		sample.setVisible(true);
		desktopPanel.add(sample);
		try {
			sample.setSelected(true);
		} catch (java.beans.PropertyVetoException e) {
		}

    }

    public EasyNeuronsProject getProject() {
        return this.easyNeuronsProject;
    }

    @Action
    public void showPerceptronSample() {
           NeuralNetwork neuralNet = new Perceptron(new Integer(2), new Integer(1));
           neuralNet.setLearningRule(new BinaryDeltaRule());
           ((LabelsPlugin)neuralNet.getPlugin("LabelsPlugin")).setLabel(neuralNet, "PerceptronSampleNetwork");
           easyNeuronsProject.addNeuralNetwork(neuralNet);

            org.neuroph.easyneurons.samples.perceptron.TrainingSetObserver trainingSet = new org.neuroph.easyneurons.samples.perceptron.TrainingSetObserver(){

                       @Override
                       public void update(Observable o, Object arg) {
                       TrainingSet t = new TrainingSet();
                       easyNeuronsProject.removeTrainingSet(getTrainingSet());
                      // System.out.println(" update je obavljen...");// ((TrainingSet)this).toString();
                       super.update(o, arg);
                       t = getTrainingSet();
                       t.setLabel("Perceptron Sample Training Set");
                       easyNeuronsProject.addTrainingSet(t);
                       updateProjectTree();
                       }
            };
            org.neuroph.easyneurons.samples.perceptron.PerceptronSampleTrainingSet pst = new PerceptronSampleTrainingSet();
            pst.addObserver(trainingSet);

            TrainingSet ts = trainingSet.getTrainingSet();

            NeuralNetworkTraining nnTraining = new NeuralNetworkTraining(neuralNet, ts);

            org.neuroph.easyneurons.samples.perceptron.PerceptronSampleFrame perceptronVisualizer = new org.neuroph.easyneurons.samples.perceptron.PerceptronSampleFrame(nnTraining, pst);
	    neuralNet.getLearningRule().addObserver(perceptronVisualizer);
	    neuralNet.addObserver(perceptronVisualizer);

            perceptronVisualizer.setVisible(true);
            desktopPanel.add(perceptronVisualizer);

            try {
        	perceptronVisualizer.setSelected(true);
            } catch (java.beans.PropertyVetoException e) {   }

            showMessage("Started Perceptron Sample");
    }

    @Action
    public void showMultiLayerPerceptronSample() {
          org.neuroph.easyneurons.samples.mlperceptron.NeuralNetObserver markovNeuralNet = new org.neuroph.easyneurons.samples.mlperceptron.NeuralNetObserver()
            {
                      @Override
                       public void update(Observable o, Object arg) {
                          NeuralNetwork net = getNnet();
                          easyNeuronsProject.removeNeuralNetwork(net);

                          super.update(o, arg);
                          net = getNnet();
                          if(net == null){updateProjectTree();}
                          else{
                            ((LabelsPlugin)net.getPlugin("LabelsPlugin")).setLabel(net, "MultiLayerPerceptron Sample");
                            ProjectManager.getInstance().addNewNetworkToProject(net);
                           }
                      }
            };

            org.neuroph.easyneurons.samples.perceptron.TrainingSetObserver trainingSet = new org.neuroph.easyneurons.samples.perceptron.TrainingSetObserver(){

                       @Override
                       public void update(Observable o, Object arg) {
                           TrainingSet t = getTrainingSet();
                           easyNeuronsProject.removeTrainingSet(t);
                           super.update(o, arg);
                           t = getTrainingSet();
                           if(t.isEmpty()){updateProjectTree();}
                           else{
                           t.setLabel("Backpropagation Sample Training Set");
                           easyNeuronsProject.addTrainingSet(t);
                           updateProjectTree();
                           }
                       }
            };

            org.neuroph.easyneurons.samples.perceptron.PerceptronSampleTrainingSet pst = new PerceptronSampleTrainingSet();
            pst.addObserver(trainingSet);
            pst.addObserver(markovNeuralNet);

            NeuralNetwork nnet = markovNeuralNet.getNnet();
            nnet.setLearningRule(new BackPropagation());       //ovo je moralo da se stavi...

            TrainingSet ts = trainingSet.getTrainingSet();

            org.neuroph.easyneurons.samples.mlperceptron.MultiLayerPerceptronSample backpropagationVisualizer = new org.neuroph.easyneurons.samples.mlperceptron.MultiLayerPerceptronSample(pst);

            backpropagationVisualizer.setVisible(true);
            desktopPanel.add(backpropagationVisualizer);

            try {
		backpropagationVisualizer.setSelected(true);
            } catch (java.beans.PropertyVetoException e) {  }

              showMessage("Started Multi Layer Perceptron with Backpropagation Sample");

    }

    @Action
    public void handwritingRecogn() {
            HandwritingRecognitionToolFrame hwFrame = new HandwritingRecognitionToolFrame(null, true, true, true, true);
            desktopPanel.add(hwFrame);
            hwFrame.setVisible(true);
            try {
                hwFrame.setMaximum(true);
            } catch (PropertyVetoException ex) {
            }
    }

    @Action
    public void characterRecognitionTool() {
            TextRecognitionFrame tcrFrame = new TextRecognitionFrame();
            tcrFrame.setVisible(true);
            desktopPanel.add(tcrFrame);
        try {
            tcrFrame.setSelected(true);
        //    tcr.setDesktop(desktopPanel);
        } catch (PropertyVetoException ex) {
            Logger.getLogger(EasyNeuronsApplicationView.class.getName()).log(Level.SEVERE, null, ex);
        }

    }



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem adalineMenuItem;
    private javax.swing.JMenuItem bamMenuItem;
    private javax.swing.JMenuItem competitiveMenuItem;
    private javax.swing.JDesktopPane desktopPanel;
    private javax.swing.JMenu editMenu;
    private javax.swing.JMenuItem handwritingRecognitionMenuItem;
    private javax.swing.JMenuItem hopfieldMenuItem;
    private javax.swing.JMenuItem imageRecognitionMenuItem;
    private javax.swing.JMenuItem instarMenuItem;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JMenuItem jMenuItem4;
    private javax.swing.JMenuItem jMenuItem6;
    private javax.swing.JMenuItem jMenuItem7;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JMenuItem kohonenMenuItem;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuItem maxnetMenuItem;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JTextArea messageBox;
    private javax.swing.JMenuItem mlpMenuItem;
    private javax.swing.JMenu networksMenu;
    private javax.swing.JButton newTrainingSetButton;
    private javax.swing.JButton openButton;
    private javax.swing.JMenuItem openMenuItem;
    private javax.swing.JMenuItem outstarMenuItem;
    private javax.swing.JMenuItem perceptronMenuItem;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JTree projectTree;
    private javax.swing.JScrollPane projectTreeScrollPane;
    private javax.swing.JMenuItem rbfMenuItem;
    private javax.swing.JMenuItem removeMenuItem;
    private javax.swing.JMenuItem renameMenuItem;
    private javax.swing.JMenuItem sampleBasicNeuron;
    private javax.swing.JMenuItem sampleKohonenMenuItem;
    private javax.swing.JMenuItem sampleMLPerceptronMenuItem;
    private javax.swing.JMenuItem sampleNFRMenuItem;
    private javax.swing.JMenuItem samplePerceptronMenuItem;
    private javax.swing.JMenuItem sampleRecommenderMenuItem;
    private javax.swing.JMenu samplesMenu;
    private javax.swing.JMenuItem saveAsMenuItem;
    private javax.swing.JButton saveButton;
    private javax.swing.JMenuItem saveMenuItem;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    private javax.swing.JMenuItem supervisedHebbianMenuItem;
    private javax.swing.JMenuItem textRecognitionMenuItem;
    private javax.swing.JMenu toolsMenu;
    private javax.swing.JMenuItem trainMenuItem;
    private javax.swing.JMenu trainingMenu;
    private javax.swing.JMenuItem trainingSetWizardMenuItem;
    private javax.swing.JPopupMenu treePopupMenu;
    private javax.swing.JMenuItem unsupervisedHebbianMenuItem;
    private javax.swing.JMenuItem viewBlockMenuItem;
    private javax.swing.JMenuItem viewGraphMenuItem;
    private javax.swing.JMenu viewMenu;
    private javax.swing.JMenuItem viewRefreshMenuItem;
    // End of variables declaration//GEN-END:variables

	private final Timer messageTimer;
	private final Timer busyIconTimer;
	private final Icon idleIcon;
	private final Icon[] busyIcons = new Icon[15];
	private int busyIconIndex = 0;

	private JDialog aboutBox;

// DragNDrop - start
       //DnD Listeneri i TreeSelectionListener

        class TSListener implements TreeSelectionListener
        {

              public void valueChanged(TreeSelectionEvent e) {
                   TreePath SelectedTreePath = e.getNewLeadSelectionPath();

                    if (SelectedTreePath == null) {
                      SelectedNode = null;
                      return;
                    }
                    SelectedNode = (DefaultMutableTreeNode) SelectedTreePath.getLastPathComponent();
                    }
         }





        class DGListener implements DragGestureListener
        {

                public void dragGestureRecognized(DragGestureEvent e) {


                    if((e.getDragAction() & EasyNeuronsApplicationView.this.dragAction) == 0)
                    return;

                    DefaultMutableTreeNode dragNode = getSelectedNode();
                    if (dragNode != null){
                    Transferable transferable = new TransferableObject( dragNode.getUserObject() );

                           try {
                            // initial cursor, transferrable, dsource listener
                               e.startDrag(DragSource.DefaultCopyDrop,//DefaultCopyNoDrop,
                                  transferable, //dsListener
                                  EasyNeuronsApplicationView.this.dsListener);

                              }catch( InvalidDnDOperationException idoe ) {
                                      System.out.println("Juhu");
                                      System.err.println( idoe );
                          }
                }
             }
        }

        class DSListener implements DragSourceListener
        {

                    public void dragDropEnd(DragSourceDropEvent e) {
                         if( e.getDropSuccess() == false ) {
                           System.out.println( "not successful");
                         return;
                    }
                    }

                    public void dragEnter(DragSourceDragEvent e) {
                           DragSourceContext context = e.getDragSourceContext();
                          //intersection of the users selected action, and the source and target actions
                          int myaction = e.getDropAction();
                          if( (myaction & EasyNeuronsApplicationView.this.dragAction) != 0) {
                            context.setCursor(DragSource.DefaultCopyDrop);
                          } else {
                            context.setCursor(DragSource.DefaultCopyNoDrop);
                          }
                    }

                    public void dragExit(DragSourceEvent dse) {
                        //throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void dragOver(DragSourceDragEvent dsde) {
                        //throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void dropActionChanged(DragSourceDragEvent dsde) {
                       // throw new UnsupportedOperationException("Not supported yet.");
                    }

          }

          public DefaultMutableTreeNode getSelectedNode() {
                return SelectedNode;
          }



          private DragSource dragSource;
          private DragGestureListener dgListener;
          private DragSourceListener dsListener;
          private TreeSelectionListener tsListener;
          private int dragAction = DnDConstants.ACTION_COPY;
          protected DefaultMutableTreeNode SelectedNode;// = null;
// DragNDrop - end
}
