/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedKAryTree<V, E>
extends AbstractTypedGraph<V, E>
implements Tree<V, E> {
    protected Map<E, Pair<V>> edge_vpairs;
    protected Map<V, VertexData> vertex_data;
    protected int height;
    protected V root;
    protected int order;

    public static <V, E> Factory<DirectedGraph<V, E>> getFactory(final int order) {
        return new Factory<DirectedGraph<V, E>>(){

            @Override
            public DirectedGraph<V, E> create() {
                return new OrderedKAryTree(order);
            }
        };
    }

    public OrderedKAryTree(int order) {
        super(EdgeType.DIRECTED);
        this.order = order;
        this.height = -1;
        this.edge_vpairs = new HashMap<E, Pair<V>>();
        this.vertex_data = new HashMap<V, VertexData>();
    }

    @Override
    public int getChildCount(V vertex) {
        if (!this.containsVertex(vertex)) {
            return 0;
        }
        E[] edges = this.vertex_data.get(vertex).child_edges;
        if (edges == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < edges.length; ++i) {
            count += edges[i] == null ? 0 : 1;
        }
        return count;
    }

    public E getChildEdge(V vertex, int index) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        E[] edges = this.vertex_data.get(vertex).child_edges;
        if (edges == null) {
            return null;
        }
        return edges[index];
    }

    @Override
    public Collection<E> getChildEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        E[] edge_array = this.vertex_data.get(vertex).child_edges;
        if (edge_array == null) {
            return Collections.emptySet();
        }
        ArrayList edges = new ArrayList(this.order);
        for (int i = 0; i < edge_array.length; ++i) {
            if (edge_array[i] == null) continue;
            edges.add(edge_array[i]);
        }
        return CollectionUtils.unmodifiableCollection(edges);
    }

    @Override
    public Collection<V> getChildren(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        E[] edges = this.vertex_data.get(vertex).child_edges;
        if (edges == null) {
            return Collections.emptySet();
        }
        ArrayList<V> children = new ArrayList<V>(this.order);
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i] == null) continue;
            children.add(this.getOpposite(vertex, edges[i]));
        }
        return CollectionUtils.unmodifiableCollection(children);
    }

    @Override
    public int getDepth(V vertex) {
        if (!this.containsVertex(vertex)) {
            return -1;
        }
        return this.vertex_data.get(vertex).depth;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public V getParent(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        if (vertex.equals(this.root)) {
            return null;
        }
        return this.edge_vpairs.get(this.vertex_data.get(vertex).parent_edge).getFirst();
    }

    @Override
    public E getParentEdge(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return this.vertex_data.get(vertex).parent_edge;
    }

    @Override
    public V getRoot() {
        return this.root;
    }

    @Override
    public Collection<Tree<V, E>> getTrees() {
        ArrayList<Tree<V, OrderedKAryTree>> forest = new ArrayList<Tree<V, OrderedKAryTree>>(1);
        forest.add(this);
        return forest;
    }

    public boolean addEdge(E e, V parent, V child, int index) {
        if (e == null || child == null || parent == null) {
            throw new IllegalArgumentException("Inputs may not be null");
        }
        if (!this.containsVertex(parent)) {
            throw new IllegalArgumentException("Tree must already include parent: " + parent);
        }
        if (this.containsVertex(child)) {
            throw new IllegalArgumentException("Tree must not already include child: " + child);
        }
        if (parent.equals(child)) {
            throw new IllegalArgumentException("Input vertices must be distinct");
        }
        if (index >= this.order) {
            throw new IllegalArgumentException("'index' must be < the order of this tree");
        }
        Pair<V> endpoints = new Pair<V>(parent, child);
        if (this.containsEdge(e)) {
            if (!endpoints.equals(this.edge_vpairs.get(e))) {
                throw new IllegalArgumentException("Tree already includes edge" + e + " with different endpoints " + this.edge_vpairs.get(e));
            }
            return false;
        }
        VertexData parent_data = this.vertex_data.get(parent);
        Object[] outedges = parent_data.child_edges;
        if (outedges == null) {
            Class<?> type = e.getClass().getComponentType();
            parent_data.child_edges = outedges = (Object[])Array.newInstance(type, this.order);
        }
        boolean edge_placed = false;
        if (index >= 0) {
            if (outedges[index] != null) {
                throw new IllegalArgumentException("Parent " + parent + " already has a child at index " + index + " in this tree");
            }
            outedges[index] = e;
        }
        for (int i = 0; i < outedges.length; ++i) {
            if (outedges[i] != null) continue;
            outedges[i] = e;
            edge_placed = true;
            break;
        }
        if (!edge_placed) {
            throw new IllegalArgumentException("Parent " + parent + " already" + " has " + this.order + " children in this tree");
        }
        VertexData child_data = new VertexData(e, parent_data.depth + 1);
        this.vertex_data.put((VertexData)child, child_data);
        this.height = child_data.depth > this.height ? child_data.depth : this.height;
        this.edge_vpairs.put(e, endpoints);
        return true;
    }

    @Override
    public boolean addEdge(E e, V parent, V child) {
        return this.addEdge(e, parent, child, -1);
    }

    @Override
    public boolean addEdge(E e, V v1, V v2, EdgeType edge_type) {
        this.validateEdgeType(edge_type);
        return this.addEdge(e, v1, v2);
    }

    @Override
    public V getDest(E directed_edge) {
        if (!this.containsEdge(directed_edge)) {
            return null;
        }
        return this.edge_vpairs.get(directed_edge).getSecond();
    }

    @Override
    public Pair<V> getEndpoints(E edge) {
        if (!this.containsEdge(edge)) {
            return null;
        }
        return this.edge_vpairs.get(edge);
    }

    @Override
    public Collection<E> getInEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        if (vertex.equals(this.root)) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.getParentEdge(vertex));
    }

    @Override
    public V getOpposite(V vertex, E edge) {
        if (!this.containsVertex(vertex) || !this.containsEdge(edge)) {
            return null;
        }
        Pair<V> endpoints = this.edge_vpairs.get(edge);
        V v1 = endpoints.getFirst();
        V v2 = endpoints.getSecond();
        return v1.equals(vertex) ? v2 : v1;
    }

    @Override
    public Collection<E> getOutEdges(V vertex) {
        return this.getChildEdges(vertex);
    }

    @Override
    public int getPredecessorCount(V vertex) {
        if (!this.containsVertex(vertex)) {
            return -1;
        }
        return vertex.equals(this.root) ? 0 : 1;
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        if (vertex.equals(this.root)) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.getParent(vertex));
    }

    @Override
    public V getSource(E directed_edge) {
        if (!this.containsEdge(directed_edge)) {
            return null;
        }
        return this.edge_vpairs.get(directed_edge).getSecond();
    }

    @Override
    public int getSuccessorCount(V vertex) {
        return this.getChildCount(vertex);
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        return this.getChildren(vertex);
    }

    @Override
    public int inDegree(V vertex) {
        if (!this.containsVertex(vertex)) {
            return 0;
        }
        if (vertex.equals(this.root)) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isDest(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return this.edge_vpairs.get(edge).getSecond().equals(vertex);
    }

    public boolean isLeaf(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        return this.outDegree(vertex) == 0;
    }

    @Override
    public boolean isPredecessor(V v1, V v2) {
        if (!this.containsVertex(v2)) {
            return false;
        }
        return this.getParent(v2).equals(v1);
    }

    public boolean isRoot(V vertex) {
        if (this.root == null) {
            return false;
        }
        return this.root.equals(vertex);
    }

    @Override
    public boolean isSource(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return this.edge_vpairs.get(edge).getFirst().equals(vertex);
    }

    @Override
    public boolean isSuccessor(V v1, V v2) {
        if (!this.containsVertex(v2)) {
            return false;
        }
        if (this.containsVertex(v1)) {
            return this.getParent(v1).equals(v2);
        }
        return this.isLeaf(v2) && v1 == null;
    }

    @Override
    public int outDegree(V vertex) {
        if (!this.containsVertex(vertex)) {
            return 0;
        }
        E[] out_edges = this.vertex_data.get(vertex).child_edges;
        if (out_edges == null) {
            return 0;
        }
        int degree = 0;
        for (int i = 0; i < out_edges.length; ++i) {
            degree += out_edges[i] == null ? 0 : 1;
        }
        return degree;
    }

    @Override
    public boolean addEdge(E edge, Collection<? extends V> vertices, EdgeType edge_type) {
        if (edge == null || vertices == null) {
            throw new IllegalArgumentException("inputs may not be null");
        }
        if (vertices.size() != 2) {
            throw new IllegalArgumentException("'vertices' must contain exactly 2 distinct vertices");
        }
        this.validateEdgeType(edge_type);
        Pair<V> endpoints = vertices instanceof Pair ? (Pair<V>)vertices : new Pair<V>(vertices);
        V v1 = endpoints.getFirst();
        V v2 = endpoints.getSecond();
        if (v1.equals(v2)) {
            throw new IllegalArgumentException("Input vertices must be distinct");
        }
        return this.addEdge(edge, v1, v2);
    }

    @Override
    public boolean addVertex(V vertex) {
        if (this.root == null) {
            this.root = vertex;
            this.vertex_data.put((VertexData)vertex, new VertexData(null, 0));
            this.height = 0;
            return true;
        }
        throw new UnsupportedOperationException("Unless you are setting the root, use addEdge() or addChild()");
    }

    @Override
    public boolean isIncident(V vertex, E edge) {
        if (!this.containsVertex(vertex) || !this.containsEdge(edge)) {
            return false;
        }
        return this.edge_vpairs.get(edge).contains(vertex);
    }

    @Override
    public boolean isNeighbor(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return false;
        }
        return this.getNeighbors(v1).contains(v2);
    }

    @Override
    public boolean containsEdge(E edge) {
        return this.edge_vpairs.containsKey(edge);
    }

    @Override
    public boolean containsVertex(V vertex) {
        return this.vertex_data.containsKey(vertex);
    }

    @Override
    public E findEdge(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        VertexData v1_data = this.vertex_data.get(v1);
        if (this.edge_vpairs.get(v1_data.parent_edge).getFirst().equals(v2)) {
            return v1_data.parent_edge;
        }
        E[] edges = v1_data.child_edges;
        if (edges == null) {
            return null;
        }
        for (int i = 0; i < edges.length; ++i) {
            if (!this.edge_vpairs.get(edges[i]).getSecond().equals(v2)) continue;
            return edges[i];
        }
        return null;
    }

    @Override
    public Collection<E> findEdgeSet(V v1, V v2) {
        E edge = this.findEdge(v1, v2);
        if (edge == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(edge);
    }

    public V getChild(V vertex, int index) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        E[] edges = this.vertex_data.get(vertex).child_edges;
        if (edges == null) {
            return null;
        }
        if (edges[index] == null) {
            return null;
        }
        return this.edge_vpairs.get(edges[index]).getSecond();
    }

    @Override
    public int getEdgeCount() {
        return this.edge_vpairs.size();
    }

    @Override
    public Collection<E> getEdges() {
        return CollectionUtils.unmodifiableCollection(this.edge_vpairs.keySet());
    }

    @Override
    public int getIncidentCount(E edge) {
        return 2;
    }

    @Override
    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        ArrayList edges = new ArrayList(this.order + 1);
        VertexData v_data = this.vertex_data.get(vertex);
        if (v_data.parent_edge != null) {
            edges.add(v_data.parent_edge);
        }
        if (v_data.child_edges != null) {
            for (int i = 0; i < v_data.child_edges.length; ++i) {
                if (v_data.child_edges[i] == null) continue;
                edges.add(v_data.child_edges[i]);
            }
        }
        if (edges.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(edges);
    }

    @Override
    public Collection<V> getIncidentVertices(E edge) {
        return this.edge_vpairs.get(edge);
    }

    @Override
    public int getNeighborCount(V vertex) {
        if (!this.containsVertex(vertex)) {
            return 0;
        }
        return (vertex.equals(this.root) ? 0 : 1) + this.getChildCount(vertex);
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        ArrayList<V> vertices = new ArrayList<V>(this.order + 1);
        VertexData v_data = this.vertex_data.get(vertex);
        if (v_data.parent_edge != null) {
            vertices.add(this.edge_vpairs.get(v_data.parent_edge).getFirst());
        }
        if (v_data.child_edges != null) {
            for (int i = 0; i < v_data.child_edges.length; ++i) {
                if (v_data.child_edges[i] == null) continue;
                vertices.add(this.edge_vpairs.get(v_data.child_edges[i]).getSecond());
            }
        }
        if (vertices.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(vertices);
    }

    @Override
    public int getVertexCount() {
        return this.vertex_data.size();
    }

    @Override
    public Collection<V> getVertices() {
        return CollectionUtils.unmodifiableCollection(this.vertex_data.keySet());
    }

    @Override
    public boolean removeEdge(E edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        this.removeVertex(this.edge_vpairs.get(edge).getSecond());
        this.edge_vpairs.remove(edge);
        return true;
    }

    @Override
    public boolean removeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        for (V v : this.getChildren(vertex)) {
            this.removeVertex(v);
        }
        E edge = this.getParentEdge(vertex);
        this.edge_vpairs.remove(edge);
        E[] edges = this.vertex_data.get(vertex).child_edges;
        if (edges != null) {
            for (int i = 0; i < edges.length; ++i) {
                this.edge_vpairs.remove(edges[i]);
            }
        }
        this.vertex_data.remove(vertex);
        return true;
    }

    @Override
    public boolean addEdge(E edge, Pair<? extends V> endpoints, EdgeType edgeType) {
        if (edge == null || endpoints == null) {
            throw new IllegalArgumentException("inputs must not be null");
        }
        return this.addEdge(edge, endpoints.getFirst(), endpoints.getSecond(), edgeType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VertexData {
        E[] child_edges;
        E parent_edge;
        int depth;

        protected VertexData(E parent_edge, int depth) {
            this.parent_edge = parent_edge;
            this.depth = depth;
        }
    }
}

