/******************************************************************************
 *
 * Copyright (c) 1999-2005 AppGate Network Security AB. All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the MindTerm Public Source License,
 * Version 2.0, (the 'License'). You may not use this file except in compliance
 * with the License.
 * 
 * You should have received a copy of the MindTerm Public Source License
 * along with this software; see the file LICENSE.  If not, write to
 * AppGate Network Security AB, Otterhallegatan 2, SE-41118 Goteborg, SWEDEN
 *
 *****************************************************************************/

package com.mindbright.jca.security;

public interface Key extends java.io.Serializable {
    /**
     * Get the algorithm name
     *
     * @return the name of the algorithm this key supports
     */
    public String getAlgorithm();

    /**
     * Get the primary encoding format of this key.
     *
     * @return the primary encoding format of the key
     */
    public String getFormat();

    /**
     * Get the key in its encoded form
     *
     * @return the key in its encoded form
     */
    public byte[] getEncoded();
}
