/**
 * com.mckoi.dbcontrol.DBConfig  27 Mar 2002
 *
 * Mckoi SQL Database ( http://www.mckoi.com/database )
 * Copyright (C) 2000, 2001, 2002  Diehl and Associates, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * Version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License Version 2 for more details.
 *
 * You should have received a copy of the GNU General Public License
 * Version 2 along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Change Log:
 * 
 * 
 */

package com.mckoi.database.control;

import java.io.File;

/**
 * A container object of configuration details of a database system.  This
 * object can be used to programmatically setup configuration properies
 * in a database system.
 *
 * @author Tobias Downer
 */

public interface DBConfig {

  /**
   * Returns the current path set for this configuration.  This is
   * useful if the configuration is based on a configuration file that has
   * path references relative to the configuration file.  In this case,
   * the path returned here would be the path to the configuration
   * file.
   */
  File currentPath();

  /**
   * Returns the value that was set for the configuration property with the
   * given name.
   * <p>
   * This method must always returns a value that the database engine can use
   * provided the 'property_key' is a supported key.  If the property key
   * is not supported and the key was not set, null is returned.
   */
  String getValue(String property_key);

  /**
   * Makes an immutable copy of this configuration.
   */
  DBConfig immutableCopy();

}
