/**
 * com.mckoi.database.TriggerEvent  16 Feb 2001
 *
 * Mckoi SQL Database ( http://www.mckoi.com/database )
 * Copyright (C) 2000, 2001, 2002  Diehl and Associates, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * Version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License Version 2 for more details.
 *
 * You should have received a copy of the GNU General Public License
 * Version 2 along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Change Log:
 * 
 * 
 */

package com.mckoi.database;

/**
 * A trigger event represents a high level action that occured in the
 * database.  A trigger event is generated by the SQL interpreter on evaluation
 * of curtain types of queries.
 *
 * @author Tobias Downer
 */

public class TriggerEvent {

  /**
   * Statics that represent the different types of high layer trigger events.
   */
  public static final int INSERT = 1;
  public static final int DELETE = 2;
  public static final int UPDATE = 3;

  /**
   * The type of this event.
   */
  private int type;

  /**
   * The source of the trigger (eg. the table name).
   */
  private String source;

  /**
   * The number of times this event was fired.
   */
  private int count;

  /**
   * Constructs the trigger event.
   */
  public TriggerEvent(int type, String source, int count) {
    this.type = type;
    this.source = source;
    this.count = count;
  }

  public TriggerEvent(int type, String source) {
    this(type, source, 1);
  }

  /**
   * Returns the type of this event.
   */
  public int getType() {
    return type;
  }

  /**
   * Returns the source of this event.
   */
  public String getSource() {
    return source;
  }

  /**
   * Returns the number of times this event was fired.
   */
  public int getCount() {
    return count;
  }

}
