/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.contrib.mckoi;

import com.mckoi.database.control.DBController;
import com.mckoi.database.control.DBSystem;
import com.mckoi.database.control.DefaultDBConfig;
import com.mckoi.database.control.TCPJDBCServer;
import java.io.File;
import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.tapestry.contrib.mckoi.McKoiDBMBean;
import org.jboss.system.ServiceMBeanSupport;

public class McKoiDB
extends ServiceMBeanSupport
implements McKoiDBMBean {
    private String _configPath;
    private DBSystem _database;
    private TCPJDBCServer _server;

    public String getConfigPath() {
        return this._configPath;
    }

    public void setConfigPath(String path) {
        this.log.debug((Object)("Config path set to: " + path));
        this._configPath = path;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name != null) {
            return name;
        }
        return new ObjectName(":service=McKoiDB");
    }

    public String getName() {
        return "McKoiDB";
    }

    public void startService() throws Exception {
        if (this._configPath == null) {
            throw new NullPointerException("McKoiDB: configPath not specified.");
        }
        this.log.debug((Object)("Config path: " + this._configPath));
        File configFile = new File(this._configPath).getAbsoluteFile();
        File rootFile = configFile.getParentFile();
        DefaultDBConfig config = new DefaultDBConfig(rootFile);
        try {
            config.loadFromFile(configFile);
        }
        catch (IOException ex) {
            this.log.error((Object)"Unable to initialize McKoi database.", (Throwable)ex);
        }
        DBController controller = DBController.getDefault();
        this._database = controller.startDatabase(config);
        this._server = new TCPJDBCServer(this._database);
        this._server.start();
        this.log.info((Object)this._server);
    }

    public void stopService() {
        this._server.stop();
        this._database.close();
    }
}

