/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import java.math.BigDecimal;
import java.text.CharacterIterator;
import java.text.ParseException;

public class GeneralParser {
    private static final BigDecimal MILLIS_IN_WEEK = new BigDecimal(6.048E8);
    private static final BigDecimal MILLIS_IN_DAY = new BigDecimal(8.64E7);
    private static final BigDecimal MILLIS_IN_HOUR = new BigDecimal(3600000.0);
    private static final BigDecimal MILLIS_IN_MINUTE = new BigDecimal(60000.0);
    private static final BigDecimal MILLIS_IN_SECOND = new BigDecimal(1000.0);

    public static void parseDigitString(CharacterIterator i, StringBuffer digit_str) {
        char c = i.current();
        while (Character.isDigit(c)) {
            digit_str.append(c);
            c = i.next();
        }
    }

    public static void parseWordString(CharacterIterator i, StringBuffer word_buffer) {
        char c = i.current();
        while (Character.isLetter(c)) {
            word_buffer.append(c);
            c = i.next();
        }
    }

    public static void skipWhiteSpace(CharacterIterator i) {
        char c = i.current();
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            c = i.next();
        }
    }

    public static BigDecimal parseBigDecimal(CharacterIterator i) throws ParseException {
        boolean done_decimal = false;
        StringBuffer str_val = new StringBuffer();
        char c = i.current();
        if (c == '-') {
            str_val.append(c);
            c = i.next();
        }
        if (c == '.') {
            done_decimal = true;
            str_val.append(c);
            c = i.next();
        }
        if (!Character.isDigit(c)) {
            throw new ParseException("Parsing BigDecimal", i.getIndex());
        }
        GeneralParser.parseDigitString(i, str_val);
        c = i.current();
        if (!done_decimal && c == '.') {
            str_val.append(c);
            c = i.next();
            GeneralParser.parseDigitString(i, str_val);
        }
        return new BigDecimal(new String(str_val));
    }

    public static BigDecimal parseTimeMeasure(CharacterIterator i) throws ParseException {
        boolean time_measured = false;
        BigDecimal time_measure = new BigDecimal(0.0);
        boolean[] time_parsed = new boolean[6];
        StringBuffer word_buffer = new StringBuffer();
        while (true) {
            BigDecimal num;
            GeneralParser.skipWhiteSpace(i);
            try {
                num = GeneralParser.parseBigDecimal(i);
            }
            catch (ParseException e) {
                if (time_measured) {
                    return time_measure;
                }
                throw new ParseException("No time value found", i.getIndex());
            }
            if (num.signum() < 0) {
                throw new ParseException("Invalid time value: " + num, i.getIndex());
            }
            GeneralParser.skipWhiteSpace(i);
            word_buffer.setLength(0);
            GeneralParser.parseWordString(i, word_buffer);
            String str = new String(word_buffer).toLowerCase();
            if ((str.startsWith("week") || str.equals("w")) && !time_parsed[0]) {
                time_measure = time_measure.add(num.multiply(MILLIS_IN_WEEK));
                time_parsed[0] = true;
            } else if ((str.startsWith("day") || str.equals("d")) && !time_parsed[1]) {
                time_measure = time_measure.add(num.multiply(MILLIS_IN_DAY));
                time_parsed[1] = true;
            } else if ((str.startsWith("hour") || str.startsWith("hr") || str.equals("h")) && !time_parsed[2]) {
                time_measure = time_measure.add(num.multiply(MILLIS_IN_HOUR));
                time_parsed[2] = true;
            } else if ((str.startsWith("minute") || str.startsWith("min") || str.equals("m")) && !time_parsed[3]) {
                time_measure = time_measure.add(num.multiply(MILLIS_IN_MINUTE));
                time_parsed[3] = true;
            } else if ((str.startsWith("second") || str.startsWith("sec") || str.equals("s")) && !time_parsed[4]) {
                time_measure = time_measure.add(num.multiply(MILLIS_IN_SECOND));
                time_parsed[4] = true;
            } else if ((str.startsWith("millisecond") || str.equals("ms")) && !time_parsed[5]) {
                time_measure = time_measure.add(num);
                time_parsed[5] = true;
            } else {
                throw new ParseException("Unknown time measure: " + str, i.getIndex());
            }
            time_measured = true;
        }
    }
}

