/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import com.mckoi.util.ByteArrayUtil;

public final class ByteBuffer {
    private byte[] buf;
    private int pos;
    private int lim;

    public ByteBuffer(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.lim = length;
        this.pos = offset;
    }

    public ByteBuffer(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public void position(int position) {
        this.pos = position;
    }

    public int position() {
        return this.pos;
    }

    public int limit() {
        return this.lim;
    }

    public ByteBuffer put(byte[] b, int offset, int length) {
        System.arraycopy(b, offset, this.buf, this.pos, length);
        this.position(this.pos + length);
        return this;
    }

    public ByteBuffer put(byte[] b) {
        return this.put(b, 0, b.length);
    }

    public ByteBuffer put(ByteBuffer buffer) {
        return this.put(buffer.buf, buffer.pos, buffer.lim);
    }

    public ByteBuffer get(byte[] b, int offset, int length) {
        System.arraycopy(this.buf, this.pos, b, offset, length);
        this.position(this.pos + length);
        return this;
    }

    public ByteBuffer putInt(int v) {
        ByteArrayUtil.setInt(v, this.buf, this.pos);
        this.position(this.pos + 4);
        return this;
    }

    public int getInt() {
        int v = ByteArrayUtil.getInt(this.buf, this.pos);
        this.position(this.pos + 4);
        return v;
    }

    public ByteBuffer putByte(byte v) {
        this.buf[this.pos] = v;
        ++this.pos;
        return this;
    }

    public byte getByte() {
        byte b = this.buf[this.pos];
        ++this.pos;
        return b;
    }

    public ByteBuffer putShort(short v) {
        ByteArrayUtil.setShort(v, this.buf, this.pos);
        this.position(this.pos + 2);
        return this;
    }

    public short getShort() {
        short v = ByteArrayUtil.getShort(this.buf, this.pos);
        this.position(this.pos + 2);
        return v;
    }
}

