/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import com.mckoi.util.AbstractBlockIntegerList;
import com.mckoi.util.IndexComparator;
import com.mckoi.util.IntegerListBlockInterface;
import com.mckoi.util.IntegerListInterface;
import com.mckoi.util.IntegerVector;

public class BlockIntegerList
extends AbstractBlockIntegerList {
    public BlockIntegerList() {
    }

    public BlockIntegerList(IntegerVector ivec) {
        super(ivec);
    }

    public BlockIntegerList(IntegerListInterface i_list) {
        super(i_list);
    }

    protected IntegerListBlockInterface newListBlock() {
        return new IntArrayListBlock(512);
    }

    protected void deleteListBlock(IntegerListBlockInterface list_block) {
    }

    public static class IntArrayListBlock
    extends IntegerListBlockInterface {
        protected int[] array;
        protected int count;

        protected IntArrayListBlock() {
        }

        public IntArrayListBlock(int block_size) {
            this();
            this.array = new int[block_size];
            this.count = 0;
        }

        protected int[] getArray(boolean immutable) {
            return this.array;
        }

        protected int getArrayLength() {
            return this.array.length;
        }

        public final int size() {
            return this.count;
        }

        public final boolean isFull() {
            return this.count >= this.getArrayLength();
        }

        public final boolean isEmpty() {
            return this.count <= 0;
        }

        public final boolean canContain(int number) {
            return this.count + number + 1 < this.getArrayLength();
        }

        public int topInt() {
            return this.getArray(true)[this.count - 1];
        }

        public int bottomInt() {
            if (this.count > 0) {
                return this.getArray(true)[0];
            }
            throw new Error("no bottom integer.");
        }

        public final int intAt(int pos) {
            return this.getArray(true)[pos];
        }

        public final void addInt(int val) {
            this.has_changed = true;
            int[] arr = this.getArray(false);
            arr[this.count] = val;
            ++this.count;
        }

        public final int removeIntAt(int pos) {
            this.has_changed = true;
            int[] arr = this.getArray(false);
            int val = arr[pos];
            System.arraycopy(this.array, pos + 1, arr, pos, this.count - pos);
            --this.count;
            return val;
        }

        public final void insertIntAt(int val, int pos) {
            this.has_changed = true;
            int[] arr = this.getArray(false);
            System.arraycopy(this.array, pos, arr, pos + 1, this.count - pos);
            ++this.count;
            arr[pos] = val;
        }

        public final int setIntAt(int val, int pos) {
            this.has_changed = true;
            int[] arr = this.getArray(false);
            int old = arr[pos];
            arr[pos] = val;
            return old;
        }

        public final void moveTo(IntegerListBlockInterface dest_block, int dest_index, int length) {
            IntArrayListBlock block = (IntArrayListBlock)dest_block;
            int[] arr = this.getArray(false);
            int[] dest_arr = block.getArray(false);
            int destb_size = block.size();
            if (destb_size > 0) {
                System.arraycopy(dest_arr, 0, dest_arr, length, destb_size);
            }
            System.arraycopy(arr, this.count - length, dest_arr, 0, length);
            block.count += length;
            this.count -= length;
            this.has_changed = true;
            block.has_changed = true;
        }

        public final void copyTo(IntegerListBlockInterface dest_block) {
            IntArrayListBlock block = (IntArrayListBlock)dest_block;
            int[] dest_arr = block.getArray(false);
            System.arraycopy(this.getArray(true), 0, dest_arr, 0, this.count);
            block.count = this.count;
            block.has_changed = true;
        }

        public final int copyTo(int[] to, int offset) {
            System.arraycopy(this.getArray(true), 0, to, offset, this.count);
            return this.count;
        }

        public final void clear() {
            this.has_changed = true;
            this.count = 0;
        }

        public int iterativeSearch(int val) {
            int[] arr = this.getArray(true);
            for (int i = this.count - 1; i >= 0; --i) {
                if (arr[i] != val) continue;
                return i;
            }
            return -1;
        }

        public int iterativeSearch(int val, int position) {
            int[] arr = this.getArray(true);
            for (int i = position; i < this.count; ++i) {
                if (arr[i] != val) continue;
                return i;
            }
            return -1;
        }

        public final int binarySearch(Object key, IndexComparator c) {
            int[] arr = this.getArray(true);
            int low = 0;
            int high = this.count - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                int cmp = c.compare(arr[mid], key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public final int searchFirst(Object key, IndexComparator c) {
            int[] arr = this.getArray(true);
            int low = 0;
            int high = this.count - 1;
            while (low <= high) {
                int cmp;
                if (high - low <= 2) {
                    for (int i = low; i <= high; ++i) {
                        cmp = c.compare(arr[i], key);
                        if (cmp == 0) {
                            return i;
                        }
                        if (cmp <= 0) continue;
                        return -(i + 1);
                    }
                    return -(high + 2);
                }
                int mid = (low + high) / 2;
                cmp = c.compare(arr[mid], key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                high = mid;
            }
            return -(low + 1);
        }

        public final int searchLast(Object key, IndexComparator c) {
            int[] arr = this.getArray(true);
            int low = 0;
            int high = this.count - 1;
            while (low <= high) {
                int cmp;
                if (high - low <= 2) {
                    for (int i = high; i >= low; --i) {
                        cmp = c.compare(arr[i], key);
                        if (cmp == 0) {
                            return i;
                        }
                        if (cmp >= 0) continue;
                        return -(i + 2);
                    }
                    return -(low + 1);
                }
                int mid = (low + high) / 2;
                cmp = c.compare(arr[mid], key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid;
            }
            return -(low + 1);
        }

        public final int searchFirst(int val) {
            int[] arr = this.getArray(true);
            int low = 0;
            int high = this.count - 1;
            while (low <= high) {
                if (high - low <= 2) {
                    for (int i = low; i <= high; ++i) {
                        if (arr[i] == val) {
                            return i;
                        }
                        if (arr[i] <= val) continue;
                        return -(i + 1);
                    }
                    return -(high + 2);
                }
                int mid = (low + high) / 2;
                if (arr[mid] < val) {
                    low = mid + 1;
                    continue;
                }
                if (arr[mid] > val) {
                    high = mid - 1;
                    continue;
                }
                high = mid;
            }
            return -(low + 1);
        }

        public final int searchLast(int val) {
            int[] arr = this.getArray(true);
            int low = 0;
            int high = this.count - 1;
            while (low <= high) {
                if (high - low <= 2) {
                    for (int i = high; i >= low; --i) {
                        if (arr[i] == val) {
                            return i;
                        }
                        if (arr[i] >= val) continue;
                        return -(i + 2);
                    }
                    return -(low + 1);
                }
                int mid = (low + high) / 2;
                if (arr[mid] < val) {
                    low = mid + 1;
                    continue;
                }
                if (arr[mid] > val) {
                    high = mid - 1;
                    continue;
                }
                low = mid;
            }
            return -(low + 1);
        }

        public String toString() {
            int[] arr = this.getArray(true);
            StringBuffer buf = new StringBuffer();
            buf.append("( VALUES: " + this.count + " ) ");
            for (int i = 0; i < this.count; ++i) {
                buf.append(arr[i]);
                buf.append(", ");
            }
            return new String(buf);
        }
    }
}

