/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigNumber
extends Number {
    static final long serialVersionUID = -8681578742639638105L;
    private static final byte NEG_INF_STATE = 1;
    private static final byte POS_INF_STATE = 2;
    private static final byte NaN_STATE = 3;
    private byte number_state;
    private BigDecimal big_decimal;
    private long long_representation;
    private byte byte_count = (byte)120;
    private static final BigDecimal BD_ZERO = new BigDecimal(0.0);
    public static final BigNumber NEGATIVE_INFINITY = new BigNumber(1, null);
    public static final BigNumber POSITIVE_INFINITY = new BigNumber(2, null);
    public static final BigNumber NaN = new BigNumber(3, null);
    public static final BigNumber BIG_NUMBER_ZERO = BigNumber.fromLong(0L);
    public static final BigNumber BIG_NUMBER_ONE = BigNumber.fromLong(1L);

    private BigNumber(byte number_state, BigDecimal big_decimal) {
        this.number_state = number_state;
        if (number_state == 0) {
            this.setBigDecimal(big_decimal);
        }
    }

    private BigNumber(byte[] buf, int scale, byte state) {
        this.number_state = state;
        if (this.number_state == 0) {
            BigInteger bigint = new BigInteger(buf);
            this.setBigDecimal(new BigDecimal(bigint, scale));
        }
    }

    private void setBigDecimal(BigDecimal big_decimal) {
        this.big_decimal = big_decimal;
        if (big_decimal.scale() == 0) {
            BigInteger bint = big_decimal.toBigInteger();
            int bit_count = big_decimal.toBigInteger().bitLength();
            if (bit_count < 30) {
                this.long_representation = bint.longValue();
                this.byte_count = (byte)4;
            } else if (bit_count < 60) {
                this.long_representation = bint.longValue();
                this.byte_count = (byte)8;
            }
        }
    }

    public boolean canBeRepresentedAsLong() {
        return this.byte_count <= 8;
    }

    public boolean canBeRepresentedAsInt() {
        return this.byte_count <= 4;
    }

    public int getScale() {
        if (this.number_state == 0) {
            return this.big_decimal.scale();
        }
        return -1;
    }

    public byte getState() {
        return this.number_state;
    }

    private byte getInverseState() {
        if (this.number_state == 1) {
            return 2;
        }
        if (this.number_state == 2) {
            return 1;
        }
        return this.number_state;
    }

    public byte[] toByteArray() {
        if (this.number_state == 0) {
            return this.big_decimal.movePointRight(this.big_decimal.scale()).toBigInteger().toByteArray();
        }
        return new byte[0];
    }

    public String toString() {
        switch (this.number_state) {
            case 0: {
                return this.big_decimal.toString();
            }
            case 1: {
                return "-Infinity";
            }
            case 2: {
                return "Infinity";
            }
            case 3: {
                return "NaN";
            }
        }
        throw new Error("Unknown number state");
    }

    public double doubleValue() {
        switch (this.number_state) {
            case 0: {
                return this.big_decimal.doubleValue();
            }
            case 1: {
                return Double.NEGATIVE_INFINITY;
            }
            case 2: {
                return Double.POSITIVE_INFINITY;
            }
            case 3: {
                return Double.NaN;
            }
        }
        throw new Error("Unknown number state");
    }

    public float floatValue() {
        switch (this.number_state) {
            case 0: {
                return this.big_decimal.floatValue();
            }
            case 1: {
                return Float.NEGATIVE_INFINITY;
            }
            case 2: {
                return Float.POSITIVE_INFINITY;
            }
            case 3: {
                return Float.NaN;
            }
        }
        throw new Error("Unknown number state");
    }

    public long longValue() {
        if (this.canBeRepresentedAsLong()) {
            return this.long_representation;
        }
        switch (this.number_state) {
            case 0: {
                return this.big_decimal.longValue();
            }
        }
        return (long)this.doubleValue();
    }

    public int intValue() {
        if (this.canBeRepresentedAsLong()) {
            return (int)this.long_representation;
        }
        switch (this.number_state) {
            case 0: {
                return this.big_decimal.intValue();
            }
        }
        return (int)this.doubleValue();
    }

    public short shortValue() {
        return (short)this.intValue();
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public BigDecimal asBigDecimal() {
        if (this.number_state == 0) {
            return this.big_decimal;
        }
        throw new ArithmeticException("NaN, +Infinity or -Infinity can't be translated to a BigDecimal");
    }

    public int compareTo(BigNumber number) {
        if (this == number) {
            return 0;
        }
        if (this.number_state == 0) {
            if (this.canBeRepresentedAsLong() && number.canBeRepresentedAsLong()) {
                if (this.long_representation > number.long_representation) {
                    return 1;
                }
                if (this.long_representation < number.long_representation) {
                    return -1;
                }
                return 0;
            }
            if (number.number_state == 0) {
                return this.big_decimal.compareTo(number.big_decimal);
            }
            if (number.number_state == 2 || number.number_state == 3) {
                return -1;
            }
            if (number.number_state == 1) {
                return 1;
            }
            throw new Error("Unknown number state.");
        }
        if (number.number_state == 0) {
            if (this.number_state == 1) {
                return -1;
            }
            if (this.number_state == 2 || this.number_state == 3) {
                return 1;
            }
            throw new Error("Unknown number state.");
        }
        return this.number_state - number.number_state;
    }

    public boolean equals(Object ob) {
        BigNumber bnum = (BigNumber)ob;
        if (this.number_state != 0) {
            return this.number_state == bnum.number_state;
        }
        return this.big_decimal.equals(bnum.big_decimal);
    }

    public BigNumber bitWiseOr(BigNumber number) {
        if (this.number_state == 0 && this.getScale() == 0 && number.number_state == 0 && number.getScale() == 0) {
            BigInteger bi1 = this.big_decimal.toBigInteger();
            BigInteger bi2 = number.big_decimal.toBigInteger();
            return new BigNumber(0, new BigDecimal(bi1.or(bi2)));
        }
        return null;
    }

    public BigNumber add(BigNumber number) {
        if (this.number_state == 0) {
            if (number.number_state == 0) {
                return new BigNumber(0, this.big_decimal.add(number.big_decimal));
            }
            return new BigNumber(number.number_state, null);
        }
        return new BigNumber(this.number_state, null);
    }

    public BigNumber subtract(BigNumber number) {
        if (this.number_state == 0) {
            if (number.number_state == 0) {
                return new BigNumber(0, this.big_decimal.subtract(number.big_decimal));
            }
            return new BigNumber(number.getInverseState(), null);
        }
        return new BigNumber(this.number_state, null);
    }

    public BigNumber multiply(BigNumber number) {
        if (this.number_state == 0) {
            if (number.number_state == 0) {
                return new BigNumber(0, this.big_decimal.multiply(number.big_decimal));
            }
            return new BigNumber(number.number_state, null);
        }
        return new BigNumber(this.number_state, null);
    }

    public BigNumber divide(BigNumber number) {
        BigDecimal div_by;
        if (this.number_state == 0 && number.number_state == 0 && (div_by = number.big_decimal).compareTo(BD_ZERO) != 0) {
            return new BigNumber(0, this.big_decimal.divide(div_by, 10, 4));
        }
        return new BigNumber(3, null);
    }

    public BigNumber abs() {
        if (this.number_state == 0) {
            return new BigNumber(0, this.big_decimal.abs());
        }
        if (this.number_state == 1) {
            return new BigNumber(2, null);
        }
        return new BigNumber(this.number_state, null);
    }

    public int signum() {
        if (this.number_state == 0) {
            return this.big_decimal.signum();
        }
        if (this.number_state == 1) {
            return -1;
        }
        return 1;
    }

    public BigNumber setScale(int d, int round_enum) {
        if (this.number_state == 0) {
            return new BigNumber(0, this.big_decimal.setScale(d, round_enum));
        }
        return this;
    }

    public BigNumber sqrt() {
        double d = this.doubleValue();
        d = Math.sqrt(d);
        return BigNumber.fromDouble(d);
    }

    public static BigNumber fromDouble(double value) {
        if (value == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (value != value) {
            return NaN;
        }
        return new BigNumber(0, new BigDecimal(Double.toString(value)));
    }

    public static BigNumber fromFloat(float value) {
        if (value == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (value == Float.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (value != value) {
            return NaN;
        }
        return new BigNumber(0, new BigDecimal(Float.toString(value)));
    }

    public static BigNumber fromLong(long value) {
        return new BigNumber(0, BigDecimal.valueOf(value));
    }

    public static BigNumber fromInt(int value) {
        return new BigNumber(0, BigDecimal.valueOf(value));
    }

    public static BigNumber fromString(String str) {
        if (str.equals("Infinity")) {
            return POSITIVE_INFINITY;
        }
        if (str.equals("-Infinity")) {
            return NEGATIVE_INFINITY;
        }
        if (str.equals("NaN")) {
            return NaN;
        }
        return new BigNumber(0, new BigDecimal(str));
    }

    public static BigNumber fromBigDecimal(BigDecimal val) {
        return new BigNumber(0, val);
    }

    public static BigNumber fromData(byte[] buf, int scale, byte state) {
        if (state == 0) {
            if (scale == 0 && buf.length == 1) {
                if (buf[0] == 0) {
                    return BIG_NUMBER_ZERO;
                }
                if (buf[0] == 1) {
                    return BIG_NUMBER_ONE;
                }
            }
            return new BigNumber(buf, scale, state);
        }
        if (state == 1) {
            return NEGATIVE_INFINITY;
        }
        if (state == 2) {
            return POSITIVE_INFINITY;
        }
        if (state == 3) {
            return NaN;
        }
        throw new Error("Unknown number state.");
    }
}

