/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.tools;

import com.mckoi.jfccontrols.Query;
import com.mckoi.jfccontrols.QueryAgent;
import com.mckoi.jfccontrols.ResultSetTableModel;
import com.mckoi.util.CommandLine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

public class JDBCQueryTool
extends JComponent {
    private QueryAgent query_agent;
    private JTextArea query_text_area;
    private JTable result_table;
    private ResultSetTableModel table_model;
    private JLabel status_text;
    protected JCheckBoxMenuItem auto_resize_result_table;
    private int total_row_count;
    private int query_time = -1;
    private static int query_window_count = 0;

    public JDBCQueryTool(QueryAgent in_query_agent) {
        this.query_agent = in_query_agent;
        this.auto_resize_result_table = new JCheckBoxMenuItem("Auto Resize Columns");
        this.auto_resize_result_table.setSelected(true);
        this.auto_resize_result_table.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (JDBCQueryTool.this.auto_resize_result_table.isSelected()) {
                    JDBCQueryTool.this.result_table.setAutoResizeMode(2);
                } else {
                    JDBCQueryTool.this.result_table.setAutoResizeMode(0);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        JPanel query_area = new JPanel();
        query_area.setLayout(new BorderLayout());
        Font mono_font = new Font("MonoSpaced", 0, 12);
        this.query_text_area = new JTextArea(7, 80);
        this.query_text_area.setFont(mono_font);
        final JButton execute = new JButton("Run Query");
        final JButton stop = new JButton("Stop Query");
        stop.setEnabled(false);
        JPanel button_bar = new JPanel();
        button_bar.setLayout(new FlowLayout());
        button_bar.add(execute);
        button_bar.add(stop);
        query_area.add((Component)new JScrollPane(this.query_text_area), "Center");
        query_area.add((Component)button_bar, "South");
        this.table_model = new ResultSetTableModel();
        this.table_model.setPreserveTableStructure(true);
        this.result_table = new JTable(this.table_model);
        JScrollPane scrolly_result_table = new JScrollPane(this.result_table);
        scrolly_result_table.setPreferredSize(new Dimension(650, 450));
        this.status_text = new JLabel("  ");
        this.status_text.setFont(mono_font);
        this.status_text.setBorder(new BevelBorder(1));
        JSplitPane split_pane = new JSplitPane(0);
        split_pane.setTopComponent(query_area);
        split_pane.setBottomComponent(scrolly_result_table);
        this.add((Component)split_pane, "Center");
        this.add((Component)this.status_text, "South");
        execute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    stop.setEnabled(true);
                    execute.setEnabled(false);
                    Query query = new Query(JDBCQueryTool.this.query_text_area.getText());
                    long time_start = System.currentTimeMillis();
                    ResultSet result_set = JDBCQueryTool.this.query_agent.executeQuery(query);
                    JDBCQueryTool.this.query_time = (int)(System.currentTimeMillis() - time_start);
                    JDBCQueryTool.this.result_table.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                    JDBCQueryTool.this.table_model.updateResultSet(result_set);
                    JDBCQueryTool.this.total_row_count = 0;
                    if (result_set.last()) {
                        JDBCQueryTool.this.total_row_count = result_set.getRow();
                    }
                    JDBCQueryTool.this.updateStatus();
                }
                catch (SQLException e) {
                    JOptionPane.showMessageDialog(JDBCQueryTool.this, e.getMessage(), "SQL Error", 0);
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    System.err.println("Query cancelled.");
                }
                stop.setEnabled(false);
                execute.setEnabled(true);
            }
        });
        stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDBCQueryTool.this.query_agent.cancelQuery();
            }
        });
    }

    public JDBCQueryTool(Connection connection) {
        this(new QueryAgent(connection));
    }

    private void updateStatus() {
        StringBuffer buf = new StringBuffer();
        buf.append("Query Time: ");
        buf.append((double)this.query_time / 1000.0);
        buf.append(" seconds.  Row Count: ");
        buf.append(this.total_row_count);
        this.status_text.setText(new String(buf));
    }

    public static void createNewWindow(final Connection connection, final boolean close_connection_on_close, final boolean system_exit_on_close) {
        ++query_window_count;
        QueryAgent query_agent = new QueryAgent(connection);
        final JFrame frame = new JFrame("Mckoi JDBC Query Tool");
        final AbstractAction close_action = new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent evt) {
                frame.dispose();
                --query_window_count;
                if (query_window_count == 0) {
                    if (close_connection_on_close) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e) {
                            System.err.println("SQL Exception on close: " + e.getMessage());
                        }
                    }
                    if (system_exit_on_close) {
                        System.exit(0);
                    }
                }
            }
        };
        AbstractAction clone_action = new AbstractAction("New Window"){

            public void actionPerformed(ActionEvent evt) {
                JDBCQueryTool.createNewWindow(connection, close_connection_on_close, system_exit_on_close);
            }
        };
        Container c = frame.getContentPane();
        c.setLayout(new BorderLayout());
        JDBCQueryTool query_tool = new JDBCQueryTool(query_agent);
        c.add((Component)query_tool, "Center");
        JMenuBar menu_bar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(clone_action);
        file.addSeparator();
        file.add(close_action);
        menu_bar.add(file);
        JMenu options = new JMenu("Options");
        options.add(query_tool.auto_resize_result_table);
        menu_bar.add(options);
        frame.setJMenuBar(menu_bar);
        frame.pack();
        frame.show();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                close_action.actionPerformed(null);
            }
        });
    }

    private static void printSyntax() {
        System.out.println("JDBCQueryTool [-jdbc JDBC_Driver_Class] [-url JDBC_URL] -u username -p password");
    }

    public static void main(String[] args) {
        CommandLine cl = new CommandLine(args);
        String driver = cl.switchArgument("-jdbc", "com.mckoi.JDBCDriver");
        String url = cl.switchArgument("-url", "jdbc:mckoi:");
        String username = cl.switchArgument("-u");
        String password = cl.switchArgument("-p");
        if (username == null) {
            System.out.println("Please provide a username");
            System.out.println();
            JDBCQueryTool.printSyntax();
        } else if (password == null) {
            System.out.println("Please provide a password");
            System.out.println();
            JDBCQueryTool.printSyntax();
        } else {
            try {
                System.out.println("Using JDBC Driver: " + driver);
                Class.forName(driver).newInstance();
                final Connection connection = DriverManager.getConnection(url, username, password);
                System.out.println("Connection established to: " + url);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JDBCQueryTool.createNewWindow(connection, true, true);
                    }
                });
            }
            catch (ClassNotFoundException e) {
                System.out.println("JDBC Driver not found.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

