/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.tools;

import com.mckoi.database.TableDataConglomerate;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.control.DefaultDBConfig;
import com.mckoi.tools.ConglomerateViewPane;
import com.mckoi.util.CommandLine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JFrame;

public class DBConglomerateDiagTool {
    private static void diagnose(String path, String name) {
        try {
            TransactionSystem system = new TransactionSystem();
            DefaultDBConfig config = new DefaultDBConfig();
            config.setDatabasePath(path);
            config.setLogPath("");
            config.setMinimumDebugLevel(50000);
            config.setReadOnly(true);
            system.setDebugOutput(new StringWriter());
            system.init(config);
            system.setDebugLevel(10);
            final TableDataConglomerate conglomerate = new TableDataConglomerate(system, system.storeSystem());
            conglomerate.open(name);
            final JFrame frame = new JFrame("Mckoi SQL Database Diagnostic Tool");
            frame.setDefaultCloseOperation(0);
            Container c = frame.getContentPane();
            c.setLayout(new BorderLayout());
            c.add((Component)new ConglomerateViewPane(conglomerate), "Center");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    try {
                        frame.dispose();
                        conglomerate.close();
                        System.exit(0);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            frame.pack();
            frame.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printSyntax() {
        System.out.println("DBConglomerateDiagTool -path [data directory] [-name [database name]]");
    }

    public static void main(String[] args) {
        CommandLine cl = new CommandLine(args);
        String path = cl.switchArgument("-path");
        String name = cl.switchArgument("-name", "DefaultDatabase");
        if (path == null) {
            DBConglomerateDiagTool.printSyntax();
            System.out.println("Error: -path not found on command line.");
            System.exit(-1);
        }
        DBConglomerateDiagTool.diagnose(path, name);
    }
}

