/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.tools;

import com.mckoi.database.RawDiagnosticTable;
import com.mckoi.database.TableDataConglomerate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

class ConglomerateViewPane
extends JRootPane {
    private TableDataConglomerate conglomerate;
    private RawDiagnosticTable current_table;
    private StoreViewPane view_pane;
    private Action average_row_count_action = new AbstractAction("Table Statistics"){

        public void actionPerformed(ActionEvent evt) {
            if (ConglomerateViewPane.this.current_table == null || ConglomerateViewPane.this.current_table.physicalRecordCount() < 10) {
                return;
            }
            int row_count = ConglomerateViewPane.this.current_table.physicalRecordCount();
            int[] store = new int[row_count];
            long total_size = 0L;
            for (int i = 0; i < row_count; ++i) {
                int record_size;
                store[i] = record_size = ConglomerateViewPane.this.current_table.recordSize(i);
                total_size += (long)record_size;
            }
            int avg = (int)(total_size / (long)row_count);
            System.out.println("Average row size: " + avg);
            double best_score = 1.0E11;
            int best_ss = 45;
            int best_size = Integer.MAX_VALUE;
            for (int ss = 19; ss < avg + 128; ++ss) {
                int total_sectors = 0;
                for (int n = 0; n < store.length; ++n) {
                    int sz = store[n];
                    total_sectors += sz / (ss + 1) + 1;
                }
                int file_size = (ss + 5) * total_sectors;
                double average_sec = (double)total_sectors / (double)row_count;
                double score = (double)file_size * ((average_sec - 1.0) / 20.0 + 1.0);
                System.out.println(" (" + score + " : " + file_size + " : " + ss + " : " + average_sec + ") ");
                if (!(average_sec < 2.8) || !(score < best_score)) continue;
                best_score = score;
                best_size = file_size;
                best_ss = ss;
            }
            System.out.println("Best sector size: " + best_ss + " Best file size: " + best_size);
        }
    };

    public ConglomerateViewPane(TableDataConglomerate conglom) {
        this.setPreferredSize(new Dimension(750, 550));
        this.conglomerate = conglom;
        JMenu info = new JMenu("Info");
        info.add(this.average_row_count_action);
        JMenuBar menubar = new JMenuBar();
        menubar.add(info);
        this.setJMenuBar(menubar);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.view_pane = new StoreViewPane();
        final String[] str_t_list = this.conglomerate.getAllTableFileNames();
        final JList<String> table_list = new JList<String>(str_t_list);
        table_list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                int index = table_list.getSelectedIndex();
                ConglomerateViewPane.this.current_table = ConglomerateViewPane.this.conglomerate.getDiagnosticTable(str_t_list[index]);
                ConglomerateViewPane.this.view_pane.setDiagnosticModel(ConglomerateViewPane.this.current_table);
            }
        });
        JScrollPane scrolly_table_list = new JScrollPane(table_list);
        JSplitPane split_pane = new JSplitPane(1);
        split_pane.setLeftComponent(scrolly_table_list);
        split_pane.setRightComponent(this.view_pane);
        c.add((Component)split_pane, "Center");
    }

    private class DTableModel
    extends AbstractTableModel {
        private RawDiagnosticTable diag_table;

        public DTableModel(RawDiagnosticTable diag_table) {
            this.diag_table = diag_table;
        }

        public int getRowCount() {
            return this.diag_table.physicalRecordCount();
        }

        public int getColumnCount() {
            return this.diag_table.getDataTableDef().columnCount() + 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "Num";
            }
            if (col == 1) {
                return "State";
            }
            return this.diag_table.getDataTableDef().columnAt(col - 2).getName();
        }

        public Object getValueAt(int row, int col) {
            try {
                if (col == 0) {
                    return new Integer(row);
                }
                if (col == 1) {
                    int type = this.diag_table.recordState(row);
                    if (type == 1) {
                        return "U";
                    }
                    if (type == 2) {
                        return "CA";
                    }
                    if (type == 3) {
                        return "CR";
                    }
                    if (type == 4) {
                        return "D";
                    }
                    return "#ERROR#";
                }
                return this.diag_table.getCellContents(col - 2, row).getObject();
            }
            catch (Throwable e) {
                return "#ERROR:" + e.getMessage() + "#";
            }
        }
    }

    private class StoreViewPane
    extends JPanel {
        private JTable table;

        public StoreViewPane() {
            this.setLayout(new BorderLayout());
            this.table = new JTable();
            this.add(new JScrollPane(this.table));
        }

        void setDiagnosticModel(RawDiagnosticTable model) {
            this.table.setModel(new DTableModel(model));
        }
    }
}

