/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.store;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;

public class StreamFile {
    private final File file;
    private RandomAccessFile data;
    private long end_pointer;
    private OutputStream output_stream;

    public StreamFile(File file, String mode) throws IOException {
        this.file = file;
        this.data = new RandomAccessFile(file, mode);
        this.end_pointer = this.data.length();
        this.output_stream = new SFOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.data;
        synchronized (randomAccessFile) {
            this.data.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() throws IOException {
        RandomAccessFile randomAccessFile = this.data;
        synchronized (randomAccessFile) {
            try {
                this.data.getFD().sync();
            }
            catch (SyncFailedException syncFailedException) {
                // empty catch block
            }
        }
    }

    public void delete() throws IOException {
        this.file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(long position, byte[] buf, int off, int len) throws IOException {
        RandomAccessFile randomAccessFile = this.data;
        synchronized (randomAccessFile) {
            this.data.seek(position);
            int to_read = len;
            while (to_read > 0) {
                int read = this.data.read(buf, off, to_read);
                to_read -= read;
                off += read;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() {
        RandomAccessFile randomAccessFile = this.data;
        synchronized (randomAccessFile) {
            return this.end_pointer;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.output_stream;
    }

    public InputStream getInputStream() throws IOException {
        return new SFInputStream();
    }

    class SFInputStream
    extends InputStream {
        private long fp = 0L;

        SFInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            RandomAccessFile randomAccessFile = StreamFile.this.data;
            synchronized (randomAccessFile) {
                if (this.fp >= StreamFile.this.end_pointer) {
                    return -1;
                }
                StreamFile.this.data.seek(this.fp);
                ++this.fp;
                return StreamFile.this.data.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] buf, int off, int len) throws IOException {
            RandomAccessFile randomAccessFile = StreamFile.this.data;
            synchronized (randomAccessFile) {
                if (len == 0) {
                    return 0;
                }
                if ((len = (int)Math.min((long)len, StreamFile.this.end_pointer - this.fp)) <= 0) {
                    return -1;
                }
                StreamFile.this.data.seek(this.fp);
                int act_read = StreamFile.this.data.read(buf, off, len);
                this.fp += (long)act_read;
                return act_read;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long v) throws IOException {
            RandomAccessFile randomAccessFile = StreamFile.this.data;
            synchronized (randomAccessFile) {
                this.fp += v;
            }
            return v;
        }
    }

    class SFOutputStream
    extends OutputStream {
        SFOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int i) throws IOException {
            RandomAccessFile randomAccessFile = StreamFile.this.data;
            synchronized (randomAccessFile) {
                StreamFile.this.data.seek(StreamFile.this.end_pointer);
                StreamFile.this.data.write(i);
                ++StreamFile.this.end_pointer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int off, int len) throws IOException {
            if (len > 0) {
                RandomAccessFile randomAccessFile = StreamFile.this.data;
                synchronized (randomAccessFile) {
                    StreamFile.this.data.seek(StreamFile.this.end_pointer);
                    StreamFile.this.data.write(buf, off, len);
                    StreamFile.this.end_pointer += len;
                }
            }
        }
    }
}

