/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.store;

import com.mckoi.debug.DebugLogger;
import com.mckoi.store.JournalledResource;
import com.mckoi.store.JournalledSystem;
import com.mckoi.store.ScatteringStoreDataAccessor;
import com.mckoi.store.StoreDataAccessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class LoggingBufferManager {
    private static boolean PARANOID_CHECKS = false;
    private long current_T;
    private int current_page_count;
    private ArrayList page_list;
    private final Object T_lock = new Object();
    private final BMPage[] page_map;
    private int unique_id_seq;
    private JournalledSystem journalled_system;
    private final int max_pages;
    private final int page_size;
    private boolean check_point_in_progress;
    private int write_lock_count;
    private final Object write_lock = new Object();
    private final Comparator PAGE_CACHE_COMPARATOR = new Comparator(){

        private final float pageEnumValue(BMPage page) {
            long bounded_page_count = Math.min(page.access_count, 10000);
            float v = 1.0f / (float)bounded_page_count * (float)(LoggingBufferManager.this.current_T - page.t);
            return v;
        }

        public int compare(Object ob1, Object ob2) {
            float v2;
            float v1 = this.pageEnumValue((BMPage)ob1);
            if (v1 > (v2 = this.pageEnumValue((BMPage)ob2))) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }
    };

    public LoggingBufferManager(File journal_path, boolean read_only, int max_pages, int page_size, StoreDataAccessorFactory sda_factory, DebugLogger debug, boolean enable_logging) {
        this.max_pages = max_pages;
        this.page_size = page_size;
        this.check_point_in_progress = false;
        this.write_lock_count = 0;
        this.current_T = 0L;
        this.page_list = new ArrayList();
        this.page_map = new BMPage[257];
        this.unique_id_seq = 0;
        this.journalled_system = new JournalledSystem(journal_path, read_only, page_size, sda_factory, debug, enable_logging);
    }

    public LoggingBufferManager(final File resource_path, File journal_path, boolean read_only, int max_pages, int page_size, final String file_ext, final long max_slice_size, DebugLogger debug, boolean enable_logging) {
        this(journal_path, read_only, max_pages, page_size, new StoreDataAccessorFactory(){

            public StoreDataAccessor createStoreDataAccessor(String resource_name) {
                return new ScatteringStoreDataAccessor(resource_path, resource_name, file_ext, max_slice_size);
            }
        }, debug, enable_logging);
    }

    public void start() throws IOException {
        this.journalled_system.start();
    }

    public void stop() throws IOException {
        this.journalled_system.stop();
    }

    JournalledResource createResource(String resource_name) {
        return this.journalled_system.createResource(resource_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockForWrite() throws InterruptedException {
        Object object = this.write_lock;
        synchronized (object) {
            while (this.check_point_in_progress) {
                this.write_lock.wait();
            }
            ++this.write_lock_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockForWrite() {
        Object object = this.write_lock;
        synchronized (object) {
            --this.write_lock_count;
            this.write_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckPoint(boolean flush_journals) throws IOException, InterruptedException {
        BMPage[] bMPageArray = this.write_lock;
        synchronized (this.write_lock) {
            Object object;
            while (this.write_lock_count > 0) {
                this.write_lock.wait();
            }
            this.check_point_in_progress = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                bMPageArray = this.page_map;
                synchronized (this.page_map) {
                    for (int i = 0; i < this.page_map.length; ++i) {
                        BMPage page = this.page_map[i];
                        BMPage prev = null;
                        while (page != null) {
                            boolean deleted_hash = false;
                            BMPage bMPage = page;
                            synchronized (bMPage) {
                                page.flush();
                                if (page.notInUse()) {
                                    deleted_hash = true;
                                    if (prev == null) {
                                        this.page_map[i] = page.hash_next;
                                    } else {
                                        prev.hash_next = page.hash_next;
                                    }
                                }
                            }
                            if (!deleted_hash) {
                                prev = page;
                            }
                            page = page.hash_next;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    this.journalled_system.setCheckPoint(flush_journals);
                    Object var11_11 = null;
                    object = this.write_lock;
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                Object object2 = this.write_lock;
                synchronized (object2) {
                    this.check_point_in_progress = false;
                    this.write_lock.notifyAll();
                }
                throw throwable;
            }
            {
                synchronized (object) {
                    this.check_point_in_progress = false;
                    this.write_lock.notifyAll();
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageCreated(BMPage page) throws IOException {
        Object object = this.T_lock;
        synchronized (object) {
            int i;
            if (PARANOID_CHECKS && (i = this.page_list.indexOf(page)) != -1) {
                BMPage f = (BMPage)this.page_list.get(i);
                if (f == page) {
                    throw new Error("Same page added multiple times.");
                }
                if (f != null) {
                    throw new Error("Duplicate pages.");
                }
            }
            page.t = this.current_T++;
            ++this.current_page_count;
            this.page_list.add(page);
            if (this.current_page_count > this.max_pages) {
                int i2;
                Object[] pages = this.page_list.toArray();
                Arrays.sort(pages, this.PAGE_CACHE_COMPARATOR);
                int purge_size = Math.max((int)((float)pages.length * 0.2f), 2);
                for (i2 = 0; i2 < purge_size; ++i2) {
                    BMPage dpage;
                    BMPage bMPage = dpage = (BMPage)pages[pages.length - (i2 + 1)];
                    synchronized (bMPage) {
                        dpage.dispose();
                        continue;
                    }
                }
                this.page_list.clear();
                for (i2 = 0; i2 < pages.length - purge_size; ++i2) {
                    this.page_list.add(pages[i2]);
                }
                this.current_page_count -= purge_size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageAccessed(BMPage page) {
        Object object = this.T_lock;
        synchronized (object) {
            page.t = this.current_T++;
            ++page.access_count;
        }
    }

    private static int calcHashCode(long id, long page_number) {
        return (int)((id << 6) + page_number * (id + 25L << 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BMPage fetchPage(JournalledResource data, long page_number) throws IOException {
        long id = data.getID();
        BMPage prev_page = null;
        boolean new_page = false;
        BMPage[] bMPageArray = this.page_map;
        synchronized (this.page_map) {
            int p = (LoggingBufferManager.calcHashCode(id, page_number) & Integer.MAX_VALUE) % this.page_map.length;
            BMPage page = this.page_map[p];
            while (page != null && !page.isPage(id, page_number)) {
                prev_page = page;
                page = page.hash_next;
            }
            if (page == null) {
                page = new BMPage(data, page_number, this.page_size);
                page.hash_next = this.page_map[p];
                this.page_map[p] = page;
            } else if (prev_page != null) {
                prev_page.hash_next = page.hash_next;
                page.hash_next = this.page_map[p];
                this.page_map[p] = page;
            }
            BMPage bMPage = page;
            synchronized (bMPage) {
                if (page.notInUse()) {
                    page.reset();
                    new_page = true;
                    page.referenceAdd();
                }
                page.referenceAdd();
            }
            // ** MonitorExit[var9_6] (shouldn't be in output)
            if (new_page) {
                this.pageCreated(page);
            } else {
                this.pageAccessed(page);
            }
            return page;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readByteFrom(JournalledResource data, long position) throws IOException {
        int v;
        BMPage page;
        long page_number = position / (long)this.page_size;
        BMPage bMPage = page = this.fetchPage(data, page_number);
        synchronized (bMPage) {
            try {
                page.initialize();
                v = page.read((int)(position % (long)this.page_size)) & 0xFF;
            }
            finally {
                page.dispose();
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readByteArrayFrom(JournalledResource data, long position, byte[] buf, int off, int len) throws IOException {
        BMPage page;
        int orig_len = len;
        long page_number = position / (long)this.page_size;
        int start_offset = (int)(position % (long)this.page_size);
        int to_read = Math.min(len, this.page_size - start_offset);
        BMPage bMPage = page = this.fetchPage(data, page_number);
        synchronized (bMPage) {
            try {
                page.initialize();
                page.read(start_offset, buf, off, to_read);
            }
            finally {
                page.dispose();
            }
        }
        len -= to_read;
        while (len > 0) {
            off += to_read;
            position += (long)to_read;
            to_read = Math.min(len, this.page_size);
            bMPage = page = this.fetchPage(data, ++page_number);
            synchronized (bMPage) {
                try {
                    page.initialize();
                    page.read(0, buf, off, to_read);
                }
                finally {
                    page.dispose();
                }
            }
            len -= to_read;
        }
        return orig_len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeByteTo(JournalledResource data, long position, int b) throws IOException {
        BMPage page;
        if (PARANOID_CHECKS) {
            Object object = this.write_lock;
            synchronized (object) {
                if (this.write_lock_count == 0) {
                    System.out.println("Write without a lock!");
                    new Error().printStackTrace();
                }
            }
        }
        long page_number = position / (long)this.page_size;
        BMPage bMPage = page = this.fetchPage(data, page_number);
        synchronized (bMPage) {
            try {
                page.initialize();
                page.write((int)(position % (long)this.page_size), (byte)b);
            }
            finally {
                page.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeByteArrayTo(JournalledResource data, long position, byte[] buf, int off, int len) throws IOException {
        BMPage page;
        if (PARANOID_CHECKS) {
            Object object = this.write_lock;
            synchronized (object) {
                if (this.write_lock_count == 0) {
                    System.out.println("Write without a lock!");
                    new Error().printStackTrace();
                }
            }
        }
        long page_number = position / (long)this.page_size;
        int start_offset = (int)(position % (long)this.page_size);
        int to_write = Math.min(len, this.page_size - start_offset);
        BMPage bMPage = page = this.fetchPage(data, page_number);
        synchronized (bMPage) {
            try {
                page.initialize();
                page.write(start_offset, buf, off, to_write);
            }
            finally {
                page.dispose();
            }
        }
        len -= to_write;
        while (len > 0) {
            off += to_write;
            position += (long)to_write;
            to_write = Math.min(len, this.page_size);
            bMPage = page = this.fetchPage(data, ++page_number);
            synchronized (bMPage) {
                try {
                    page.initialize();
                    page.write(0, buf, off, to_write);
                }
                finally {
                    page.dispose();
                }
            }
            len -= to_write;
        }
    }

    void setDataAreaSize(JournalledResource data, long new_size) throws IOException {
        data.setSize(new_size);
    }

    long getDataAreaSize(JournalledResource data) throws IOException {
        return data.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(JournalledResource data) throws IOException {
        long id = data.getID();
        BMPage[] bMPageArray = this.page_map;
        synchronized (this.page_map) {
            for (int i = 0; i < this.page_map.length; ++i) {
                BMPage page = this.page_map[i];
                BMPage prev = null;
                while (page != null) {
                    boolean deleted_hash = false;
                    if (page.getID() == id) {
                        BMPage bMPage = page;
                        synchronized (bMPage) {
                            page.flush();
                            if (page.notInUse()) {
                                deleted_hash = true;
                                if (prev == null) {
                                    this.page_map[i] = page.hash_next;
                                } else {
                                    prev.hash_next = page.hash_next;
                                }
                            }
                        }
                    }
                    if (!deleted_hash) {
                        prev = page;
                    }
                    page = page.hash_next;
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            data.close();
            return;
        }
    }

    public static interface StoreDataAccessorFactory {
        public StoreDataAccessor createStoreDataAccessor(String var1);
    }

    private static class BResource {
        private final long id;
        private final String name;

        BResource(long id, String name) {
            this.id = id;
            this.name = name;
        }

        long getID() {
            return this.id;
        }

        String getName() {
            return this.name;
        }
    }

    private static final class BMPage {
        private final JournalledResource data;
        private final long page;
        private final int page_size;
        private byte[] buffer;
        private boolean initialized;
        BMPage hash_next;
        long t;
        int access_count;
        private int first_write_position;
        private int last_write_position;
        private int reference_count;

        BMPage(JournalledResource data, long page, int page_size) {
            this.data = data;
            this.page = page;
            this.reference_count = 0;
            this.page_size = page_size;
            this.reset();
        }

        void reset() {
            if (this.reference_count != 0) {
                throw new Error("reset when 'reference_count' is != 0 ( = " + this.reference_count + " )");
            }
            this.initialized = false;
            this.t = 0L;
            this.access_count = 0;
        }

        long getID() {
            return this.data.getID();
        }

        void referenceAdd() {
            ++this.reference_count;
        }

        private void referenceRemove() {
            if (this.reference_count <= 0) {
                throw new Error("Too many reference remove.");
            }
            --this.reference_count;
        }

        boolean notInUse() {
            return this.reference_count == 0;
        }

        boolean isPage(long in_id, long in_page) {
            return this.getID() == in_id && this.page == in_page;
        }

        private void readPageContent(long page_number, byte[] buf, int pos) throws IOException {
            if (pos != 0) {
                throw new Error("Assert failed: pos != 0");
            }
            this.data.read(page_number, buf, pos);
        }

        void flush() throws IOException {
            if (this.initialized) {
                if (this.last_write_position > -1) {
                    this.data.write(this.page, this.buffer, this.first_write_position, this.last_write_position - this.first_write_position);
                }
                this.first_write_position = Integer.MAX_VALUE;
                this.last_write_position = -1;
            }
        }

        void initialize() throws IOException {
            if (!this.initialized) {
                try {
                    this.buffer = new byte[this.page_size];
                    this.readPageContent(this.page, this.buffer, 0);
                    this.initialized = true;
                    this.first_write_position = Integer.MAX_VALUE;
                    this.last_write_position = -1;
                }
                catch (IOException e) {
                    System.out.println("IO Error during page initialize: " + e.getMessage());
                    e.printStackTrace();
                    throw e;
                }
            }
        }

        void dispose() throws IOException {
            this.referenceRemove();
            if (this.reference_count == 0) {
                if (this.initialized) {
                    this.flush();
                    this.initialized = false;
                    this.buffer = null;
                } else {
                    this.buffer = null;
                }
            }
        }

        byte read(int pos) {
            return this.buffer[pos];
        }

        void read(int pos, byte[] buf, int off, int len) {
            System.arraycopy(this.buffer, pos, buf, off, len);
        }

        void write(int pos, byte v) {
            this.first_write_position = Math.min(pos, this.first_write_position);
            this.last_write_position = Math.max(pos + 1, this.last_write_position);
            this.buffer[pos] = v;
        }

        void write(int pos, byte[] buf, int off, int len) {
            this.first_write_position = Math.min(pos, this.first_write_position);
            this.last_write_position = Math.max(pos + len, this.last_write_position);
            System.arraycopy(buf, off, this.buffer, pos, len);
        }

        public boolean equals(Object ob) {
            BMPage dest_page = (BMPage)ob;
            return this.isPage(dest_page.getID(), dest_page.page);
        }
    }
}

