/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.store;

import com.mckoi.debug.DebugLogger;
import com.mckoi.store.JournalledResource;
import com.mckoi.store.LoggingBufferManager;
import com.mckoi.store.StoreDataAccessor;
import com.mckoi.store.StreamFile;
import com.mckoi.util.ByteArrayUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

class JournalledSystem {
    private final boolean ENABLE_LOGGING;
    private final File journal_path;
    private final boolean read_only;
    private final int page_size;
    private HashMap all_resources;
    private long seq_id;
    private final ArrayList journal_archives;
    private JournalFile top_journal_file;
    private long journal_number;
    private final LoggingBufferManager.StoreDataAccessorFactory sda_factory;
    private final Object top_journal_lock = new Object();
    private JournalingThread journaling_thread;
    private final DebugLogger debug;
    private final Object init_lock = new Object();
    private Comparator journal_list_comparator = new Comparator(){

        public int compare(Object ob1, Object ob2) {
            long jn2;
            JournalSummary js1 = (JournalSummary)ob1;
            JournalSummary js2 = (JournalSummary)ob2;
            long jn1 = js1.journal_file.getJournalNumber();
            if (jn1 > (jn2 = js2.journal_file.getJournalNumber())) {
                return 1;
            }
            if (jn1 < jn2) {
                return -1;
            }
            return 0;
        }
    };

    JournalledSystem(File journal_path, boolean read_only, int page_size, LoggingBufferManager.StoreDataAccessorFactory sda_factory, DebugLogger debug, boolean enable_logging) {
        this.journal_path = journal_path;
        this.read_only = read_only;
        this.page_size = page_size;
        this.sda_factory = sda_factory;
        this.all_resources = new HashMap();
        this.journal_number = 0L;
        this.journal_archives = new ArrayList();
        this.debug = debug;
        this.ENABLE_LOGGING = enable_logging;
    }

    private static String getJournalFileName(int number) {
        if (number < 10 || number > 73) {
            throw new Error("Journal file name out of range.");
        }
        return "jnl" + number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws IOException {
        if (this.ENABLE_LOGGING) {
            Object object = this.init_lock;
            synchronized (object) {
                if (this.journaling_thread == null) {
                    this.journaling_thread = new JournalingThread();
                    this.journaling_thread.start();
                    this.rollForwardRecover();
                    if (!this.read_only) {
                        this.newTopJournalFile();
                    }
                } else {
                    throw new Error("Assertion failed - already started.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws IOException {
        if (this.ENABLE_LOGGING) {
            Object object = this.init_lock;
            synchronized (object) {
                if (this.journaling_thread == null) {
                    throw new Error("Assertion failed - already stopped.");
                }
                this.journaling_thread.persistArchives(0);
                this.journaling_thread.finish();
                this.journaling_thread.waitUntilFinished();
                this.journaling_thread = null;
            }
            if (!this.read_only) {
                object = this.top_journal_lock;
                synchronized (object) {
                    int sz = this.journal_archives.size();
                    for (int i = 0; i < sz; ++i) {
                        JournalFile jf = (JournalFile)this.journal_archives.get(i);
                        jf.close();
                    }
                    this.topJournal().close();
                    this.rollForwardRecover();
                }
            }
        }
    }

    void rollForwardRecover() throws IOException {
        ArrayList<JournalSummary> journal_files_list = new ArrayList<JournalSummary>();
        for (int i = 10; i < 74; ++i) {
            String journal_fn = JournalledSystem.getJournalFileName(i);
            File f = new File(this.journal_path, journal_fn);
            if (!f.exists()) continue;
            if (this.read_only) {
                throw new IOException("Journal file " + f + " exists for a read-only session.  " + "There may not be any pending journals for a read-only session.");
            }
            JournalFile jf = new JournalFile(f, this.read_only);
            JournalSummary summary = jf.openForRecovery();
            if (summary.can_be_recovered) {
                if (this.debug.isInterestedIn(10)) {
                    this.debug.write(10, this, "Journal " + jf + " found - can be recovered.");
                }
                journal_files_list.add(summary);
                continue;
            }
            if (this.debug.isInterestedIn(10)) {
                this.debug.write(10, this, "Journal " + jf + " deleting - nothing to recover.");
            }
            jf.closeAndDelete();
        }
        Collections.sort(journal_files_list, this.journal_list_comparator);
        long last_journal_number = -1L;
        for (int i = 0; i < journal_files_list.size(); ++i) {
            JournalSummary summary = (JournalSummary)journal_files_list.get(i);
            ArrayList res_list = summary.resource_list;
            for (int n = 0; n < res_list.size(); ++n) {
                String resource_name = (String)res_list.get(n);
                JournalledResource resource = this.createResource(resource_name);
            }
            JournalFile jf = summary.journal_file;
            if (jf.journal_number < last_journal_number) {
                throw new Error("Assertion failed, sort failed.");
            }
            last_journal_number = jf.journal_number;
            if (this.debug.isInterestedIn(10)) {
                this.debug.write(10, this, "Recovering: " + jf + " (8 .. " + summary.last_checkpoint + ")");
            }
            jf.persist(8L, summary.last_checkpoint);
            jf.closeAndDelete();
            for (int n = 0; n < res_list.size(); ++n) {
                String resource_name = (String)res_list.get(n);
                AbstractResource resource = (AbstractResource)this.createResource(resource_name);
                resource.persistClose();
                resource.notifyPostRecover();
            }
        }
    }

    private void newTopJournalFile() throws IOException {
        String journal_fn = JournalledSystem.getJournalFileName((int)((this.journal_number & 0x3FL) + 10L));
        ++this.journal_number;
        File f = new File(this.journal_path, journal_fn);
        if (f.exists()) {
            throw new IOException("Journal file already exists.");
        }
        this.top_journal_file = new JournalFile(f, this.read_only);
        this.top_journal_file.open(this.journal_number - 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JournalFile topJournal() {
        Object object = this.top_journal_lock;
        synchronized (object) {
            return this.top_journal_file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JournalledResource createResource(String resource_name) {
        AbstractResource resource;
        HashMap hashMap = this.all_resources;
        synchronized (hashMap) {
            resource = (AbstractResource)this.all_resources.get(resource_name);
            if (resource == null) {
                long id = this.seq_id++;
                StoreDataAccessor accessor = this.sda_factory.createStoreDataAccessor(resource_name);
                resource = this.ENABLE_LOGGING ? new Resource(resource_name, id, accessor) : new NonLoggingResource(resource_name, id, accessor);
                this.all_resources.put(resource_name, resource);
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCheckPoint(boolean flush_journals) throws IOException {
        boolean something_to_persist;
        if (!this.ENABLE_LOGGING) {
            return;
        }
        if (this.read_only) {
            return;
        }
        Object object = this.top_journal_lock;
        synchronized (object) {
            JournalFile top_j = this.topJournal();
            if (flush_journals || top_j.size() > 262144L) {
                this.newTopJournalFile();
                this.journal_archives.add(top_j);
            }
            something_to_persist = this.journal_archives.size() > 0;
            top_j.setCheckPoint();
        }
        if (something_to_persist) {
            this.journaling_thread.persistArchives(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractResource getResource(String resource_name) {
        HashMap hashMap = this.all_resources;
        synchronized (hashMap) {
            return (AbstractResource)this.all_resources.get(resource_name);
        }
    }

    private class JournalingThread
    extends Thread {
        private boolean finished = false;
        private boolean actually_finished;

        JournalingThread() {
            this.setName("Mckoi - Background Journaling");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean local_finished = false;
            while (!local_finished) {
                ArrayList to_process = null;
                Object object = JournalledSystem.this.top_journal_lock;
                synchronized (object) {
                    if (JournalledSystem.this.journal_archives.size() > 0) {
                        to_process = new ArrayList();
                        to_process.addAll(JournalledSystem.this.journal_archives);
                    }
                }
                if (to_process == null) {
                    object = this;
                    synchronized (object) {
                        if (!this.finished) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (to_process.size() > 0) {
                    int sz = to_process.size();
                    for (int i = 0; i < sz; ++i) {
                        JournalFile jf = (JournalFile)to_process.get(i);
                        try {
                            jf.persist(8L, jf.size());
                            jf.closeAndDelete();
                            continue;
                        }
                        catch (IOException e) {
                            JournalledSystem.this.debug.write(40, this, "Error persisting journal: " + jf);
                            JournalledSystem.this.debug.writeException(40, e);
                            JournalingThread journalingThread = this;
                            synchronized (journalingThread) {
                                this.finished = true;
                                continue;
                            }
                        }
                    }
                }
                object = this;
                synchronized (object) {
                    local_finished = this.finished;
                    if (to_process != null) {
                        Object object2 = JournalledSystem.this.top_journal_lock;
                        synchronized (object2) {
                            int sz = to_process.size();
                            for (int i = 0; i < sz; ++i) {
                                JournalledSystem.this.journal_archives.remove(0);
                            }
                        }
                    }
                    this.notifyAll();
                }
            }
            JournalingThread journalingThread = this;
            synchronized (journalingThread) {
                this.actually_finished = true;
                this.notifyAll();
            }
        }

        public synchronized void finish() {
            this.finished = true;
            this.notifyAll();
        }

        public synchronized void waitUntilFinished() {
            try {
                while (!this.actually_finished) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new Error("Interrupted: " + e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void persistArchives(int until_size) {
            int sz;
            this.notifyAll();
            Object object = JournalledSystem.this.top_journal_lock;
            synchronized (object) {
                sz = JournalledSystem.this.journal_archives.size();
            }
            while (sz > until_size) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                object = JournalledSystem.this.top_journal_lock;
                synchronized (object) {
                    sz = JournalledSystem.this.journal_archives.size();
                }
            }
        }
    }

    private static class JournalSummary {
        JournalFile journal_file;
        boolean can_be_recovered = false;
        long last_checkpoint;
        ArrayList resource_list = new ArrayList();

        public JournalSummary(JournalFile journal_file) {
            this.journal_file = journal_file;
        }
    }

    private final class Resource
    extends AbstractResource {
        private long size;
        private boolean there_is_backing_data;
        private boolean really_open;
        private boolean data_exists;
        private boolean data_open = false;
        private boolean data_deleted;
        private final JournalEntry[] journal_map = new JournalEntry[257];
        private final byte[] page_buffer;

        Resource(String name, long id, StoreDataAccessor data) {
            super(name, id, data);
            this.data_exists = data.exists();
            this.data_deleted = false;
            if (this.data_exists) {
                try {
                    this.size = data.getSize();
                }
                catch (IOException e) {
                    throw new Error("Error getting size of resource: " + e.getMessage());
                }
            }
            this.really_open = false;
            this.page_buffer = new byte[JournalledSystem.this.page_size];
        }

        private void persistOpen(boolean read_only) throws IOException {
            if (!this.really_open) {
                this.data.open(read_only);
                this.there_is_backing_data = true;
                this.really_open = true;
            }
        }

        void persistClose() throws IOException {
            if (this.really_open) {
                this.size = this.data.getSize();
                this.data.synch();
                this.data.close();
                this.really_open = false;
            }
        }

        public void persistDelete() throws IOException {
            if (this.really_open) {
                this.persistClose();
            }
            this.data.delete();
            this.there_is_backing_data = false;
        }

        public void persistSetSize(long new_size) throws IOException {
            if (!this.really_open) {
                this.persistOpen(false);
            }
            if (new_size > this.data.getSize()) {
                this.data.setSize(new_size);
            }
        }

        public void persistPageChange(long page, int off, int len, DataInputStream din) throws IOException {
            if (!this.really_open) {
                this.persistOpen(false);
            }
            byte[] buf = len <= this.page_buffer.length ? this.page_buffer : new byte[len];
            din.readFully(buf, 0, len);
            long pos = page * 8192L;
            this.data.write(pos + (long)off, buf, 0, len);
        }

        public void synch() throws IOException {
            if (this.really_open) {
                this.data.synch();
            }
        }

        public void notifyPostRecover() {
            this.data_exists = this.data.exists();
        }

        public void open(boolean read_only) throws IOException {
            this.read_only = read_only;
            if (!this.data_deleted && this.data.exists()) {
                this.persistOpen(read_only);
            } else {
                this.there_is_backing_data = false;
                this.data_deleted = false;
            }
            this.data_open = true;
            this.data_exists = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void read(long page_number, byte[] buf, int off) throws IOException {
            JournalEntry[] journalEntryArray = this.journal_map;
            synchronized (this.journal_map) {
                int i4;
                int sz3;
                if (!this.data_open) {
                    throw new IOException("Assertion failed: Data file is not open.");
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                ArrayList<JournalEntry> all_journal_entries = new ArrayList<JournalEntry>(4);
                try {
                    JournalEntry[] journalEntryArray2 = this.journal_map;
                    synchronized (this.journal_map) {
                        int i2 = (int)(page_number & 0xFFFFFFFL) % this.journal_map.length;
                        JournalEntry entry = this.journal_map[i2];
                        JournalEntry prev = null;
                        while (entry != null) {
                            boolean deleted_hash = false;
                            JournalFile file = entry.getJournalFile();
                            file.addReference();
                            if (file.isDeleted()) {
                                deleted_hash = true;
                                file.removeReference();
                                if (prev == null) {
                                    this.journal_map[i2] = entry.next_page;
                                } else {
                                    prev.next_page = entry.next_page;
                                }
                            } else if (entry.getPageNumber() == page_number) {
                                all_journal_entries.add(entry);
                            } else {
                                file.removeReference();
                            }
                            if (!deleted_hash) {
                                prev = entry;
                            }
                            entry = entry.next_page;
                        }
                        // ** MonitorExit[var6_5] (shouldn't be in output)
                        if (this.there_is_backing_data) {
                            long page_position = page_number * (long)JournalledSystem.this.page_size;
                            this.data.read(page_position, buf, off, JournalledSystem.this.page_size);
                        } else {
                            for (int i3 = off; i3 < JournalledSystem.this.page_size + off; ++i3) {
                                buf[i3] = 0;
                            }
                        }
                        int sz2 = all_journal_entries.size();
                        for (i2 = 0; i2 < sz2; ++i2) {
                            entry = (JournalEntry)all_journal_entries.get(i2);
                            JournalFile file = entry.getJournalFile();
                            long position = entry.getPosition();
                            JournalFile journalFile = file;
                            synchronized (journalFile) {
                                file.buildPage(page_number, position, buf, off);
                                continue;
                            }
                        }
                        Object var15_17 = null;
                        sz3 = all_journal_entries.size();
                        i4 = 0;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    int sz3 = all_journal_entries.size();
                    int i4 = 0;
                    while (true) {
                        if (i4 >= sz3) {
                            throw throwable;
                        }
                        JournalEntry entry = (JournalEntry)all_journal_entries.get(i4);
                        JournalFile file = entry.getJournalFile();
                        file.removeReference();
                        ++i4;
                    }
                }
                {
                    while (i4 < sz3) {
                        JournalEntry entry = (JournalEntry)all_journal_entries.get(i4);
                        JournalFile file = entry.getJournalFile();
                        file.removeReference();
                        ++i4;
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(long page_number, byte[] buf, int off, int len) throws IOException {
            JournalEntry[] journalEntryArray = this.journal_map;
            synchronized (this.journal_map) {
                JournalEntry journal;
                if (!this.data_open) {
                    throw new IOException("Assertion failed: Data file is not open.");
                }
                Object object = JournalledSystem.this.top_journal_lock;
                synchronized (object) {
                    journal = JournalledSystem.this.topJournal().logPageModification(this.name, page_number, buf, off, len);
                }
                int i = (int)(page_number & 0xFFFFFFFL) % this.journal_map.length;
                JournalEntry entry = this.journal_map[i];
                if (entry == null) {
                    this.journal_map[i] = journal;
                    journal.next_page = null;
                } else {
                    int journal_entry_count = 0;
                    while (entry.next_page != null) {
                        entry = entry.next_page;
                        ++journal_entry_count;
                    }
                    entry.next_page = journal;
                    journal.next_page = null;
                    if (journal_entry_count > 35) {
                        int entries_cleaned = 0;
                        entry = this.journal_map[i];
                        JournalEntry prev = null;
                        while (entry != null) {
                            boolean deleted_hash = false;
                            JournalFile file = entry.getJournalFile();
                            file.addReference();
                            if (file.isDeleted()) {
                                deleted_hash = true;
                                file.removeReference();
                                if (prev == null) {
                                    this.journal_map[i] = entry.next_page;
                                } else {
                                    prev.next_page = entry.next_page;
                                }
                                ++entries_cleaned;
                            }
                            file.removeReference();
                            if (!deleted_hash) {
                                prev = entry;
                            }
                            entry = entry.next_page;
                        }
                    }
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSize(long size) throws IOException {
            Object object = this.journal_map;
            synchronized (this.journal_map) {
                this.size = size;
                // ** MonitorExit[var3_2 /* !! */ ] (shouldn't be in output)
                object = JournalledSystem.this.top_journal_lock;
                synchronized (object) {
                    JournalledSystem.this.topJournal().logResourceSizeChange(this.name, size);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getSize() throws IOException {
            JournalEntry[] journalEntryArray = this.journal_map;
            synchronized (this.journal_map) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            JournalEntry[] journalEntryArray = this.journal_map;
            synchronized (this.journal_map) {
                this.data_open = false;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() throws IOException {
            JournalEntry[] journalEntryArray = JournalledSystem.this.top_journal_lock;
            synchronized (journalEntryArray) {
                JournalledSystem.this.topJournal().logResourceDelete(this.name);
            }
            journalEntryArray = this.journal_map;
            synchronized (this.journal_map) {
                this.data_exists = false;
                this.data_deleted = true;
                this.size = 0L;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public boolean exists() {
            return this.data_exists;
        }
    }

    private final class NonLoggingResource
    extends AbstractResource {
        NonLoggingResource(String name, long id, StoreDataAccessor data) {
            super(name, id, data);
        }

        void persistClose() throws IOException {
        }

        public void persistDelete() throws IOException {
        }

        public void persistSetSize(long new_size) throws IOException {
        }

        public void persistPageChange(long page, int off, int len, DataInputStream din) throws IOException {
        }

        public void synch() throws IOException {
            this.data.synch();
        }

        public void notifyPostRecover() {
        }

        public void open(boolean read_only) throws IOException {
            this.read_only = read_only;
            this.data.open(read_only);
        }

        public void read(long page_number, byte[] buf, int off) throws IOException {
            long page_position = page_number * (long)JournalledSystem.this.page_size;
            this.data.read(page_position + (long)off, buf, off, JournalledSystem.this.page_size);
        }

        public void write(long page_number, byte[] buf, int off, int len) throws IOException {
            long page_position = page_number * (long)JournalledSystem.this.page_size;
            this.data.write(page_position + (long)off, buf, off, len);
        }

        public void setSize(long size) throws IOException {
            this.data.setSize(size);
        }

        public long getSize() throws IOException {
            return this.data.getSize();
        }

        public void close() throws IOException {
            this.data.close();
        }

        public void delete() throws IOException {
            this.data.delete();
        }

        public boolean exists() {
            return this.data.exists();
        }
    }

    private abstract class AbstractResource
    implements JournalledResource {
        protected final String name;
        protected final long id;
        protected final StoreDataAccessor data;
        protected boolean read_only;

        AbstractResource(String name, long id, StoreDataAccessor data) {
            this.name = name;
            this.id = id;
            this.data = data;
        }

        abstract void persistClose() throws IOException;

        abstract void persistDelete() throws IOException;

        abstract void persistSetSize(long var1) throws IOException;

        abstract void persistPageChange(long var1, int var3, int var4, DataInputStream var5) throws IOException;

        abstract void synch() throws IOException;

        abstract void notifyPostRecover();

        public int getPageSize() {
            return JournalledSystem.this.page_size;
        }

        public long getID() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class JournalEntry {
        private final String resource_name;
        private final JournalFile journal;
        private final long position;
        private final long page_number;
        JournalEntry next_page;

        public JournalEntry(String resource_name, JournalFile journal, long position, long page_number) {
            this.resource_name = resource_name;
            this.journal = journal;
            this.position = position;
            this.page_number = page_number;
        }

        public JournalFile getJournalFile() {
            return this.journal;
        }

        public long getPosition() {
            return this.position;
        }

        public long getPageNumber() {
            return this.page_number;
        }
    }

    private final class JournalFile {
        private File file;
        private boolean read_only;
        private StreamFile data;
        private DataOutputStream data_out;
        private byte[] buffer;
        private HashMap resource_id_map;
        private long cur_seq_id;
        private long journal_number;
        private boolean is_open;
        private int reference_count;

        public JournalFile(File file, boolean read_only) {
            this.file = file;
            this.read_only = read_only;
            this.is_open = false;
            this.buffer = new byte[36];
            this.resource_id_map = new HashMap();
            this.cur_seq_id = 0L;
            this.reference_count = 1;
        }

        long size() {
            return this.data.length();
        }

        long getJournalNumber() {
            return this.journal_number;
        }

        void open(long journal_number) throws IOException {
            if (this.is_open) {
                throw new IOException("Journal file is already open.");
            }
            if (this.file.exists()) {
                throw new IOException("Journal file already exists.");
            }
            this.journal_number = journal_number;
            this.data = new StreamFile(this.file, this.read_only ? "r" : "rw");
            this.data_out = new DataOutputStream(new BufferedOutputStream(this.data.getOutputStream()));
            this.data_out.writeLong(journal_number);
            this.is_open = true;
        }

        /*
         * Unable to fully structure code
         */
        JournalSummary openForRecovery() throws IOException {
            if (this.is_open) {
                throw new IOException("Journal file is already open.");
            }
            if (!this.file.exists()) {
                throw new IOException("Journal file does not exists.");
            }
            this.data = new StreamFile(this.file, this.read_only != false ? "r" : "rw");
            this.is_open = true;
            summary = new JournalSummary(this);
            end_pointer = this.data.length();
            if (end_pointer < 8L) {
                return summary;
            }
            din = new DataInputStream(new BufferedInputStream(this.data.getInputStream()));
            try {
                this.journal_number = din.readLong();
                position = 8L;
                checkpoint_res_list = new ArrayList<String>();
                block5: while (true) {
                    if (position + 12L > end_pointer) {
                        var8_7 = summary;
                        return var8_7;
                    }
                    type = din.readLong();
                    size = din.readInt();
                    position = position + (long)size + 12L;
                    skip_body = true;
                    if (type == 100L) {
                        summary.last_checkpoint = position;
                        summary.can_be_recovered = true;
                        summary.resource_list.addAll(checkpoint_res_list);
                        checkpoint_res_list.clear();
                    } else if (position >= end_pointer || type < 1L || type > 7L) {
                        var12_10 = summary;
                        return var12_10;
                    }
                    if (type == 2L) {
                        skip_body = false;
                        id = din.readLong();
                        str_len = din.readInt();
                        str = new StringBuffer(str_len);
                        for (i = 0; i < str_len; ++i) {
                            str.append(din.readChar());
                        }
                        resource_name = new String(str);
                        checkpoint_res_list.add(resource_name);
                    }
                    if (!skip_body) continue;
                    to_skip = size;
                    while (true) {
                        if (to_skip > 0) ** break;
                        continue block5;
                        to_skip = (int)((long)to_skip - din.skip(to_skip));
                    }
                    break;
                }
            }
            finally {
                din.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws IOException {
            JournalFile journalFile = this;
            synchronized (journalFile) {
                if (!this.is_open) {
                    throw new IOException("Journal file is already closed.");
                }
                this.data.close();
                this.data = null;
                this.is_open = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isDeleted() {
            JournalFile journalFile = this;
            synchronized (journalFile) {
                return this.data == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeAndDelete() throws IOException {
            JournalFile journalFile = this;
            synchronized (journalFile) {
                --this.reference_count;
                if (this.reference_count == 0) {
                    this.close();
                    boolean b = this.file.delete();
                    if (!b) {
                        System.out.println("Unable to delete journal file: " + this.file);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addReference() {
            JournalFile journalFile = this;
            synchronized (journalFile) {
                if (this.reference_count != 0) {
                    ++this.reference_count;
                }
            }
        }

        void removeReference() throws IOException {
            this.closeAndDelete();
        }

        void persist(long start, long end) throws IOException {
            if (JournalledSystem.this.debug.isInterestedIn(10)) {
                JournalledSystem.this.debug.write(10, this, "Persisting: " + this.file);
            }
            DataInputStream din = new DataInputStream(new BufferedInputStream(this.data.getInputStream()));
            for (long count = start; count > 0L; count -= din.skip(count)) {
            }
            ArrayList<AbstractResource> resources_updated = new ArrayList<AbstractResource>();
            HashMap<Long, String> id_name_map = new HashMap<Long, String>();
            boolean finished = false;
            long position = start;
            while (!finished) {
                long id;
                long type = din.readLong();
                int size = din.readInt();
                position = position + (long)size + 12L;
                if (type == 2L) {
                    id = din.readLong();
                    int len = din.readInt();
                    StringBuffer buf = new StringBuffer(len);
                    for (int i = 0; i < len; ++i) {
                        buf.append(din.readChar());
                    }
                    String resource_name = new String(buf);
                    id_name_map.put(new Long(id), resource_name);
                    if (JournalledSystem.this.debug.isInterestedIn(10)) {
                        JournalledSystem.this.debug.write(10, this, "Journal Command: Tag: " + id + " = " + resource_name);
                    }
                    resources_updated.add(JournalledSystem.this.getResource(resource_name));
                    continue;
                }
                if (type == 6L) {
                    id = din.readLong();
                    String resource_name = (String)id_name_map.get(new Long(id));
                    AbstractResource resource = JournalledSystem.this.getResource(resource_name);
                    if (JournalledSystem.this.debug.isInterestedIn(10)) {
                        JournalledSystem.this.debug.write(10, this, "Journal Command: Delete: " + resource_name);
                    }
                    resource.persistDelete();
                    continue;
                }
                if (type == 3L) {
                    id = din.readLong();
                    long new_size = din.readLong();
                    String resource_name = (String)id_name_map.get(new Long(id));
                    AbstractResource resource = JournalledSystem.this.getResource(resource_name);
                    if (JournalledSystem.this.debug.isInterestedIn(10)) {
                        JournalledSystem.this.debug.write(10, this, "Journal Command: Set Size: " + resource_name + " size = " + new_size);
                    }
                    resource.persistSetSize(new_size);
                    continue;
                }
                if (type == 1L) {
                    id = din.readLong();
                    long page = din.readLong();
                    int off = din.readInt();
                    int len = din.readInt();
                    String resource_name = (String)id_name_map.get(new Long(id));
                    AbstractResource resource = JournalledSystem.this.getResource(resource_name);
                    if (JournalledSystem.this.debug.isInterestedIn(10)) {
                        JournalledSystem.this.debug.write(10, this, "Journal Command: Page Modify: " + resource_name + " page = " + page + " off = " + off + " len = " + len);
                    }
                    resource.persistPageChange(page, off, len, din);
                    continue;
                }
                if (type == 100L) {
                    if (JournalledSystem.this.debug.isInterestedIn(10)) {
                        JournalledSystem.this.debug.write(10, this, "Journal Command: Check Point.");
                    }
                    if (position != end) continue;
                    finished = true;
                    continue;
                }
                throw new Error("Unknown tag type: " + type + " position = " + position);
            }
            int sz = resources_updated.size();
            for (int i = 0; i < sz; ++i) {
                AbstractResource r = (AbstractResource)resources_updated.get(i);
                if (JournalledSystem.this.debug.isInterestedIn(10)) {
                    JournalledSystem.this.debug.write(10, this, "Synch: " + r);
                }
                r.synch();
            }
            din.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Long writeResourceName(String resource_name, DataOutputStream out) throws IOException {
            Long v;
            HashMap hashMap = this.resource_id_map;
            synchronized (hashMap) {
                v = (Long)this.resource_id_map.get(resource_name);
                if (v == null) {
                    ++this.cur_seq_id;
                    int len = resource_name.length();
                    out.writeLong(2L);
                    out.writeInt(12 + len * 2);
                    out.writeLong(this.cur_seq_id);
                    out.writeInt(len);
                    out.writeChars(resource_name);
                    v = new Long(this.cur_seq_id);
                    this.resource_id_map.put(resource_name, v);
                }
            }
            return v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void logResourceDelete(String resource_name) throws IOException {
            JournalFile journalFile = this;
            synchronized (journalFile) {
                Long v = this.writeResourceName(resource_name, this.data_out);
                long resource_id = v;
                this.data_out.writeLong(6L);
                this.data_out.writeInt(8);
                this.data_out.writeLong(resource_id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void logResourceSizeChange(String resource_name, long new_size) throws IOException {
            JournalFile journalFile = this;
            synchronized (journalFile) {
                Long v = this.writeResourceName(resource_name, this.data_out);
                long resource_id = v;
                this.data_out.writeLong(3L);
                this.data_out.writeInt(16);
                this.data_out.writeLong(resource_id);
                this.data_out.writeLong(new_size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setCheckPoint() throws IOException {
            JournalFile journalFile = this;
            synchronized (journalFile) {
                this.data_out.writeLong(100L);
                this.data_out.writeInt(0);
                this.flushAndSynch();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JournalEntry logPageModification(String resource_name, long page_number, byte[] buf, int off, int len) throws IOException {
            long ref;
            JournalFile journalFile = this;
            synchronized (journalFile) {
                Long v = this.writeResourceName(resource_name, this.data_out);
                long absolute_position = page_number * (long)JournalledSystem.this.page_size;
                long resource_id = v;
                this.data_out.writeLong(1L);
                this.data_out.writeInt(24 + len);
                this.data_out.writeLong(resource_id);
                this.data_out.writeLong(absolute_position / 8192L);
                this.data_out.writeInt(off + (int)(absolute_position & 0x1FFFL));
                this.data_out.writeInt(len);
                this.data_out.write(buf, off, len);
                this.data_out.flush();
                ref = this.data.length() - (long)len - 36L;
            }
            return new JournalEntry(resource_name, this, ref, page_number);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void buildPage(long in_page_number, long position, byte[] buf, int off) throws IOException {
            JournalFile journalFile = this;
            synchronized (journalFile) {
                this.data.readFully(position, this.buffer, 0, 36);
                long type = ByteArrayUtil.getLong(this.buffer, 0);
                long resource_id = ByteArrayUtil.getLong(this.buffer, 12);
                long page_number = ByteArrayUtil.getLong(this.buffer, 20);
                int page_offset = ByteArrayUtil.getInt(this.buffer, 28);
                int page_length = ByteArrayUtil.getInt(this.buffer, 32);
                if (type != 1L) {
                    throw new IOException("Invalid page type. type = " + type + " pos = " + position);
                }
                if (page_number != in_page_number) {
                    throw new IOException("Page numbers do not match.");
                }
                this.data.readFully(position + 36L, buf, off + page_offset, page_length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flushAndSynch() throws IOException {
            JournalFile journalFile = this;
            synchronized (journalFile) {
                this.data_out.flush();
                this.data.synch();
            }
        }

        public String toString() {
            return "[JOURNAL: " + this.file.getName() + "]";
        }
    }
}

