/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.store;

import com.mckoi.store.AbstractStore;
import com.mckoi.store.JournalledResource;
import com.mckoi.store.LoggingBufferManager;
import java.io.IOException;

public final class JournalledFileStore
extends AbstractStore {
    private final String resource_name;
    private final LoggingBufferManager buffer_manager;
    private JournalledResource store_resource;

    public JournalledFileStore(String resource_name, LoggingBufferManager buffer_manager, boolean read_only) {
        super(read_only);
        this.resource_name = resource_name;
        this.buffer_manager = buffer_manager;
        this.store_resource = buffer_manager.createResource(resource_name);
    }

    public boolean delete() throws IOException {
        this.store_resource.delete();
        return true;
    }

    public boolean exists() throws IOException {
        return this.store_resource.exists();
    }

    public void lockForWrite() {
        try {
            this.buffer_manager.lockForWrite();
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted: " + e.getMessage());
        }
    }

    public void unlockForWrite() {
        this.buffer_manager.unlockForWrite();
    }

    protected void internalOpen(boolean read_only) throws IOException {
        this.store_resource.open(read_only);
    }

    protected void internalClose() throws IOException {
        this.buffer_manager.close(this.store_resource);
    }

    protected int readByteFrom(long position) throws IOException {
        return this.buffer_manager.readByteFrom(this.store_resource, position);
    }

    protected int readByteArrayFrom(long position, byte[] buf, int off, int len) throws IOException {
        return this.buffer_manager.readByteArrayFrom(this.store_resource, position, buf, off, len);
    }

    protected void writeByteTo(long position, int b) throws IOException {
        this.buffer_manager.writeByteTo(this.store_resource, position, b);
    }

    protected void writeByteArrayTo(long position, byte[] buf, int off, int len) throws IOException {
        this.buffer_manager.writeByteArrayTo(this.store_resource, position, buf, off, len);
    }

    protected long endOfDataAreaPointer() throws IOException {
        return this.buffer_manager.getDataAreaSize(this.store_resource);
    }

    protected void setDataAreaSize(long new_size) throws IOException {
        this.buffer_manager.setDataAreaSize(this.store_resource, new_size);
    }

    public String toString() {
        return "[ JournalledFileStore: " + this.resource_name + " ]";
    }
}

