/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.store;

import com.mckoi.store.AbstractStore;
import com.mckoi.store.Area;
import com.mckoi.store.AreaWriter;
import com.mckoi.store.MutableArea;
import com.mckoi.store.Store;
import com.mckoi.util.ByteArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public final class HeapStore
implements Store {
    private HeapAreaElement fixed_area_element;
    private HeapAreaElement[] area_map;
    private long unique_id_key;

    public HeapStore(int hash_size) {
        this.area_map = new HeapAreaElement[hash_size];
        this.unique_id_key = 0L;
    }

    public HeapStore() {
        this(257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeapAreaElement getAreaElement(long pointer) throws IOException {
        HeapStore heapStore = this;
        synchronized (heapStore) {
            int hash_pos = (int)(pointer % (long)this.area_map.length);
            HeapAreaElement prev = null;
            HeapAreaElement element = this.area_map[hash_pos];
            while (element != null && element.getID() != pointer) {
                prev = element;
                element = element.next_hash_element;
            }
            if (element == null) {
                throw new IOException("Pointer " + pointer + " is invalid.");
            }
            if (prev != null) {
                prev.next_hash_element = element.next_hash_element;
                element.next_hash_element = this.area_map[hash_pos];
                this.area_map[hash_pos] = element;
            }
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeapAreaElement getFixedAreaElement() {
        HeapStore heapStore = this;
        synchronized (heapStore) {
            if (this.fixed_area_element == null) {
                this.fixed_area_element = new HeapAreaElement(-1L, 64);
            }
            return this.fixed_area_element;
        }
    }

    private HeapAreaElement getElement(long pointer) throws IOException {
        if (pointer == -1L) {
            return this.getFixedAreaElement();
        }
        return this.getAreaElement(pointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AreaWriter createArea(long size) throws IOException {
        if (size > Integer.MAX_VALUE) {
            throw new IOException("'size' is too large.");
        }
        HeapStore heapStore = this;
        synchronized (heapStore) {
            long id = this.unique_id_key++;
            HeapAreaElement element = new HeapAreaElement(id, (int)size);
            int hash_pos = (int)(id % (long)this.area_map.length);
            element.next_hash_element = this.area_map[hash_pos];
            this.area_map[hash_pos] = element;
            return element.getAreaWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArea(long pointer) throws IOException {
        HeapStore heapStore = this;
        synchronized (heapStore) {
            int hash_pos = (int)(pointer % (long)this.area_map.length);
            HeapAreaElement prev = null;
            HeapAreaElement element = this.area_map[hash_pos];
            while (element != null && element.getID() != pointer) {
                prev = element;
                element = element.next_hash_element;
            }
            if (element == null) {
                throw new IOException("Pointer " + pointer + " is invalid.");
            }
            if (prev == null) {
                this.area_map[hash_pos] = element.next_hash_element;
            } else {
                prev.next_hash_element = element.next_hash_element;
            }
        }
    }

    public InputStream getAreaInputStream(long pointer) throws IOException {
        return this.getElement(pointer).getInputStream();
    }

    public Area getArea(long pointer) throws IOException {
        return this.getElement(pointer).getMutableArea();
    }

    public MutableArea getMutableArea(long pointer) throws IOException {
        return this.getElement(pointer).getMutableArea();
    }

    public void flush() throws IOException {
    }

    public void synch() throws IOException {
    }

    public void lockForWrite() {
    }

    public void unlockForWrite() {
    }

    public boolean lastCloseClean() {
        return true;
    }

    public List getAllAreas() throws IOException {
        throw new RuntimeException("PENDING");
    }

    private static class HeapAreaElement {
        private final long heap_id;
        private final byte[] heap_area;
        HeapAreaElement next_hash_element;

        HeapAreaElement(long heap_id, int area_size) {
            this.heap_id = heap_id;
            this.heap_area = new byte[area_size];
        }

        long getID() {
            return this.heap_id;
        }

        AreaWriter getAreaWriter() {
            return new HeapAreaWriter(this.getID(), this.heap_area, 0, this.heap_area.length);
        }

        MutableArea getMutableArea() {
            return new HeapArea(this.getID(), this.heap_area, 0, this.heap_area.length);
        }

        InputStream getInputStream() {
            return new ByteArrayInputStream(this.heap_area);
        }
    }

    private static class HeapAreaWriter
    extends HeapArea
    implements AreaWriter {
        public HeapAreaWriter(long id, byte[] heap_area, int offset, int length) {
            super(id, heap_area, offset, length);
        }

        public OutputStream getOutputStream() {
            return new AbstractStore.AreaOutputStream(this);
        }

        public void finish() throws IOException {
        }
    }

    private static class HeapArea
    implements MutableArea {
        private final long id;
        private final byte[] heap_area;
        private final int start_pointer;
        private int position;
        private final int end_pointer;

        HeapArea(long id, byte[] heap_area, int offset, int length) {
            this.id = id;
            this.heap_area = heap_area;
            this.start_pointer = offset;
            this.position = offset;
            this.end_pointer = offset + length;
        }

        private int checkPositionBounds(int diff) throws IOException {
            int new_pos = this.position + diff;
            if (new_pos > this.end_pointer) {
                throw new IOException("Position out of bounds.  start=" + this.start_pointer + " end=" + this.end_pointer + " pos=" + this.position + " new_pos=" + new_pos);
            }
            int old_pos = this.position;
            this.position = new_pos;
            return old_pos;
        }

        public long getID() {
            return this.id;
        }

        public int position() {
            return this.position - this.start_pointer;
        }

        public int capacity() {
            return this.end_pointer - this.start_pointer;
        }

        public void position(int position) throws IOException {
            int act_position = this.start_pointer + position;
            if (act_position >= 0 && act_position < this.end_pointer) {
                this.position = act_position;
                return;
            }
            throw new IOException("Moved position out of bounds.");
        }

        public void copyTo(AreaWriter destination, int size) throws IOException {
            int BUFFER_SIZE = 2048;
            byte[] buf = new byte[2048];
            int to_copy = Math.min(size, 2048);
            while (to_copy > 0) {
                this.get(buf, 0, to_copy);
                destination.put(buf, 0, to_copy);
                to_copy = Math.min(size -= to_copy, 2048);
            }
        }

        public byte get() throws IOException {
            return this.heap_area[this.checkPositionBounds(1)];
        }

        public void put(byte b) throws IOException {
            this.heap_area[this.checkPositionBounds((int)1)] = b;
        }

        public void get(byte[] buf, int off, int len) throws IOException {
            System.arraycopy(this.heap_area, this.checkPositionBounds(len), buf, off, len);
        }

        public void put(byte[] buf, int off, int len) throws IOException {
            System.arraycopy(buf, off, this.heap_area, this.checkPositionBounds(len), len);
        }

        public void put(byte[] buf) throws IOException {
            this.put(buf, 0, buf.length);
        }

        public short getShort() throws IOException {
            short s = ByteArrayUtil.getShort(this.heap_area, this.checkPositionBounds(2));
            return s;
        }

        public void putShort(short s) throws IOException {
            ByteArrayUtil.setShort(s, this.heap_area, this.checkPositionBounds(2));
        }

        public int getInt() throws IOException {
            int i = ByteArrayUtil.getInt(this.heap_area, this.checkPositionBounds(4));
            return i;
        }

        public void putInt(int i) throws IOException {
            ByteArrayUtil.setInt(i, this.heap_area, this.checkPositionBounds(4));
        }

        public long getLong() throws IOException {
            long l = ByteArrayUtil.getLong(this.heap_area, this.checkPositionBounds(8));
            return l;
        }

        public void putLong(long l) throws IOException {
            ByteArrayUtil.setLong(l, this.heap_area, this.checkPositionBounds(8));
        }

        public char getChar() throws IOException {
            char c = ByteArrayUtil.getChar(this.heap_area, this.checkPositionBounds(2));
            return c;
        }

        public void putChar(char c) throws IOException {
            ByteArrayUtil.setChar(c, this.heap_area, this.checkPositionBounds(2));
        }

        public void checkOut() {
        }

        public String toString() {
            return "[Area start_pointer=" + this.start_pointer + " end_pointer=" + this.end_pointer + " position=" + this.position + "]";
        }
    }
}

