/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.debug;

import com.mckoi.debug.DebugLogger;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;

public class DefaultDebugLogger
implements DebugLogger {
    private static final boolean PRINT_ALERT_TO_MESSAGES = false;
    private final Object debug_lock = new Object();
    static final PrintWriter SYSTEM_OUT = new PrintWriter(System.out, true);
    static final PrintWriter SYSTEM_ERR = new PrintWriter(System.err, true);
    private int debug_level = 0;
    private PrintWriter out = SYSTEM_ERR;
    private PrintWriter err = SYSTEM_ERR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalWrite(PrintWriter out, int level, String class_string, String message) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            if (level < 10000) {
                out.print("> ");
                out.print(class_string);
                out.print(" ( lvl: ");
                out.print(level);
                out.print(" )\n  ");
            } else {
                out.print("% ");
            }
            out.println(message);
            out.flush();
        }
    }

    public final void setOutput(Writer out) {
        this.out = new PrintWriter(out, false);
    }

    public final void setDebugLevel(int level) {
        this.debug_level = level;
    }

    public final void listenToEventDispatcher() {
        System.setProperty("sun.awt.exception.handler", "com.mckoi.debug.DispatchNotify");
    }

    public final boolean isInterestedIn(int level) {
        return level >= this.debug_level;
    }

    public final void write(int level, Object ob, String message) {
        this.write(level, ob.getClass().getName(), message);
    }

    public final void write(int level, Class cla, String message) {
        this.write(level, cla.getName(), message);
    }

    public final void write(int level, String class_string, String message) {
        if (this.isInterestedIn(level)) {
            if (level >= 40 && level < 10000) {
                this.internalWrite(SYSTEM_ERR, level, class_string, message);
            }
            this.internalWrite(this.out, level, class_string, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeTime() {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.print("[ TIME: ");
            this.out.print(new Date(System.currentTimeMillis()));
            this.out.println(" ]");
            this.out.flush();
        }
    }

    public final void writeException(Throwable e) {
        this.writeException(40, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void writeException(int level, Throwable e) {
        PrintWriter printWriter;
        if (level >= 40) {
            printWriter = SYSTEM_ERR;
            synchronized (printWriter) {
                SYSTEM_ERR.print("[com.mckoi.debug.Debug - Exception thrown: '");
                SYSTEM_ERR.print(e.getMessage());
                SYSTEM_ERR.println("']");
                e.printStackTrace(SYSTEM_ERR);
            }
        }
        if (this.isInterestedIn(level)) {
            printWriter = this.out;
            synchronized (printWriter) {
                this.writeTime();
                this.out.print("% ");
                e.printStackTrace(this.out);
                this.out.flush();
            }
        }
    }
}

