/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbcserver;

import com.mckoi.database.global.ObjectTransfer;
import com.mckoi.database.jdbc.DatabaseCallBack;
import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.database.jdbc.ProtocolConstants;
import com.mckoi.database.jdbc.QueryResponse;
import com.mckoi.database.jdbc.ResultPart;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.database.jdbc.StreamableObjectPart;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.ByteArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

abstract class JDBCProcessor
implements ProtocolConstants {
    private static final int SERVER_VERSION = 1;
    private int state;
    private int authentication_tries;
    private DatabaseInterface db_interface;
    private DebugLogger debug;
    private DatabaseCallBack db_call_back = new DatabaseCallBack(){

        public void databaseEvent(int event_type, String event_message) {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                dout.writeInt(event_type);
                dout.writeUTF(event_message);
                JDBCProcessor.this.sendEvent(bout.toByteArray());
            }
            catch (IOException e) {
                JDBCProcessor.this.debug.write(40, this, "IO Error: " + e.getMessage());
                JDBCProcessor.this.debug.writeException(e);
            }
        }
    };

    JDBCProcessor(DatabaseInterface db_interface, DebugLogger logger) {
        this.debug = logger;
        this.db_interface = db_interface;
        this.state = 0;
        this.authentication_tries = 0;
    }

    protected static void printByteArray(byte[] array) {
        System.out.println("Length: " + array.length);
        for (int i = 0; i < array.length; ++i) {
            System.out.print(array[i]);
            System.out.print(", ");
        }
    }

    byte[] processJDBCCommand(byte[] command) throws IOException {
        if (this.state == 0) {
            int magic = ByteArrayUtil.getInt(command, 0);
            int maj_ver = ByteArrayUtil.getInt(command, 4);
            int min_ver = ByteArrayUtil.getInt(command, 8);
            byte[] ack_command = new byte[10];
            ByteArrayUtil.setInt(5, ack_command, 0);
            ack_command[4] = 1;
            ByteArrayUtil.setInt(1, ack_command, 5);
            ack_command[9] = 0;
            this.state = 4;
            return ack_command;
        }
        if (this.state == 4) {
            ByteArrayInputStream bin = new ByteArrayInputStream(command);
            DataInputStream din = new DataInputStream(bin);
            String default_schema = din.readUTF();
            String username = din.readUTF();
            String password = din.readUTF();
            try {
                boolean good = this.db_interface.login(default_schema, username, password, this.db_call_back);
                if (!good) {
                    if (this.authentication_tries < 12) {
                        ++this.authentication_tries;
                        return this.single(15);
                    }
                } else {
                    this.state = 100;
                    return this.single(10);
                }
                this.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            return null;
        }
        if (this.state == 100) {
            return this.processQuery(command);
        }
        throw new Error("Illegal state: " + this.state);
    }

    int getState() {
        return this.state;
    }

    private byte[] single(int val) {
        byte[] buf = new byte[4];
        ByteArrayUtil.setInt(val, buf, 0);
        return buf;
    }

    private byte[] exception(int dispatch_id, SQLException e) throws IOException {
        int code = e.getErrorCode();
        String msg = e.getMessage();
        if (msg == null) {
            msg = "NULL exception message";
        }
        String server_msg = "";
        String stack_trace = "";
        if (e instanceof MSQLException) {
            MSQLException me = (MSQLException)e;
            server_msg = me.getServerErrorMsg();
            stack_trace = me.getServerErrorStackTrace();
        } else {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            stack_trace = writer.toString();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeInt(dispatch_id);
        dout.writeInt(30);
        dout.writeInt(code);
        dout.writeUTF(msg);
        dout.writeUTF(stack_trace);
        return bout.toByteArray();
    }

    private byte[] simpleSuccess(int dispatch_id) throws IOException {
        byte[] buf = new byte[8];
        ByteArrayUtil.setInt(dispatch_id, buf, 0);
        ByteArrayUtil.setInt(20, buf, 4);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] processQuery(byte[] command) throws IOException {
        void var2_4;
        byte[] result;
        int ins = ByteArrayUtil.getInt(command, 0);
        int dispatch_id = ByteArrayUtil.getInt(command, 4);
        if (dispatch_id == -1) {
            throw new Error("Special case dispatch id of -1 in query");
        }
        if (ins == 60) {
            result = this.resultSection(dispatch_id, command);
        } else if (ins == 50) {
            result = this.queryCommand(dispatch_id, command);
        } else if (ins == 63) {
            result = this.pushStreamableObjectPart(dispatch_id, command);
        } else if (ins == 55) {
            result = this.disposeResult(dispatch_id, command);
        } else if (ins == 61) {
            result = this.streamableObjectSection(dispatch_id, command);
        } else if (ins == 62) {
            result = this.disposeStreamableObject(dispatch_id, command);
        } else if (ins == 70) {
            this.close();
            result = null;
        } else {
            throw new Error("Command (" + ins + ") not understood.");
        }
        return var2_4;
    }

    void dispose() {
        try {
            this.db_interface.dispose();
        }
        catch (Throwable e) {
            this.debug.writeException(40, e);
        }
    }

    private byte[] queryCommand(int dispatch_id, byte[] command) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(command, 8, command.length - 8);
        DataInputStream din = new DataInputStream(bin);
        SQLQuery query = SQLQuery.readFrom(din);
        try {
            QueryResponse response = this.db_interface.execQuery(query);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeInt(dispatch_id);
            dout.writeInt(20);
            dout.writeInt(response.getResultID());
            dout.writeInt(response.getQueryTimeMillis());
            dout.writeInt(response.getRowCount());
            int col_count = response.getColumnCount();
            dout.writeInt(col_count);
            for (int i = 0; i < col_count; ++i) {
                response.getColumnDescription(i).writeTo(dout);
            }
            return bout.toByteArray();
        }
        catch (SQLException e) {
            return this.exception(dispatch_id, e);
        }
    }

    private byte[] pushStreamableObjectPart(int dispatch_id, byte[] command) throws IOException {
        byte type = command[8];
        long object_id = ByteArrayUtil.getLong(command, 9);
        long object_length = ByteArrayUtil.getLong(command, 17);
        int length = ByteArrayUtil.getInt(command, 25);
        byte[] ob_buf = new byte[length];
        System.arraycopy(command, 29, ob_buf, 0, length);
        long offset = ByteArrayUtil.getLong(command, 29 + length);
        try {
            this.db_interface.pushStreamableObjectPart(type, object_id, object_length, ob_buf, offset, length);
            return this.simpleSuccess(dispatch_id);
        }
        catch (SQLException e) {
            return this.exception(dispatch_id, e);
        }
    }

    private byte[] resultSection(int dispatch_id, byte[] command) throws IOException {
        int result_id = ByteArrayUtil.getInt(command, 8);
        int row_number = ByteArrayUtil.getInt(command, 12);
        int row_count = ByteArrayUtil.getInt(command, 16);
        try {
            ResultPart block = this.db_interface.getResultPart(result_id, row_number, row_count);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeInt(dispatch_id);
            dout.writeInt(20);
            int col_count = block.size() / row_count;
            dout.writeInt(col_count);
            int bsize = block.size();
            for (int index = 0; index < bsize; ++index) {
                ObjectTransfer.writeTo(dout, block.elementAt(index));
            }
            return bout.toByteArray();
        }
        catch (SQLException e) {
            return this.exception(dispatch_id, e);
        }
    }

    private byte[] streamableObjectSection(int dispatch_id, byte[] command) throws IOException {
        int result_id = ByteArrayUtil.getInt(command, 8);
        long streamable_object_id = ByteArrayUtil.getLong(command, 12);
        long offset = ByteArrayUtil.getLong(command, 20);
        int length = ByteArrayUtil.getInt(command, 28);
        try {
            StreamableObjectPart ob_part = this.db_interface.getStreamableObjectPart(result_id, streamable_object_id, offset, length);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeInt(dispatch_id);
            dout.writeInt(20);
            byte[] buf = ob_part.getContents();
            dout.writeInt(buf.length);
            dout.write(buf, 0, buf.length);
            return bout.toByteArray();
        }
        catch (SQLException e) {
            return this.exception(dispatch_id, e);
        }
    }

    private byte[] disposeStreamableObject(int dispatch_id, byte[] command) throws IOException {
        int result_id = ByteArrayUtil.getInt(command, 8);
        long streamable_object_id = ByteArrayUtil.getLong(command, 12);
        try {
            this.db_interface.disposeStreamableObject(result_id, streamable_object_id);
            return this.simpleSuccess(dispatch_id);
        }
        catch (SQLException e) {
            return this.exception(dispatch_id, e);
        }
    }

    private byte[] disposeResult(int dispatch_id, byte[] command) throws IOException {
        int result_id = ByteArrayUtil.getInt(command, 8);
        try {
            this.db_interface.disposeResult(result_id);
            return this.simpleSuccess(dispatch_id);
        }
        catch (SQLException e) {
            return this.exception(dispatch_id, e);
        }
    }

    public abstract void sendEvent(byte[] var1) throws IOException;

    public abstract void close() throws IOException;

    public abstract boolean isClosed() throws IOException;

    public final void finalize() throws Throwable {
        super.finalize();
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

