/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbcserver;

import com.mckoi.database.Database;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.LockingMechanism;
import com.mckoi.database.TransactionException;
import com.mckoi.database.User;
import com.mckoi.database.jdbc.DatabaseCallBack;
import com.mckoi.database.jdbc.QueryResponse;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.database.jdbcserver.AbstractJDBCDatabaseInterface;
import java.sql.SQLException;

public class JDBCDatabaseInterface
extends AbstractJDBCDatabaseInterface {
    private static final boolean COMMAND_LOGGING = true;
    private String host_name;

    public JDBCDatabaseInterface(Database database, String host_name) {
        super(database);
        this.host_name = host_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticate(Database database, String default_schema, String username, String password, final DatabaseCallBack database_call_back) {
        block16: {
            if (this.getUser() != null) break block16;
            if (database.getSystem().logQueries()) {
                StringBuffer log_str = new StringBuffer();
                log_str.append("[JDBC] [");
                log_str.append(username);
                log_str.append("] ");
                log_str.append('[');
                log_str.append(this.host_name);
                log_str.append("] ");
                log_str.append("Log in.\n");
                database.getCommandsLog().log(new String(log_str));
            }
            if (this.Debug().isInterestedIn(10)) {
                this.Debug().write(10, this, "Authenticate User: " + username);
            }
            DatabaseConnection.CallBack call_back = new DatabaseConnection.CallBack(){

                public void triggerNotify(String trigger_name, int trigger_event, String trigger_source, int fire_count) {
                    StringBuffer message = new StringBuffer();
                    message.append(trigger_name);
                    message.append(' ');
                    message.append(trigger_source);
                    message.append(' ');
                    message.append(fire_count);
                    database_call_back.databaseEvent(99, new String(message));
                }
            };
            User this_user = database.authenticateUser(username, password, this.host_name);
            DatabaseConnection database_connection = null;
            if (this_user != null) {
                database_connection = database.createNewConnection(this_user, call_back);
                LockingMechanism locker = database_connection.getLockingMechanism();
                locker.setMode(2);
                try {
                    database_connection.setAutoCommit(true);
                    if (database_connection.schemaExists(default_schema)) {
                        database_connection.setDefaultSchema(default_schema);
                    } else {
                        this.Debug().write(20, this, "Couldn't change to '" + default_schema + "' schema.");
                        database_connection.setDefaultSchema("APP");
                    }
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    try {
                        database_connection.commit();
                        locker.finishMode(2);
                    }
                    catch (TransactionException e) {
                        try {}
                        catch (Throwable throwable2) {
                            locker.finishMode(2);
                            throw throwable2;
                        }
                        this.Debug().writeException(20, e);
                        locker.finishMode(2);
                    }
                    throw throwable;
                }
                try {
                    database_connection.commit();
                }
                catch (TransactionException e) {
                    this.Debug().writeException(20, e);
                }
                finally {
                    locker.finishMode(2);
                }
            }
            if (this_user != null) {
                this.init(this_user, database_connection);
                return true;
            }
            return false;
        }
        throw new RuntimeException("Attempt to authenticate user twice");
    }

    public boolean login(String default_schema, String username, String password, DatabaseCallBack database_call_back) throws SQLException {
        Database database = this.getDatabase();
        boolean b = this.authenticate(database, default_schema, username, password, database_call_back);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public QueryResponse execQuery(SQLQuery query) throws SQLException {
        this.checkNotDisposed();
        user = this.getUser();
        database_connection = this.getDatabaseConnection();
        if (this.getDatabase().getSystem().logQueries()) {
            log_str = new StringBuffer();
            log_str.append("[JDBC] [");
            log_str.append(user.getUserName());
            log_str.append("] ");
            log_str.append('[');
            log_str.append(this.host_name);
            log_str.append("] ");
            log_str.append("Query: ");
            log_str.append(query.getQuery());
            log_str.append('\n');
            user.getDatabase().getCommandsLog().log(new String(log_str));
        }
        if (this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, "Query From User: " + user.getUserName() + "@" + this.host_name);
            this.Debug().write(10, this, "Query: " + query.getQuery().trim());
        }
        locker = database_connection.getLockingMechanism();
        lock_mode = -1;
        response = null;
        lock_mode = 2;
        locker.setMode(lock_mode);
        var7_7 = response = super.execQuery(query);
        var9_8 = null;
        try {
            if (lock_mode != -1) {
                locker.finishMode(lock_mode);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            this.Debug().write(40, this, "Exception finishing locks");
            this.Debug().writeException(e);
        }
        var12_12 = null;
        if (!database_connection.getAutoCommit()) ** break block23
        try {
            block24: {
                locker.setMode(2);
                if (response != null) break block24;
                database_connection.rollback();
                ** GOTO lbl-1000
            }
            try {
                database_connection.commit();
            }
            catch (Throwable e) {
                this.disposeResult(response.getResultID());
                throw this.handleExecuteThrowable(e, query);
            }
        }
        finally {
            locker.finishMode(2);
        }
lbl-1000:
        // 3 sources

        {
            return var7_7;
            catch (Throwable var8_18) {
                var9_9 = null;
                try {
                    if (lock_mode != -1) {
                        locker.finishMode(lock_mode);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                    this.Debug().write(40, this, "Exception finishing locks");
                    this.Debug().writeException(e);
                }
                throw var8_18;
            }
        }
        catch (Throwable var11_19) {
            block22: {
                var12_13 = null;
                if (database_connection.getAutoCommit()) {
                    try {
                        locker.setMode(2);
                        if (response == null) {
                            database_connection.rollback();
                            break block22;
                        }
                        try {
                            database_connection.commit();
                        }
                        catch (Throwable e) {
                            this.disposeResult(response.getResultID());
                            throw this.handleExecuteThrowable(e, query);
                        }
                    }
                    finally {
                        locker.finishMode(2);
                    }
                }
            }
            throw var11_19;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws SQLException {
        if (this.getUser() != null) {
            DatabaseConnection database = this.getDatabaseConnection();
            LockingMechanism locker = database.getLockingMechanism();
            try {
                locker.setMode(2);
                database.rollback();
                Object var4_3 = null;
                locker.finishMode(2);
                database.close();
                this.getUser().logout();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                locker.finishMode(2);
                database.close();
                this.getUser().logout();
                this.internalDispose();
                throw throwable;
            }
            this.internalDispose();
            {
            }
        }
    }
}

