/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbcserver;

import com.mckoi.database.Database;
import com.mckoi.database.control.DBConfig;
import com.mckoi.database.control.DBController;
import com.mckoi.database.control.DBSystem;
import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbc.LocalBootable;
import com.mckoi.database.jdbcserver.JDBCDatabaseInterface;
import java.sql.SQLException;

public class DefaultLocalBootable
implements LocalBootable {
    private boolean booted = false;
    private boolean active = false;
    private DBSystem dbsys;
    private int connect_id = 0;
    private int open_connections = 0;
    private Object connection_lock = new Object();

    public DatabaseInterface create(String username, String password, DBConfig config) throws SQLException {
        if (username.equals("") || password.equals("")) {
            throw new SQLException("Username and Password must both be set.");
        }
        if (!this.booted) {
            String host_string = "Local/Create/";
            DBController controller = DBController.getDefault();
            this.dbsys = controller.createDatabase(config, username, password);
            LocalJDBCDatabaseInterface db_interface = new LocalJDBCDatabaseInterface(this.dbsys.getDatabase(), host_string);
            this.booted = true;
            ++this.open_connections;
            this.active = true;
            return db_interface;
        }
        throw new SQLException("Database is already created.");
    }

    public DatabaseInterface boot(DBConfig config) throws SQLException {
        if (!this.booted) {
            String host_string = "Local/Boot/";
            DBController controller = DBController.getDefault();
            this.dbsys = controller.startDatabase(config);
            LocalJDBCDatabaseInterface db_interface = new LocalJDBCDatabaseInterface(this.dbsys.getDatabase(), host_string);
            this.booted = true;
            ++this.open_connections;
            this.active = true;
            return db_interface;
        }
        throw new SQLException("Database was booted more than once.");
    }

    public boolean checkExists(DBConfig config) throws SQLException {
        if (!this.booted) {
            DBController controller = DBController.getDefault();
            return controller.databaseExists(config);
        }
        throw new SQLException("The database is already booted.");
    }

    public boolean isBooted() throws SQLException {
        return this.booted;
    }

    public DatabaseInterface connectToJVM() throws SQLException {
        if (this.booted) {
            String host_string = "Local/Connection/" + this.connect_id;
            LocalJDBCDatabaseInterface db_interface = new LocalJDBCDatabaseInterface(this.dbsys.getDatabase(), host_string);
            ++this.connect_id;
            ++this.open_connections;
            this.active = true;
            return db_interface;
        }
        throw new SQLException("The database is not started.");
    }

    private class LocalJDBCDatabaseInterface
    extends JDBCDatabaseInterface {
        boolean closed = false;

        public LocalJDBCDatabaseInterface(Database database, String host_string) {
            super(database, host_string);
        }

        public void dispose() throws SQLException {
            if (!this.closed) {
                super.dispose();
                --DefaultLocalBootable.this.open_connections;
                if (DefaultLocalBootable.this.open_connections <= 0) {
                    DefaultLocalBootable.this.dbsys.close();
                    DefaultLocalBootable.this.active = false;
                    DefaultLocalBootable.this.booted = false;
                    DefaultLocalBootable.this.dbsys = null;
                }
                this.closed = true;
            }
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.dispose();
        }
    }
}

