/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbcserver;

import com.mckoi.database.Database;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SimpleRowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TransactionException;
import com.mckoi.database.User;
import com.mckoi.database.Variable;
import com.mckoi.database.global.ColumnDescription;
import com.mckoi.database.global.Ref;
import com.mckoi.database.global.StreamableObject;
import com.mckoi.database.interpret.SQLQueryExecutor;
import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.database.jdbc.QueryResponse;
import com.mckoi.database.jdbc.ResultPart;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.database.jdbc.StreamableObjectPart;
import com.mckoi.database.sql.ParseException;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.IntegerVector;
import com.mckoi.util.StringUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class AbstractJDBCDatabaseInterface
implements DatabaseInterface {
    private Database database;
    private HashMap result_set_map;
    private int unique_result_id;
    private User user = null;
    private DatabaseConnection database_connection;
    private SQLQueryExecutor sql_executor;
    private HashMap blob_id_map;
    private boolean disposed;

    public AbstractJDBCDatabaseInterface(Database database) {
        this.database = database;
        this.result_set_map = new HashMap();
        this.blob_id_map = new HashMap();
        this.unique_result_id = 1;
        this.disposed = false;
    }

    protected final void init(User user, DatabaseConnection connection) {
        this.user = user;
        this.database_connection = connection;
        this.sql_executor = new SQLQueryExecutor();
    }

    protected final Database getDatabase() {
        return this.database;
    }

    protected final User getUser() {
        return this.user;
    }

    public final DebugLogger Debug() {
        return this.getDatabase().Debug();
    }

    protected final DatabaseConnection getDatabaseConnection() {
        return this.database_connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addResultSet(ResultSetInfo result) {
        int result_id;
        result.lockRoot(-1);
        HashMap hashMap = this.result_set_map;
        synchronized (hashMap) {
            result_id = ++this.unique_result_id;
            this.result_set_map.put(new Integer(result_id), result);
        }
        return result_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetInfo getResultSet(int result_id) {
        HashMap hashMap = this.result_set_map;
        synchronized (hashMap) {
            return (ResultSetInfo)this.result_set_map.get(new Integer(result_id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeResultSet(int result_id) {
        ResultSetInfo table;
        HashMap hashMap = this.result_set_map;
        synchronized (hashMap) {
            table = (ResultSetInfo)this.result_set_map.remove(new Integer(result_id));
        }
        if (table != null) {
            table.dispose();
        } else {
            this.Debug().write(40, this, "Attempt to dispose invalid 'result_id'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearResultSetMap() {
        ArrayList list;
        Iterator<Object> keys;
        HashMap hashMap = this.result_set_map;
        synchronized (hashMap) {
            keys = this.result_set_map.keySet().iterator();
            list = new ArrayList();
            while (keys.hasNext()) {
                list.add(keys.next());
            }
        }
        keys = list.iterator();
        while (keys.hasNext()) {
            int result_id = (Integer)keys.next();
            this.disposeResultSet(result_id);
        }
    }

    protected final SQLException handleExecuteThrowable(Throwable e, SQLQuery query) {
        if (e instanceof ParseException) {
            this.Debug().writeException(20, e);
            String msg = e.getMessage();
            msg = StringUtil.searchAndReplace(msg, "\r", "");
            return new MSQLException(msg, msg, 35, e);
        }
        if (e instanceof TransactionException) {
            TransactionException te = (TransactionException)e;
            this.Debug().write(10, this, "Transaction error on: " + query);
            this.Debug().writeException(10, e);
            return new MSQLException(e.getMessage(), e.getMessage(), 200 + te.getType(), e);
        }
        this.Debug().write(20, this, "Exception thrown during query processing on: " + query);
        this.Debug().writeException(20, e);
        return new MSQLException(e.getMessage(), e.getMessage(), 1, e);
    }

    private Ref getLargeObjectRefFor(long streamable_object_id, byte type, long object_length) {
        Long s_ob_id = new Long(streamable_object_id);
        Object ob = this.blob_id_map.get(s_ob_id);
        if (ob == null) {
            Ref ref = this.database_connection.createNewLargeObject(type, object_length);
            this.blob_id_map.put(s_ob_id, ref);
            return ref;
        }
        return (Ref)ob;
    }

    private Ref getLargeObjectRefFor(long streamable_object_id) throws SQLException {
        Long s_ob_id = new Long(streamable_object_id);
        Object ob = this.blob_id_map.get(s_ob_id);
        if (ob == null) {
            throw new SQLException("Invalid streamable object id in query.");
        }
        return (Ref)ob;
    }

    private Ref flushLargeObjectRefFromCache(long streamable_object_id) throws SQLException {
        try {
            Long s_ob_id = new Long(streamable_object_id);
            Object ob = this.blob_id_map.remove(s_ob_id);
            if (ob == null) {
                throw new SQLException("Invalid streamable object id in query.");
            }
            Ref ref = (Ref)ob;
            ref.complete();
            return ref;
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    protected final void internalDispose() {
        this.disposed = true;
        this.clearResultSetMap();
        this.user = null;
        this.database_connection = null;
        this.sql_executor = null;
    }

    protected final void checkNotDisposed() throws SQLException {
        if (this.disposed) {
            throw new SQLException("Database interface was disposed (was the connection closed?)");
        }
    }

    public void pushStreamableObjectPart(byte type, long object_id, long object_length, byte[] buf, long offset, int length) throws SQLException {
        this.checkNotDisposed();
        try {
            Ref ref = this.getLargeObjectRefFor(object_id, type, object_length);
            ref.write(offset, buf, length);
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    public QueryResponse execQuery(SQLQuery query) throws SQLException {
        ResultSetInfo result_set_info;
        this.checkNotDisposed();
        long start_time = System.currentTimeMillis();
        int result_id = -1;
        boolean blobs_were_flushed = false;
        Object[] vars = query.getVars();
        if (vars != null) {
            for (int i = 0; i < vars.length; ++i) {
                Object ob = vars[i];
                if (ob == null || !(ob instanceof StreamableObject)) continue;
                StreamableObject s_object = (StreamableObject)ob;
                Ref ref = this.flushLargeObjectRefFromCache(s_object.getIdentifier());
                vars[i] = ref;
                blobs_were_flushed = true;
            }
        }
        if (blobs_were_flushed) {
            this.database_connection.flushBlobStore();
        }
        try {
            Table result = this.sql_executor.execute(this.database_connection, query);
            result_set_info = new ResultSetInfo(query, result);
            result_id = this.addResultSet(result_set_info);
        }
        catch (Throwable e) {
            if (result_id != -1) {
                this.disposeResultSet(result_id);
            }
            throw this.handleExecuteThrowable(e, query);
        }
        long taken = System.currentTimeMillis() - start_time;
        return new JDIQueryResponse(result_id, result_set_info, (int)taken, "");
    }

    public ResultPart getResultPart(int result_id, int row_number, int row_count) throws SQLException {
        this.checkNotDisposed();
        ResultSetInfo table = this.getResultSet(result_id);
        if (table == null) {
            throw new MSQLException("'result_id' invalid.", null, 4, (Throwable)null);
        }
        int row_end = row_number + row_count;
        if (row_number < 0 || row_number >= table.getRowCount() || row_end > table.getRowCount()) {
            throw new MSQLException("Result part out of range.", null, 4, (Throwable)null);
        }
        try {
            int col_count = table.getColumnCount();
            ResultPart block = new ResultPart(row_count * col_count);
            for (int r = row_number; r < row_end; ++r) {
                for (int c = 0; c < col_count; ++c) {
                    Object client_ob;
                    TObject t_object = table.getCellContents(c, r);
                    if (t_object.getObject() instanceof Ref) {
                        Ref ref = (Ref)t_object.getObject();
                        client_ob = new StreamableObject(ref.getType(), ref.getRawSize(), ref.getID());
                    } else {
                        client_ob = t_object.getObject();
                    }
                    block.addElement(client_ob);
                }
            }
            return block;
        }
        catch (Throwable e) {
            this.Debug().writeException(20, e);
            throw new MSQLException("Exception while reading results: " + e.getMessage(), e.getMessage(), 4, e);
        }
    }

    public void disposeResult(int result_id) throws SQLException {
        this.checkNotDisposed();
        this.disposeResultSet(result_id);
    }

    public StreamableObjectPart getStreamableObjectPart(int result_id, long streamable_object_id, long offset, int len) throws SQLException {
        this.checkNotDisposed();
        ResultSetInfo table = this.getResultSet(result_id);
        if (table == null) {
            throw new MSQLException("'result_id' invalid.", null, 4, (Throwable)null);
        }
        Ref ref = table.getRef(streamable_object_id);
        if (ref == null) {
            throw new MSQLException("'streamable_object_id' invalid.", null, 4, (Throwable)null);
        }
        if (len > 524288) {
            throw new MSQLException("Request length exceeds 512 KB", null, 4, (Throwable)null);
        }
        try {
            byte[] blob_part = new byte[len];
            ref.read(offset, blob_part, len);
            return new StreamableObjectPart(blob_part);
        }
        catch (IOException e) {
            throw new MSQLException("Exception while reading blob: " + e.getMessage(), e.getMessage(), 4, e);
        }
    }

    public void disposeStreamableObject(int result_id, long streamable_object_id) throws SQLException {
        this.checkNotDisposed();
        ResultSetInfo table = this.getResultSet(result_id);
        if (table == null) {
            throw new MSQLException("'result_id' invalid.", null, 4, (Throwable)null);
        }
        table.removeRef(streamable_object_id);
    }

    public void finalize() throws Throwable {
        super.finalize();
        try {
            if (!this.disposed) {
                this.dispose();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final class ResultSetInfo {
        private SQLQuery query;
        private Table result;
        private ColumnDescription[] col_desc;
        private IntegerVector row_index_map;
        private boolean result_is_simple_enum;
        private int result_row_count;
        private int locked;
        private HashMap streamable_blob_map;

        ResultSetInfo(SQLQuery query, Table table) {
            this.query = query;
            this.result = table;
            this.streamable_blob_map = new HashMap();
            this.result_row_count = table.getRowCount();
            RowEnumeration row_enum = table.rowEnumeration();
            if (row_enum.hasMoreRows()) {
                int row_index = row_enum.nextRowIndex();
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    table.getCellContents(c, row_index);
                }
            }
            this.result_is_simple_enum = row_enum instanceof SimpleRowEnumeration;
            row_enum = null;
            if (!this.result_is_simple_enum) {
                this.row_index_map = new IntegerVector(table.getRowCount());
                RowEnumeration rowEnumeration = table.rowEnumeration();
                while (rowEnumeration.hasMoreRows()) {
                    this.row_index_map.addInt(rowEnumeration.nextRowIndex());
                }
            }
            int col_count = table.getColumnCount();
            this.col_desc = new ColumnDescription[col_count];
            for (int i = 0; i < col_count; ++i) {
                Variable v = table.getResolvedVariable(i);
                String field_name = v.getTableName() == null ? "@a" + v.getName() : "@f" + v.toString();
                this.col_desc[i] = table.getColumnDefAt(i).columnDescriptionValue(field_name);
            }
            this.locked = 0;
        }

        SQLQuery getSQLQuery() {
            return this.query;
        }

        Ref getRef(long id) {
            return (Ref)this.streamable_blob_map.get(new Long(id));
        }

        void removeRef(long id) {
            this.streamable_blob_map.remove(new Long(id));
        }

        void dispose() {
            while (this.locked > 0) {
                this.unlockRoot(-1);
            }
            this.result = null;
            this.row_index_map = null;
            this.col_desc = null;
        }

        TObject getCellContents(int column, int row) {
            if (this.locked > 0) {
                int real_row = this.result_is_simple_enum ? row : this.row_index_map.intAt(row);
                TObject tob = this.result.getCellContents(column, real_row);
                if (tob.getObject() instanceof Ref) {
                    Ref ref = (Ref)tob.getObject();
                    this.streamable_blob_map.put(new Long(ref.getID()), ref);
                }
                return tob;
            }
            throw new RuntimeException("Table roots not locked!");
        }

        int getColumnCount() {
            return this.result.getColumnCount();
        }

        int getRowCount() {
            return this.result_row_count;
        }

        ColumnDescription[] getFields() {
            return this.col_desc;
        }

        void lockRoot(int key) {
            this.result.lockRoot(key);
            ++this.locked;
        }

        void unlockRoot(int key) {
            this.result.unlockRoot(key);
            --this.locked;
        }
    }

    private static final class JDIQueryResponse
    implements QueryResponse {
        int result_id;
        ResultSetInfo result_set_info;
        int query_time;
        String warnings;

        JDIQueryResponse(int result_id, ResultSetInfo result_set_info, int query_time, String warnings) {
            this.result_id = result_id;
            this.result_set_info = result_set_info;
            this.query_time = query_time;
            this.warnings = warnings;
        }

        public int getResultID() {
            return this.result_id;
        }

        public int getQueryTimeMillis() {
            return this.query_time;
        }

        public int getRowCount() {
            return this.result_set_info.getRowCount();
        }

        public int getColumnCount() {
            return this.result_set_info.getColumnCount();
        }

        public ColumnDescription getColumnDescription(int n) {
            return this.result_set_info.getFields()[n];
        }

        public String getWarnings() {
            return this.warnings;
        }
    }
}

