/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ObjectTransfer;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.ResultPart;
import com.mckoi.util.Cache;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

final class RowCache {
    private Cache row_cache;

    RowCache(int cache_size, int max_size) {
        this.row_cache = new Cache(cache_size, cache_size, 20);
    }

    synchronized Vector getResultPart(Vector result_block, MConnection connection, int result_id, int row_index, int row_count, int col_count, int total_row_count) throws IOException, SQLException {
        int c;
        int r;
        CachedRow row;
        int orig_row_index = row_index;
        int orig_row_count = row_count;
        Vector<CachedRow> rows = new Vector<CachedRow>();
        boolean found_notcached = false;
        for (int r2 = 0; r2 < row_count && !found_notcached; ++r2) {
            int da_row = row_index + r2;
            RowRef row_ref = new RowRef(result_id, da_row);
            CachedRow row2 = (CachedRow)this.row_cache.get(row_ref);
            if (row2 == null) {
                row_index = da_row;
                if (row_index + row_count > total_row_count) {
                    row_count = total_row_count - row_index;
                }
                found_notcached = true;
                continue;
            }
            rows.addElement(row2);
        }
        Vector<CachedRow> rows2 = new Vector<CachedRow>();
        if (found_notcached) {
            found_notcached = false;
            for (int r3 = row_count - 1; r3 >= 0 && !found_notcached; --r3) {
                int da_row = row_index + r3;
                RowRef row_ref = new RowRef(result_id, da_row);
                row = (CachedRow)this.row_cache.get(row_ref);
                if (row == null) {
                    if (row_index == orig_row_index) {
                        if ((row_index -= row_count - (r3 + 1)) < 0) {
                            row_count += row_index;
                            row_index = 0;
                        }
                    } else {
                        row_count = r3 + 1;
                    }
                    found_notcached = true;
                    continue;
                }
                rows2.insertElementAt(row, 0);
            }
        }
        if (found_notcached) {
            ResultPart block = connection.requestResultPart(result_id, row_index, row_count);
            int block_index = 0;
            for (int r4 = 0; r4 < row_count; ++r4) {
                Object[] arr = new Object[col_count];
                int da_row = row_index + r4;
                int col_size = 0;
                for (int c2 = 0; c2 < col_count; ++c2) {
                    Object ob = block.elementAt(block_index);
                    ++block_index;
                    arr[c2] = ob;
                    col_size += ObjectTransfer.size(ob);
                }
                CachedRow cached_row = new CachedRow();
                cached_row.row = da_row;
                cached_row.row_data = arr;
                if (col_size <= 3200) {
                    this.row_cache.put(new RowRef(result_id, da_row), cached_row);
                }
                rows.addElement(cached_row);
            }
        }
        result_block.removeAllElements();
        int low = orig_row_index;
        int high = orig_row_index + orig_row_count;
        for (r = 0; r < rows.size(); ++r) {
            row = (CachedRow)rows.elementAt(r);
            if (row.row < low || row.row >= high) continue;
            for (c = 0; c < col_count; ++c) {
                result_block.addElement(row.row_data[c]);
            }
        }
        for (r = 0; r < rows2.size(); ++r) {
            row = (CachedRow)rows2.elementAt(r);
            if (row.row < low || row.row >= high) continue;
            for (c = 0; c < col_count; ++c) {
                result_block.addElement(row.row_data[c]);
            }
        }
        return result_block;
    }

    synchronized void clear() {
        this.row_cache.removeAll();
    }

    private static final class CachedRow {
        int row;
        Object[] row_data;

        private CachedRow() {
        }
    }

    private static final class RowRef {
        int table_id;
        int row;

        RowRef(int table_id, int row) {
            this.table_id = table_id;
            this.row = row;
        }

        public int hashCode() {
            return this.table_id + this.row * 35331;
        }

        public boolean equals(Object ob) {
            RowRef dest = (RowRef)ob;
            return this.row == dest.row && this.table_id == dest.table_id;
        }
    }
}

