/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ColumnDescription;
import com.mckoi.database.global.ObjectTransfer;
import com.mckoi.database.jdbc.DatabaseCallBack;
import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbc.MDriver;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.database.jdbc.ProtocolConstants;
import com.mckoi.database.jdbc.QueryResponse;
import com.mckoi.database.jdbc.ResultPart;
import com.mckoi.database.jdbc.SQLLoginException;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.database.jdbc.StreamableObjectPart;
import com.mckoi.util.ByteArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

abstract class RemoteDatabaseInterface
implements DatabaseInterface,
ProtocolConstants {
    private ConnectionThread connection_thread;
    private DatabaseCallBack database_call_back;

    RemoteDatabaseInterface() {
    }

    private static void logException(Throwable e) {
        PrintWriter out = null;
        out = DriverManager.getLogWriter();
        if (out != null) {
            e.printStackTrace(out);
        }
    }

    abstract void writeCommandToServer(byte[] var1, int var2, int var3) throws IOException;

    abstract byte[] nextCommandFromServer(int var1) throws IOException;

    abstract void closeConnection() throws IOException;

    public boolean login(String default_schema, String user, String password, DatabaseCallBack call_back) throws SQLException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            out.writeInt(13553671);
            out.writeInt(1);
            out.writeInt(0);
            byte[] arr = bout.toByteArray();
            this.writeCommandToServer(arr, 0, arr.length);
            byte[] response = this.nextCommandFromServer(0);
            int ack = ByteArrayUtil.getInt(response, 0);
            if (ack == 5) {
                int server_version = 0;
                if (response.length > 4 && response[4] == 1) {
                    server_version = ByteArrayUtil.getInt(response, 5);
                }
                bout.reset();
                out.writeUTF(default_schema);
                out.writeUTF(user);
                out.writeUTF(password);
                arr = bout.toByteArray();
                this.writeCommandToServer(arr, 0, arr.length);
                response = this.nextCommandFromServer(0);
                int result = ByteArrayUtil.getInt(response, 0);
                if (result == 10) {
                    this.database_call_back = call_back;
                    this.connection_thread = new ConnectionThread();
                    this.connection_thread.start();
                    return true;
                }
                if (result == 15) {
                    throw new SQLLoginException("User Authentication failed.");
                }
                throw new SQLException("Unexpected response.");
            }
            throw new SQLException("No acknowledgement received from server.");
        }
        catch (IOException e) {
            RemoteDatabaseInterface.logException(e);
            throw new SQLException("IOException: " + e.getMessage());
        }
    }

    public void pushStreamableObjectPart(byte type, long object_id, long object_length, byte[] buf, long offset, int length) throws SQLException {
        try {
            int dispatch_id = this.connection_thread.pushStreamableObjectPart(type, object_id, object_length, buf, offset, length);
            ServerCommand command = this.connection_thread.getCommand(MDriver.QUERY_TIMEOUT, dispatch_id);
            if (command == null) {
                throw new SQLException("Query timed out after " + MDriver.QUERY_TIMEOUT + " seconds.");
            }
            DataInputStream din = new DataInputStream(command.getInputStream());
            int status = din.readInt();
            if (status == 25) {
                throw new SQLException("Push object failed: " + din.readUTF());
            }
        }
        catch (IOException e) {
            RemoteDatabaseInterface.logException(e);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    public QueryResponse execQuery(SQLQuery sql) throws SQLException {
        try {
            int dispatch_id = this.connection_thread.executeQuery(sql);
            ServerCommand command = this.connection_thread.getCommand(MDriver.QUERY_TIMEOUT, dispatch_id);
            if (command == null) {
                throw new SQLException("Query timed out after " + MDriver.QUERY_TIMEOUT + " seconds.");
            }
            DataInputStream in = new DataInputStream(command.getInputStream());
            int status = in.readInt();
            if (status == 20) {
                final int result_id = in.readInt();
                final int query_time = in.readInt();
                final int row_count = in.readInt();
                final int col_count = in.readInt();
                final ColumnDescription[] col_list = new ColumnDescription[col_count];
                for (int i = 0; i < col_count; ++i) {
                    col_list[i] = ColumnDescription.readFrom(in);
                }
                return new QueryResponse(){

                    public int getResultID() {
                        return result_id;
                    }

                    public int getQueryTimeMillis() {
                        return query_time;
                    }

                    public int getRowCount() {
                        return row_count;
                    }

                    public int getColumnCount() {
                        return col_count;
                    }

                    public ColumnDescription getColumnDescription(int n) {
                        return col_list[n];
                    }

                    public String getWarnings() {
                        return "";
                    }
                };
            }
            if (status == 30) {
                int db_code = in.readInt();
                String message = in.readUTF();
                String stack_trace = in.readUTF();
                throw new MSQLException(message, null, db_code, stack_trace);
            }
            if (status == 35) {
                String access_type = in.readUTF();
                String table_name = in.readUTF();
                throw new SQLException("User doesn't have enough privs to " + access_type + " table " + table_name);
            }
            throw new SQLException("Illegal response code from server.");
        }
        catch (IOException e) {
            RemoteDatabaseInterface.logException(e);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    public ResultPart getResultPart(int result_id, int start_row, int count_rows) throws SQLException {
        try {
            int dispatch_id = this.connection_thread.getResultPart(result_id, start_row, count_rows);
            ServerCommand command = this.connection_thread.getCommand(MDriver.QUERY_TIMEOUT, dispatch_id);
            if (command == null) {
                throw new SQLException("Downloading result part timed out after " + MDriver.QUERY_TIMEOUT + " seconds.");
            }
            DataInputStream din = new DataInputStream(command.getInputStream());
            int status = din.readInt();
            if (status == 20) {
                int col_count = din.readInt();
                int size = count_rows * col_count;
                ResultPart list = new ResultPart(size);
                for (int i = 0; i < size; ++i) {
                    list.addElement(ObjectTransfer.readFrom(din));
                }
                return list;
            }
            if (status == 30) {
                int db_code = din.readInt();
                String message = din.readUTF();
                String stack_trace = din.readUTF();
                throw new SQLException(message, null, db_code);
            }
            throw new SQLException("Illegal response code from server.");
        }
        catch (IOException e) {
            RemoteDatabaseInterface.logException(e);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    public void disposeResult(int result_id) throws SQLException {
        try {
            int dispatch_id = this.connection_thread.disposeResult(result_id);
            ServerCommand command = this.connection_thread.getCommand(MDriver.QUERY_TIMEOUT, dispatch_id);
            if (command == null) {
                throw new SQLException("Dispose result timed out after " + MDriver.QUERY_TIMEOUT + " seconds.");
            }
            DataInputStream din = new DataInputStream(command.getInputStream());
            int status = din.readInt();
            if (status == 25) {
                throw new SQLException("Dispose failed: " + din.readUTF());
            }
        }
        catch (IOException e) {
            RemoteDatabaseInterface.logException(e);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    public StreamableObjectPart getStreamableObjectPart(int result_id, long streamable_object_id, long offset, int len) throws SQLException {
        try {
            int dispatch_id = this.connection_thread.getStreamableObjectPart(result_id, streamable_object_id, offset, len);
            ServerCommand command = this.connection_thread.getCommand(MDriver.QUERY_TIMEOUT, dispatch_id);
            if (command == null) {
                throw new SQLException("getStreamableObjectPart timed out after " + MDriver.QUERY_TIMEOUT + " seconds.");
            }
            DataInputStream din = new DataInputStream(command.getInputStream());
            int status = din.readInt();
            if (status == 20) {
                int contents_size = din.readInt();
                byte[] buf = new byte[contents_size];
                din.readFully(buf, 0, contents_size);
                return new StreamableObjectPart(buf);
            }
            if (status == 30) {
                int db_code = din.readInt();
                String message = din.readUTF();
                String stack_trace = din.readUTF();
                throw new SQLException(message, null, db_code);
            }
            throw new SQLException("Illegal response code from server.");
        }
        catch (IOException e) {
            RemoteDatabaseInterface.logException(e);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    public void disposeStreamableObject(int result_id, long streamable_object_id) throws SQLException {
        try {
            int dispatch_id = this.connection_thread.disposeStreamableObject(result_id, streamable_object_id);
            ServerCommand command = this.connection_thread.getCommand(MDriver.QUERY_TIMEOUT, dispatch_id);
            if (command == null) {
                throw new SQLException("disposeStreamableObject timed out after " + MDriver.QUERY_TIMEOUT + " seconds.");
            }
            DataInputStream din = new DataInputStream(command.getInputStream());
            int status = din.readInt();
            if (status == 25) {
                throw new SQLException("Dispose failed: " + din.readUTF());
            }
        }
        catch (IOException e) {
            RemoteDatabaseInterface.logException(e);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    public void dispose() throws SQLException {
        try {
            int dispatch_id = this.connection_thread.sendCloseCommand();
            this.closeConnection();
        }
        catch (IOException e) {
            RemoteDatabaseInterface.logException(e);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    static class ServerCommand {
        private int dispatch_id;
        private byte[] buf;

        ServerCommand(int dispatch_id, byte[] buf) {
            this.dispatch_id = dispatch_id;
            this.buf = buf;
        }

        public int dispatchID() {
            return this.dispatch_id;
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public ByteArrayInputStream getInputStream() {
            return new ByteArrayInputStream(this.buf, 4, this.buf.length - 4);
        }
    }

    static class MByteArrayOutputStream
    extends ByteArrayOutputStream {
        MByteArrayOutputStream() {
            super(256);
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public int size() {
            return this.count;
        }
    }

    private class ConnectionThread
    extends Thread {
        private MByteArrayOutputStream com_bytes;
        private DataOutputStream com_data;
        private int running_dispatch_id = 1;
        private boolean thread_closed;
        private Vector commands_list;

        ConnectionThread() throws IOException {
            this.setDaemon(true);
            this.setName("Mckoi - Connection Thread");
            this.com_bytes = new MByteArrayOutputStream();
            this.com_data = new DataOutputStream(this.com_bytes);
            this.commands_list = new Vector();
            this.thread_closed = false;
        }

        private int nextDispatchID() {
            return this.running_dispatch_id++;
        }

        ServerCommand getCommand(int timeout, int dispatch_id) throws SQLException {
            long time_in = System.currentTimeMillis();
            long time_out_high = time_in + (long)timeout * 1000L;
            Vector vector = this.commands_list;
            synchronized (vector) {
                if (this.commands_list == null) {
                    throw new SQLException("Connection to server closed");
                }
                while (true) {
                    for (int i = 0; i < this.commands_list.size(); ++i) {
                        ServerCommand command = (ServerCommand)this.commands_list.elementAt(i);
                        if (command.dispatchID() != dispatch_id) continue;
                        this.commands_list.removeElementAt(i);
                        return command;
                    }
                    if (timeout != 0 && System.currentTimeMillis() > time_out_high) {
                        return null;
                    }
                    try {
                        this.commands_list.wait(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }

        private synchronized void flushCommand() throws IOException {
            RemoteDatabaseInterface.this.writeCommandToServer(this.com_bytes.getBuffer(), 0, this.com_bytes.size());
            this.com_bytes.reset();
        }

        synchronized int pushStreamableObjectPart(byte type, long object_id, long object_length, byte[] buf, long offset, int length) throws IOException {
            int dispatch_id = this.nextDispatchID();
            this.com_data.writeInt(63);
            this.com_data.writeInt(dispatch_id);
            this.com_data.writeByte(type);
            this.com_data.writeLong(object_id);
            this.com_data.writeLong(object_length);
            this.com_data.writeInt(length);
            this.com_data.write(buf, 0, length);
            this.com_data.writeLong(offset);
            this.flushCommand();
            return dispatch_id;
        }

        synchronized int executeQuery(SQLQuery sql) throws IOException {
            int dispatch_id = this.nextDispatchID();
            this.com_data.writeInt(50);
            this.com_data.writeInt(dispatch_id);
            sql.writeTo(this.com_data);
            this.flushCommand();
            return dispatch_id;
        }

        synchronized int disposeResult(int result_id) throws IOException {
            int dispatch_id = this.nextDispatchID();
            this.com_data.writeInt(55);
            this.com_data.writeInt(dispatch_id);
            this.com_data.writeInt(result_id);
            this.flushCommand();
            return dispatch_id;
        }

        synchronized int getResultPart(int result_id, int row_number, int row_count) throws IOException {
            int dispatch_id = this.nextDispatchID();
            this.com_data.writeInt(60);
            this.com_data.writeInt(dispatch_id);
            this.com_data.writeInt(result_id);
            this.com_data.writeInt(row_number);
            this.com_data.writeInt(row_count);
            this.flushCommand();
            return dispatch_id;
        }

        synchronized int getStreamableObjectPart(int result_id, long streamable_object_id, long offset, int length) throws IOException {
            int dispatch_id = this.nextDispatchID();
            this.com_data.writeInt(61);
            this.com_data.writeInt(dispatch_id);
            this.com_data.writeInt(result_id);
            this.com_data.writeLong(streamable_object_id);
            this.com_data.writeLong(offset);
            this.com_data.writeInt(length);
            this.flushCommand();
            return dispatch_id;
        }

        synchronized int disposeStreamableObject(int result_id, long streamable_object_id) throws IOException {
            int dispatch_id = this.nextDispatchID();
            this.com_data.writeInt(62);
            this.com_data.writeInt(dispatch_id);
            this.com_data.writeInt(result_id);
            this.com_data.writeLong(streamable_object_id);
            this.flushCommand();
            return dispatch_id;
        }

        synchronized int sendCloseCommand() throws IOException {
            int dispatch_id = this.nextDispatchID();
            this.com_data.writeInt(70);
            this.com_data.writeInt(dispatch_id);
            this.flushCommand();
            return dispatch_id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Vector vector;
            Vector old_commands_list2222;
            try {
                try {
                    while (!this.thread_closed) {
                        byte[] buf = RemoteDatabaseInterface.this.nextCommandFromServer(0);
                        int dispatch_id = ByteArrayUtil.getInt(buf, 0);
                        if (dispatch_id == -1) {
                            this.processEvent(buf);
                        }
                        Vector vector2 = this.commands_list;
                        synchronized (vector2) {
                            this.commands_list.addElement(new ServerCommand(dispatch_id, buf));
                            this.commands_list.notifyAll();
                        }
                    }
                    Object var6_5 = null;
                    vector = old_commands_list2222 = this.commands_list;
                }
                catch (IOException iOException) {
                    Vector old_commands_list2222;
                    Object var6_6 = null;
                    Vector vector2 = old_commands_list2222 = this.commands_list;
                    synchronized (vector2) {
                        this.commands_list = null;
                        old_commands_list2222.notifyAll();
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Vector old_commands_list2222;
                Object var6_7 = null;
                Vector vector4 = old_commands_list2222 = this.commands_list;
                synchronized (vector4) {
                    this.commands_list = null;
                    old_commands_list2222.notifyAll();
                    throw throwable;
                }
            }
            synchronized (vector) {
                this.commands_list = null;
                old_commands_list2222.notifyAll();
                return;
            }
        }

        private void processEvent(byte[] buf) throws IOException {
            int event = ByteArrayUtil.getInt(buf, 4);
            if (event != 65) {
                if (event == 75) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(buf, 8, buf.length - 8);
                    DataInputStream din = new DataInputStream(bin);
                    int event_type = din.readInt();
                    String event_msg = din.readUTF();
                    RemoteDatabaseInterface.this.database_call_back.databaseEvent(event_type, event_msg);
                } else {
                    System.err.println("[RemoteDatabaseInterface] Received unrecognised server side event: " + event);
                }
            }
        }
    }
}

