/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

public class MSQLException
extends SQLException {
    private String server_error_msg;
    private String server_stack_trace;

    public MSQLException(String reason, String SQLState, int vendorCode) {
        super(reason, SQLState, vendorCode);
    }

    public MSQLException(String reason, String SQLState) {
        super(reason, SQLState);
    }

    public MSQLException(String reason) {
        super(reason);
    }

    public MSQLException() {
    }

    public MSQLException(String reason, String server_error_msg, int vendor_code, Throwable server_error) {
        super(reason, null, vendor_code);
        this.server_error_msg = server_error_msg;
        if (server_error != null) {
            StringWriter writer = new StringWriter();
            server_error.printStackTrace(new PrintWriter(writer));
            this.server_stack_trace = writer.toString();
        } else {
            this.server_stack_trace = "<< NO SERVER STACK TRACE >>";
        }
    }

    public MSQLException(String reason, String server_error_msg, int vendor_code, String server_error_trace) {
        super(reason, null, vendor_code);
        this.server_error_msg = server_error_msg;
        this.server_stack_trace = server_error_trace;
    }

    public String getServerErrorMsg() {
        return this.server_error_msg;
    }

    public String getServerErrorStackTrace() {
        return this.server_stack_trace;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            if (this.server_stack_trace != null) {
                s.print("CAUSE: ");
                s.println(this.server_stack_trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            if (this.server_stack_trace != null) {
                s.print("CAUSE: ");
                s.println(this.server_stack_trace);
            }
        }
    }

    public static SQLException unsupported() {
        return new MSQLException("Not Supported");
    }
}

