/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.database.jdbc.MckoiConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MDatabaseMetaData
implements DatabaseMetaData {
    private MConnection connection;
    private String database_name;
    private String database_version;

    MDatabaseMetaData(MConnection connection) {
        this.connection = connection;
    }

    private void queryProductInformation() throws SQLException {
        if (this.database_name == null || this.database_version == null) {
            Statement statement = this.connection.createStatement();
            ResultSet result = statement.executeQuery("SHOW PRODUCT");
            result.next();
            this.database_name = result.getString("name");
            this.database_version = result.getString("version");
            statement.close();
            result.close();
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public String getURL() throws SQLException {
        return this.connection.getURL();
    }

    public String getUserName() throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet result_set = statement.executeQuery("SELECT USER()");
        result_set.next();
        String username = result_set.getString(1);
        result_set.close();
        statement.close();
        return username;
    }

    public boolean isReadOnly() throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet result_set = statement.executeQuery(" SELECT * FROM SYS_INFO.sUSRDatabaseStatistics   WHERE \"stat_name\" = 'DatabaseSystem.read_only' ");
        boolean read_only = result_set.next();
        result_set.close();
        statement.close();
        return read_only;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        this.queryProductInformation();
        return this.database_name;
    }

    public String getDatabaseProductVersion() throws SQLException {
        this.queryProductInformation();
        return this.database_version;
    }

    public String getDriverName() throws SQLException {
        return "Mckoi JDBC Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "1.0";
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        return this.getURL().toLowerCase().startsWith(":jdbc:mckoi:local://");
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "show";
    }

    public String getNumericFunctions() throws SQLException {
        return "";
    }

    public String getStringFunctions() throws SQLException {
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "Schema";
    }

    public String getProcedureTerm() throws SQLException {
        return "Procedure";
    }

    public String getCatalogTerm() throws SQLException {
        return "Catalog";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 32768;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 256;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.getMaxColumnsInSelect();
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 1;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.getMaxColumnsInSelect();
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 4096;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 4096;
    }

    public int getMaxConnections() throws SQLException {
        return 8000;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0x1000000;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 60000;
    }

    public int getMaxStatements() throws SQLException {
        return 1024;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 50;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 512;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 50;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 8;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement("SHOW JDBC_PROCEDURES ( ?, ?, ? )");
        statement.setString(1, catalog);
        statement.setString(2, schemaPattern);
        statement.setString(3, procedureNamePattern);
        return statement.executeQuery();
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement("SHOW JDBC_PROCEDURE_COLUMNS ( ?, ?, ?, ? )");
        statement.setString(1, catalog);
        statement.setString(2, schemaPattern);
        statement.setString(3, procedureNamePattern);
        statement.setString(4, columnNamePattern);
        return statement.executeQuery();
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        int i;
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        String type_part = "";
        int type_size = 0;
        if (types != null && types.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("      AND \"TABLE_TYPE\" IN ( ");
            for (i = 0; i < types.length - 1; ++i) {
                buf.append("?, ");
            }
            buf.append("? ) \n");
            type_size = types.length;
            type_part = new String(buf);
        }
        PreparedStatement stmt = this.connection.prepareStatement("   SELECT * \n     FROM \"SYS_JDBC.Tables\" \n    WHERE \"TABLE_SCHEM\" LIKE ? \n      AND \"TABLE_NAME\" LIKE ? \n" + type_part + " ORDER BY \"TABLE_TYPE\", \"TABLE_SCHEM\", \"TABLE_NAME\" \n");
        stmt.setString(1, schemaPattern);
        stmt.setString(2, tableNamePattern);
        if (type_size > 0) {
            for (i = 0; i < type_size; ++i) {
                stmt.setString(3 + i, types[i]);
            }
        }
        return stmt.executeQuery();
    }

    public ResultSet getSchemas() throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeQuery("    SELECT * \n      FROM SYS_JDBC.Schemas \n  ORDER BY \"TABLE_SCHEM\" ");
    }

    public ResultSet getCatalogs() throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeQuery("SHOW JDBC_CATALOGS");
    }

    public ResultSet getTableTypes() throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeQuery("SHOW JDBC_TABLE_TYPES");
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        PreparedStatement statement = this.connection.prepareStatement("  SELECT * \n    FROM SYS_JDBC.Columns \n   WHERE \"TABLE_SCHEM\" LIKE ? \n     AND \"TABLE_NAME\" LIKE ? \n     AND \"COLUMN_NAME\" LIKE ? \nORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"ORDINAL_POSITION\"");
        statement.setString(1, schemaPattern);
        statement.setString(2, tableNamePattern);
        statement.setString(3, columnNamePattern);
        return statement.executeQuery();
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        PreparedStatement statement = this.connection.prepareStatement("   SELECT * FROM SYS_JDBC.ColumnPrivileges \n    WHERE (? IS NOT NULL OR \"TABLE_SCHEM\" = ? ) \n      AND (? IS NOT NULL OR \"TABLE_NAME\" = ? ) \n      AND \"COLUMN_NAME\" LIKE ? \n ORDER BY \"COLUMN_NAME\", \"PRIVILEGE\" ");
        statement.setString(1, schema);
        statement.setString(2, schema);
        statement.setString(3, table);
        statement.setString(4, table);
        statement.setString(5, columnNamePattern);
        return statement.executeQuery();
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        PreparedStatement statement = this.connection.prepareStatement("   SELECT * FROM SYS_JDBC.TablePrivileges \n    WHERE \"TABLE_SCHEM\" LIKE ? \n      AND \"TABLE_NAME\" LIKE ? \n ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"PRIVILEGE\" ");
        statement.setString(1, schemaPattern);
        statement.setString(2, tableNamePattern);
        return statement.executeQuery();
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement("SHOW JDBC_BEST_ROW_IDENTIFIER ( ?, ?, ?, ?, ? )");
        statement.setString(1, catalog);
        statement.setString(2, schema);
        statement.setString(3, table);
        statement.setInt(4, scope);
        statement.setBoolean(5, nullable);
        return statement.executeQuery();
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement("SHOW JDBC_VERSION_COLUMNS ( ?, ?, ? )");
        statement.setString(1, catalog);
        statement.setString(2, schema);
        statement.setString(3, table);
        return statement.executeQuery();
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("   SELECT * \n     FROM SYS_JDBC.PrimaryKeys \n    WHERE ( ? IS NULL OR \"TABLE_SCHEM\" = ? ) \n      AND \"TABLE_NAME\" = ? \n ORDER BY \"COLUMN_NAME\"");
        stmt.setString(1, schema);
        stmt.setString(2, schema);
        stmt.setString(3, table);
        return stmt.executeQuery();
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("   SELECT * FROM SYS_JDBC.ImportedKeys \n    WHERE ( ? IS NULL OR \"FKTABLE_SCHEM\" = ? )\n      AND \"FKTABLE_NAME\" = ? \nORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"KEY_SEQ\"");
        stmt.setString(1, schema);
        stmt.setString(2, schema);
        stmt.setString(3, table);
        return stmt.executeQuery();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("   SELECT * FROM SYS_JDBC.ImportedKeys \n    WHERE ( ? IS NULL OR \"PKTABLE_SCHEM\" = ? ) \n      AND \"PKTABLE_NAME\" = ? \nORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"KEY_SEQ\"");
        stmt.setString(1, schema);
        stmt.setString(2, schema);
        stmt.setString(3, table);
        return stmt.executeQuery();
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("   SELECT * FROM SYS_JDBC.ImportedKeys \n   WHERE ( ? IS NULL OR \"PKTABLE_SCHEM\" = ? )\n     AND \"PKTABLE_NAME\" = ?\n     AND ( ? IS NULL OR \"FKTABLE_SCHEM\" = ? )\n     AND \"FKTABLE_NAME\" = ?\nORDER BY \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"KEY_SEQ\"\n");
        stmt.setString(1, primarySchema);
        stmt.setString(2, primarySchema);
        stmt.setString(3, primaryTable);
        stmt.setString(4, foreignSchema);
        stmt.setString(5, foreignSchema);
        stmt.setString(6, foreignTable);
        return stmt.executeQuery();
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.connection.createStatement().executeQuery("SELECT * FROM SYS_INFO.sUSRSQLTypeInfo");
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement("SHOW JDBC_INDEX_INFO ( ?, ?, ?, ?, ? )");
        statement.setString(1, catalog);
        statement.setString(2, schema);
        statement.setString(3, table);
        statement.setBoolean(4, unique);
        statement.setBoolean(5, approximate);
        return statement.executeQuery();
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1004;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1004 && concurrency == 1007;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String where_clause = "true";
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                int t = types[i];
                String tstr = "JAVA_OBJECT";
                if (t == 2002) {
                    tstr = "STRUCT";
                } else if (t == 2001) {
                    tstr = "DISTINCT";
                }
                if (i != 0) {
                    where_clause = where_clause + " AND";
                }
                where_clause = where_clause + " DATA_TYPE = '" + MckoiConnection.quote(tstr) + "'";
            }
        }
        PreparedStatement statement = this.connection.prepareStatement("SHOW JDBC_UDTS ( ?, ?, ? ) WHERE " + where_clause);
        statement.setString(1, catalog);
        statement.setString(2, schemaPattern);
        statement.setString(3, typeNamePattern);
        return statement.executeQuery();
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw MSQLException.unsupported();
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw MSQLException.unsupported();
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw MSQLException.unsupported();
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        throw MSQLException.unsupported();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        throw MSQLException.unsupported();
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        throw MSQLException.unsupported();
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        throw MSQLException.unsupported();
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }
}

