/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class BinaryToUnicodeReader
extends Reader {
    private InputStream input;

    public BinaryToUnicodeReader(InputStream input) {
        this.input = input;
    }

    public int read() throws IOException {
        int v1 = this.input.read();
        if (v1 == -1) {
            return -1;
        }
        int v2 = this.input.read();
        if (v2 == -1) {
            return -1;
        }
        return (v1 << 8) + v2;
    }

    public int read(char[] buf, int off, int len) throws IOException {
        if (len < 0) {
            throw new IOException("len < 0");
        }
        if (off < 0 || off + len > buf.length) {
            throw new IOException("Out of bounds.");
        }
        if (len == 0) {
            return 0;
        }
        int read = 0;
        while (len > 0) {
            int v = this.read();
            if (v == -1) {
                if (read == 0) {
                    return -1;
                }
                return read;
            }
            buf[off] = (char)v;
            ++off;
            ++read;
            --len;
        }
        return read;
    }

    public long skip(long n) throws IOException {
        return this.input.skip(n * 2L) / 2L;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        this.input.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.input.reset();
    }

    public void close() throws IOException {
        this.input.close();
    }
}

