/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.Privileges;
import com.mckoi.database.QueryPlan;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.StatementException;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.Variable;
import com.mckoi.database.ViewDef;
import com.mckoi.database.interpret.Planner;
import com.mckoi.database.interpret.Select;
import com.mckoi.database.interpret.Statement;
import com.mckoi.database.interpret.TableExpressionFromSet;
import com.mckoi.database.interpret.TableSelectExpression;
import java.util.ArrayList;

public class ViewManager
extends Statement {
    private String type;
    private String view_name;
    private TableName vname;
    private TableSelectExpression select_expression;
    private QueryPlanNode plan;

    public void prepare() throws DatabaseException {
        this.type = (String)this.cmd.getObject("type");
        this.view_name = (String)this.cmd.getObject("view_name");
        String schema_name = this.database.getCurrentSchema();
        this.vname = TableName.resolve(schema_name, this.view_name);
        this.vname = this.database.tryResolveCase(this.vname);
        if (this.type.equals("create")) {
            int i;
            this.select_expression = (TableSelectExpression)this.cmd.getObject("select_expression");
            ArrayList col_list = (ArrayList)this.cmd.getObject("column_list");
            TableExpressionFromSet from_set = Planner.generateFromSet(this.select_expression, this.database);
            this.plan = Planner.formQueryPlan(this.database, this.select_expression, from_set, new ArrayList());
            int sz = col_list == null ? 0 : col_list.size();
            Variable[] original_vars = from_set.generateResolvedVariableList();
            Variable[] new_column_vars = new Variable[original_vars.length];
            if (sz > 0) {
                if (sz != original_vars.length) {
                    throw new StatementException("Column list is not the same size as the columns selected.");
                }
                for (i = 0; i < sz; ++i) {
                    String col_name = (String)col_list.get(i);
                    new_column_vars[i] = new Variable(this.vname, col_name);
                }
            } else {
                sz = original_vars.length;
                for (i = 0; i < sz; ++i) {
                    new_column_vars[i] = new Variable(this.vname, original_vars[i].getName());
                }
            }
            for (i = 0; i < sz; ++i) {
                Variable cur_v = new_column_vars[i];
                for (int n = i + 1; n < sz; ++n) {
                    if (!new_column_vars[n].equals(cur_v)) continue;
                    throw new DatabaseException("Duplicate column name '" + cur_v + "' in view.  " + "A view may not contain duplicate column names.");
                }
            }
            this.plan = new QueryPlan.SubsetNode(this.plan, original_vars, new_column_vars);
        }
    }

    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        if (this.type.equals("create")) {
            QueryPlanNode plan_copy;
            if (!this.database.getDatabase().canUserCreateTableObject(context, this.user, this.vname)) {
                throw new UserAccessException("User not permitted to create view: " + this.view_name);
            }
            boolean ignore_case = this.database.isInCaseInsensitiveMode();
            SchemaDef schema = this.database.resolveSchemaCase(this.vname.getSchema(), ignore_case);
            if (schema == null) {
                throw new DatabaseException("Schema '" + this.vname.getSchema() + "' doesn't exist.");
            }
            this.vname = new TableName(schema.getName(), this.vname.getName());
            Select.checkUserSelectPermissions(context, this.user, this.plan);
            if (this.database.tableExists(this.vname)) {
                throw new DatabaseException("View or table with name '" + this.vname + "' already exists.");
            }
            try {
                plan_copy = (QueryPlanNode)this.plan.clone();
            }
            catch (CloneNotSupportedException e) {
                this.Debug().writeException(e);
                throw new DatabaseException("Clone error: " + e.getMessage());
            }
            Table t = this.plan.evaluate(context);
            DataTableDef data_table_def = new DataTableDef(t.getDataTableDef());
            data_table_def.setTableName(this.vname);
            ViewDef view_def = new ViewDef(data_table_def, plan_copy);
            this.database.createView(this.query, view_def);
            this.database.getGrantManager().addGrant(Privileges.TABLE_ALL_PRIVS, 1, this.vname.toString(), this.user.getUserName(), true, "@SYSTEM");
        } else if (this.type.equals("drop")) {
            if (!this.database.getDatabase().canUserDropTableObject(context, this.user, this.vname)) {
                throw new UserAccessException("User not permitted to drop view: " + this.view_name);
            }
            this.database.dropView(this.vname);
            this.database.getGrantManager().revokeAllGrantsOnObject(1, this.vname.toString());
        } else {
            throw new Error("Unknown view command type: " + this.type);
        }
        return FunctionTable.resultTable(context, 0);
    }
}

