/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.Assignment;
import com.mckoi.database.DataTable;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.FunctionTable;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.StatementException;
import com.mckoi.database.Table;
import com.mckoi.database.TableName;
import com.mckoi.database.TriggerEvent;
import com.mckoi.database.UserAccessException;
import com.mckoi.database.Variable;
import com.mckoi.database.interpret.Planner;
import com.mckoi.database.interpret.SearchExpression;
import com.mckoi.database.interpret.Select;
import com.mckoi.database.interpret.Statement;
import com.mckoi.database.interpret.TableExpressionFromSet;
import com.mckoi.database.interpret.TableSelectExpression;
import java.util.ArrayList;

public class UpdateTable
extends Statement {
    String table_name;
    ArrayList column_sets;
    SearchExpression where_condition;
    int limit = -1;
    private ArrayList relationally_linked_tables;
    private DataTable update_table;
    private TableName tname;
    private QueryPlanNode plan;

    public void prepare() throws DatabaseException {
        this.table_name = (String)this.cmd.getObject("table_name");
        this.column_sets = (ArrayList)this.cmd.getObject("assignments");
        this.where_condition = (SearchExpression)this.cmd.getObject("where_clause");
        this.limit = this.cmd.getInt("limit");
        this.tname = this.resolveTableName(this.table_name, this.database);
        if (!this.database.tableExists(this.tname)) {
            throw new DatabaseException("Table '" + this.tname + "' does not exist.");
        }
        this.update_table = this.database.getTable(this.tname);
        TableSelectExpression select_expression = new TableSelectExpression();
        select_expression.from_clause.addTable(this.table_name);
        select_expression.where_clause = this.where_condition;
        TableExpressionFromSet from_set = Planner.generateFromSet(select_expression, this.database);
        this.plan = Planner.formQueryPlan(this.database, select_expression, from_set, null);
        for (int i = 0; i < this.column_sets.size(); ++i) {
            Assignment assignment = (Assignment)this.column_sets.get(i);
            Variable orig_var = assignment.getVariable();
            Variable new_var = from_set.resolveReference(orig_var);
            if (new_var == null) {
                throw new StatementException("Reference not found: " + orig_var);
            }
            orig_var.set(new_var);
            assignment.prepareExpressions(from_set.expressionQualifier());
        }
        TableName[] linked_tables = this.database.queryTablesRelationallyLinkedTo(this.tname);
        this.relationally_linked_tables = new ArrayList(linked_tables.length);
        for (int i = 0; i < linked_tables.length; ++i) {
            this.relationally_linked_tables.add(this.database.getTable(linked_tables[i]));
        }
    }

    public Table evaluate() throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.database);
        Variable[] col_var_list = new Variable[this.column_sets.size()];
        for (int i = 0; i < col_var_list.length; ++i) {
            Assignment assign = (Assignment)this.column_sets.get(i);
            col_var_list[i] = assign.getVariable();
        }
        if (!this.database.getDatabase().canUserUpdateTableObject(context, this.user, this.tname, col_var_list)) {
            throw new UserAccessException("User not permitted to update table: " + this.table_name);
        }
        Select.checkUserSelectPermissions(context, this.user, this.plan);
        Table update_set = this.plan.evaluate(context);
        Assignment[] assign_list = new Assignment[this.column_sets.size()];
        assign_list = this.column_sets.toArray(assign_list);
        int update_count = this.update_table.update(context, update_set, assign_list, this.limit);
        if (update_count > 0) {
            this.database.notifyTriggerEvent(new TriggerEvent(3, this.tname.toString(), update_count));
        }
        return FunctionTable.resultTable(context, update_count);
    }
}

