/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.CompositeTable;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.StatementTree;
import com.mckoi.database.StatementTreeObject;
import com.mckoi.database.Variable;
import com.mckoi.database.interpret.FromClause;
import com.mckoi.database.interpret.SearchExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class TableSelectExpression
implements Serializable,
StatementTreeObject,
Cloneable {
    static final long serialVersionUID = 6946017316981412561L;
    public boolean distinct = false;
    public ArrayList columns = new ArrayList();
    public FromClause from_clause = new FromClause();
    public SearchExpression where_clause = new SearchExpression();
    public ArrayList group_by = new ArrayList();
    public Variable group_max = null;
    public SearchExpression having_clause = new SearchExpression();
    int composite_function = -1;
    boolean is_composite_all;
    TableSelectExpression next_composite;

    public void chainComposite(TableSelectExpression expression, String composite, boolean is_all) {
        this.next_composite = expression;
        if ((composite = composite.toLowerCase()).equals("union")) {
            this.composite_function = CompositeTable.UNION;
        } else if (composite.equals("intersect")) {
            this.composite_function = CompositeTable.INTERSECT;
        } else if (composite.equals("except")) {
            this.composite_function = CompositeTable.EXCEPT;
        } else {
            throw new Error("Don't understand composite function '" + composite + "'");
        }
        this.is_composite_all = is_all;
    }

    private static void prepareAllInList(List list, ExpressionPreparer preparer) throws DatabaseException {
        for (int n = 0; n < list.size(); ++n) {
            StatementTreeObject ob = (StatementTreeObject)list.get(n);
            ob.prepareExpressions(preparer);
        }
    }

    public void prepareExpressions(ExpressionPreparer preparer) throws DatabaseException {
        TableSelectExpression.prepareAllInList(this.columns, preparer);
        this.from_clause.prepareExpressions(preparer);
        this.where_clause.prepareExpressions(preparer);
        TableSelectExpression.prepareAllInList(this.group_by, preparer);
        this.having_clause.prepareExpressions(preparer);
        if (this.next_composite != null) {
            this.next_composite.prepareExpressions(preparer);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TableSelectExpression v = (TableSelectExpression)super.clone();
        if (this.columns != null) {
            v.columns = (ArrayList)StatementTree.cloneSingleObject(this.columns);
        }
        if (this.from_clause != null) {
            v.from_clause = (FromClause)this.from_clause.clone();
        }
        if (this.where_clause != null) {
            v.where_clause = (SearchExpression)this.where_clause.clone();
        }
        if (this.group_by != null) {
            v.group_by = (ArrayList)StatementTree.cloneSingleObject(this.group_by);
        }
        if (this.group_max != null) {
            v.group_max = (Variable)this.group_max.clone();
        }
        if (this.having_clause != null) {
            v.having_clause = (SearchExpression)this.having_clause.clone();
        }
        if (this.next_composite != null) {
            v.next_composite = (TableSelectExpression)this.next_composite.clone();
        }
        return v;
    }
}

